"""
sutton_signwriting_core – public entry point.
"""

from __future__ import annotations

from .symid_arr import symid_arr

from .regex import (
    fsw_pattern_null,
    fsw_pattern_symbol,
    fsw_pattern_number,
    fsw_pattern_sort,
    fsw_pattern_box,
    fsw_pattern_null_or_symbol,
    fsw_pattern_prefix,
    fsw_pattern_coord,
    fsw_pattern_spatial,
    fsw_pattern_signbox,
    fsw_pattern_sign,
    fsw_pattern_sortable,
    fswquery_pattern_null,
    fswquery_pattern_base,
    fswquery_pattern_coord,
    fswquery_pattern_var,
    fswquery_pattern_symbol,
    fswquery_pattern_null_or_symbol,
    fswquery_pattern_range,
    fswquery_pattern_item,
    fswquery_pattern_list,
    fswquery_pattern_prefix,
    fswquery_pattern_signbox,
    fswquery_pattern_full,
    style_pattern_colorize,
    style_pattern_colorhex,
    style_pattern_colorname,
    style_pattern_padding,
    style_pattern_zoom,
    style_pattern_classbase,
    style_pattern_id,
    style_pattern_colorbase,
    style_pattern_color,
    style_pattern_colors,
    style_pattern_background,
    style_pattern_detail,
    style_pattern_detailsym,
    style_pattern_classes,
    style_pattern_full_groups,
    style_pattern_full,
    swu_pattern_null,
    swu_pattern_symbol,
    swu_pattern_number,
    swu_pattern_sort,
    swu_pattern_box,
    swu_pattern_null_or_symbol,
    swu_pattern_prefix,
    swu_pattern_coord,
    swu_pattern_spatial,
    swu_pattern_signbox,
    swu_pattern_sign,
    swu_pattern_sortable,
    swuquery_pattern_null,
    swuquery_pattern_base,
    swuquery_pattern_coord,
    swuquery_pattern_var,
    swuquery_pattern_symbol,
    swuquery_pattern_null_or_symbol,
    swuquery_pattern_range,
    swuquery_pattern_item,
    swuquery_pattern_list,
    swuquery_pattern_prefix,
    swuquery_pattern_signbox,
    swuquery_pattern_full,
)

from .convert import (
    swu_to_mark,
    mark_to_swu,
    swu_to_num,
    num_to_swu,
    swu_to_coord,
    coord_to_swu,
    fsw_to_coord,
    coord_to_fsw,
    swu_to_code,
    code_to_swu,
    swu_to_id,
    id_to_swu,
    key_to_id,
    id_to_key,
    swu_to_key,
    key_to_swu,
    swu_to_fsw,
    fsw_to_swu,
    symid_max,
    symid_min,
    symid_to_key,
    key_to_symid,
)

from .fsw import (
    fsw_structure_kind,
    fsw_structure_category,
    fsw_structure_group,
    fsw_structure_ranges,
    fsw_is_type,
    fsw_colors,
    fsw_colorize,
    fsw_parse_symbol,
    fsw_parse_sign,
    fsw_parse_text,
    fsw_compose_symbol,
    fsw_compose_sign,
    fsw_info,
    fsw_column_defaults,
    fsw_column_defaults_merge,
    fsw_columns,
    fsw_tokenize,
    fsw_detokenize,
    fsw_chunk_tokens,
    FSWTokenizer,
)

from .fswquery import (
    fswquery_parse,
    fswquery_compose,
    fsw_to_query,
    fswquery_range,
    fswquery_regex,
    fswquery_results,
    fswquery_lines,
)

from .style import (
    style_parse,
    style_compose,
    style_rgb_to_hex,
    style_rgba_to_hex,
    style_merge,
)

from .swu import (
    swu_structure_kind,
    swu_structure_category,
    swu_structure_group,
    swu_structure_ranges,
    swu_is_type,
    swu_colors,
    swu_colorize,
    swu_parse_symbol,
    swu_parse_sign,
    swu_parse_text,
    swu_compose_symbol,
    swu_compose_sign,
    swu_info,
    swu_column_defaults,
    swu_column_defaults_merge,
    swu_columns,
)

from .swuquery import (
    swuquery_parse,
    swuquery_compose,
    swu_to_query,
    swuquery_range,
    swuquery_regex,
    swuquery_results,
    swuquery_lines,
)


__all__ = [
    # FSW patterns
    "fsw_pattern_null",
    "fsw_pattern_symbol",
    "fsw_pattern_number",
    "fsw_pattern_sort",
    "fsw_pattern_box",
    "fsw_pattern_null_or_symbol",
    "fsw_pattern_prefix",
    "fsw_pattern_coord",
    "fsw_pattern_spatial",
    "fsw_pattern_signbox",
    "fsw_pattern_sign",
    "fsw_pattern_sortable",
    # FSW query patterns
    "fswquery_pattern_null",
    "fswquery_pattern_base",
    "fswquery_pattern_coord",
    "fswquery_pattern_var",
    "fswquery_pattern_symbol",
    "fswquery_pattern_null_or_symbol",
    "fswquery_pattern_range",
    "fswquery_pattern_item",
    "fswquery_pattern_list",
    "fswquery_pattern_prefix",
    "fswquery_pattern_signbox",
    "fswquery_pattern_full",
    # Style patterns
    "style_pattern_colorize",
    "style_pattern_colorhex",
    "style_pattern_colorname",
    "style_pattern_padding",
    "style_pattern_zoom",
    "style_pattern_classbase",
    "style_pattern_id",
    "style_pattern_colorbase",
    "style_pattern_color",
    "style_pattern_colors",
    "style_pattern_background",
    "style_pattern_detail",
    "style_pattern_detailsym",
    "style_pattern_classes",
    "style_pattern_full_groups",
    "style_pattern_full",
    # SWU patterns
    "swu_pattern_null",
    "swu_pattern_symbol",
    "swu_pattern_number",
    "swu_pattern_sort",
    "swu_pattern_box",
    "swu_pattern_null_or_symbol",
    "swu_pattern_prefix",
    "swu_pattern_coord",
    "swu_pattern_spatial",
    "swu_pattern_signbox",
    "swu_pattern_sign",
    "swu_pattern_sortable",
    # SWU query patterns
    "swuquery_pattern_null",
    "swuquery_pattern_base",
    "swuquery_pattern_coord",
    "swuquery_pattern_var",
    "swuquery_pattern_symbol",
    "swuquery_pattern_null_or_symbol",
    "swuquery_pattern_range",
    "swuquery_pattern_item",
    "swuquery_pattern_list",
    "swuquery_pattern_prefix",
    "swuquery_pattern_signbox",
    "swuquery_pattern_full",
    # Text conversion
    "swu_to_fsw",
    "fsw_to_swu",
    # Symbol ↔ key ↔ id
    "key_to_swu",
    "swu_to_key",
    "key_to_id",
    "id_to_key",
    # Markers / numbers / coordinates
    "swu_to_mark",
    "mark_to_swu",
    "swu_to_num",
    "num_to_swu",
    "swu_to_coord",
    "coord_to_swu",
    "fsw_to_coord",
    "coord_to_fsw",
    # Low-level symbol helpers
    "swu_to_code",
    "code_to_swu",
    "swu_to_id",
    "id_to_swu",
    # Symid helpers
    "symid_max",
    "symid_min",
    "symid_to_key",
    "key_to_symid",
    # Constant
    "symid_arr",
    # FSW
    "fsw_structure_kind",
    "fsw_structure_category",
    "fsw_structure_group",
    "fsw_structure_ranges",
    "fsw_is_type",
    "fsw_colors",
    "fsw_colorize",
    "fsw_parse_symbol",
    "fsw_parse_sign",
    "fsw_parse_text",
    "fsw_compose_symbol",
    "fsw_compose_sign",
    "fsw_info",
    "fsw_column_defaults",
    "fsw_column_defaults_merge",
    "fsw_columns",
    "fsw_tokenize",
    "fsw_detokenize",
    "fsw_chunk_tokens",
    "fsw_create_tokenizer",
    "FSWTokenizer",
    # FSW Query
    "fswquery_parse",
    "fswquery_compose",
    "fsw_to_query",
    "fswquery_range",
    "fswquery_regex",
    "fswquery_results",
    "fswquery_lines",
    # Style
    "style_parse",
    "style_compose",
    "style_rgb_to_hex",
    "style_rgba_to_hex",
    "style_merge",
    # SWU
    "swu_structure_kind",
    "swu_structure_category",
    "swu_structure_group",
    "swu_structure_ranges",
    "swu_is_type",
    "swu_colors",
    "swu_colorize",
    "swu_parse_symbol",
    "swu_parse_sign",
    "swu_parse_text",
    "swu_compose_symbol",
    "swu_compose_sign",
    "swu_info",
    "swu_column_defaults",
    "swu_column_defaults_merge",
    "swu_columns",
    # SWU Query
    "swuquery_parse",
    "swuquery_compose",
    "swu_to_query",
    "swuquery_range",
    "swuquery_regex",
    "swuquery_results",
    "swuquery_lines",
]

__version__ = "1.0.1"
