# This file was automatically generated by `python.ts`.
# Do not modify it by hand. Instead, modify the source `.schema.yaml` files
# in the `schema` directory and run `npm run build:python` to regenerate it.
"""Python classes for schema types."""

# List is imported as Array to avoid conflict with the schema's List type
from typing import Any, Dict, List as Array, Optional, Union
from enum import Enum

ECitationMode = Enum("CitationMode", ["Parenthetical", "Narrative", "NarrativeAuthor", "NarrativeYear", "normal", "suppressAuthor"])

EClaimType = Enum("ClaimType", ["Statement", "Theorem", "Lemma", "Proof", "Postulate", "Hypothesis", "Proposition", "Corollary"])

EItemListOrder = Enum("ItemListOrder", ["Ascending", "Descending", "Unordered"])

ENoteType = Enum("NoteType", ["Footnote", "Endnote", "Sidenote"])

ESessionStatus = Enum("SessionStatus", ["Unknown", "Starting", "Started", "Stopping", "Stopped", "Failed"])

ECellType = Enum("CellType", ["Data", "Header"])

ERowType = Enum("RowType", ["Header", "Footer"])


class Entity:
    """
    The most simple compound (ie. non-atomic like `number`, `string` etc) type.
    """

    id: Optional[str] = None
    """The identifier for this item."""

    meta: Optional[Dict[str, Any]] = None
    """Metadata associated with this item."""


    def __init__(
        self,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(

        )
        if id is not None:
            self.id = id
        if meta is not None:
            self.meta = meta


class Cite(Entity):
    """A reference to a CreativeWork that is cited in another CreativeWork."""

    target: str
    """The target of the citation (URL or reference ID)."""

    citationIntent: Optional[Array["CitationIntentEnumeration"]] = None
    """The type/s of the citation, both factually and rhetorically."""

    citationMode: Optional["ECitationMode"] = None
    """Determines how the citation is shown within the surrounding text."""

    citationPrefix: Optional[str] = None
    """Text to show before the citation."""

    citationSuffix: Optional[str] = None
    """Text to show after the citation."""

    content: Optional[Array["InlineContent"]] = None
    """Optional structured content/text of this citation."""

    pageEnd: Optional[Union[int, str]] = None
    """The page on which the work ends; for example "138" or "xvi"."""

    pageStart: Optional[Union[int, str]] = None
    """The page on which the work starts; for example "135" or "xiii"."""

    pagination: Optional[str] = None
    """Any description of pages that is not separated into pageStart and pageEnd;
for example, "1-6, 9, 55".
"""


    def __init__(
        self,
        target: str,
        citationIntent: Optional[Array["CitationIntentEnumeration"]] = None,
        citationMode: Optional["ECitationMode"] = None,
        citationPrefix: Optional[str] = None,
        citationSuffix: Optional[str] = None,
        content: Optional[Array["InlineContent"]] = None,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        pageEnd: Optional[Union[int, str]] = None,
        pageStart: Optional[Union[int, str]] = None,
        pagination: Optional[str] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if target is not None:
            self.target = target
        if citationIntent is not None:
            self.citationIntent = citationIntent
        if citationMode is not None:
            self.citationMode = citationMode
        if citationPrefix is not None:
            self.citationPrefix = citationPrefix
        if citationSuffix is not None:
            self.citationSuffix = citationSuffix
        if content is not None:
            self.content = content
        if pageEnd is not None:
            self.pageEnd = pageEnd
        if pageStart is not None:
            self.pageStart = pageStart
        if pagination is not None:
            self.pagination = pagination


class CiteGroup(Entity):
    """A group of Cite nodes."""

    items: Array["Cite"]
    """One or more `Cite`s to be referenced in the same surrounding text."""


    def __init__(
        self,
        items: Array["Cite"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if items is not None:
            self.items = items


class Code(Entity):
    """Base type for code nodes e.g. CodeBlock, CodeExpression."""

    text: str
    """The text of the code."""

    mediaType: Optional[str] = None
    """Media type, typically expressed using a MIME format, of the code."""

    programmingLanguage: Optional[str] = None
    """The programming language of the code."""


    def __init__(
        self,
        text: str,
        id: Optional[str] = None,
        mediaType: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        programmingLanguage: Optional[str] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if text is not None:
            self.text = text
        if mediaType is not None:
            self.mediaType = mediaType
        if programmingLanguage is not None:
            self.programmingLanguage = programmingLanguage


class CodeBlock(Code):
    """A code block."""

    exportFrom: Optional[str] = None
    """A compilation directive giving the name of the variable to export
into the content of the code block.
"""

    importTo: Optional[str] = None
    """A compilation directive giving the name of the variable to import
the content of the code block as.
"""


    def __init__(
        self,
        text: str,
        exportFrom: Optional[str] = None,
        id: Optional[str] = None,
        importTo: Optional[str] = None,
        mediaType: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        programmingLanguage: Optional[str] = None
    ) -> None:
        super().__init__(
            text=text,
            id=id,
            mediaType=mediaType,
            meta=meta,
            programmingLanguage=programmingLanguage
        )
        if exportFrom is not None:
            self.exportFrom = exportFrom
        if importTo is not None:
            self.importTo = importTo


class CodeChunk(CodeBlock):
    """A executable chunk of code."""

    alters: Optional[Array[str]] = None
    """Names of variables that the code chunk alters."""

    assigns: Optional[Array[Union["Variable", str]]] = None
    """Variables that the code chunk assigns to."""

    caption: Optional[Union[Array["BlockContent"], str]] = None
    """A caption for the CodeChunk."""

    declares: Optional[Array[Union["Variable", "Function", str]]] = None
    """Variables that the code chunk declares."""

    duration: Optional[float] = None
    """Duration in seconds of the last execution of the chunk."""

    errors: Optional[Array["CodeError"]] = None
    """Errors when compiling or executing the chunk."""

    imports: Optional[Array[Union["SoftwareSourceCode", "SoftwareApplication", str]]] = None
    """Software packages that the code chunk imports"""

    label: Optional[str] = None
    """A short label for the CodeChunk."""

    outputs: Optional[Array["Any"]] = None
    """Outputs from executing the chunk."""

    reads: Optional[Array[str]] = None
    """Filesystem paths that this code chunk reads from."""

    uses: Optional[Array[Union["Variable", str]]] = None
    """Names of variables that the code chunk uses (but does not alter)."""


    def __init__(
        self,
        text: str,
        alters: Optional[Array[str]] = None,
        assigns: Optional[Array[Union["Variable", str]]] = None,
        caption: Optional[Union[Array["BlockContent"], str]] = None,
        declares: Optional[Array[Union["Variable", "Function", str]]] = None,
        duration: Optional[float] = None,
        errors: Optional[Array["CodeError"]] = None,
        exportFrom: Optional[str] = None,
        id: Optional[str] = None,
        importTo: Optional[str] = None,
        imports: Optional[Array[Union["SoftwareSourceCode", "SoftwareApplication", str]]] = None,
        label: Optional[str] = None,
        mediaType: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        outputs: Optional[Array["Any"]] = None,
        programmingLanguage: Optional[str] = None,
        reads: Optional[Array[str]] = None,
        uses: Optional[Array[Union["Variable", str]]] = None
    ) -> None:
        super().__init__(
            text=text,
            exportFrom=exportFrom,
            id=id,
            importTo=importTo,
            mediaType=mediaType,
            meta=meta,
            programmingLanguage=programmingLanguage
        )
        if alters is not None:
            self.alters = alters
        if assigns is not None:
            self.assigns = assigns
        if caption is not None:
            self.caption = caption
        if declares is not None:
            self.declares = declares
        if duration is not None:
            self.duration = duration
        if errors is not None:
            self.errors = errors
        if imports is not None:
            self.imports = imports
        if label is not None:
            self.label = label
        if outputs is not None:
            self.outputs = outputs
        if reads is not None:
            self.reads = reads
        if uses is not None:
            self.uses = uses


class CodeFragment(Code):
    """Inline code."""

    def __init__(
        self,
        text: str,
        id: Optional[str] = None,
        mediaType: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        programmingLanguage: Optional[str] = None
    ) -> None:
        super().__init__(
            text=text,
            id=id,
            mediaType=mediaType,
            meta=meta,
            programmingLanguage=programmingLanguage
        )



class CodeExpression(CodeFragment):
    """An expression defined in programming language source code."""

    errors: Optional[Array["CodeError"]] = None
    """Errors when compiling or executing the chunk."""

    output: Optional["Any"] = None
    """The value of the expression when it was last evaluated."""


    def __init__(
        self,
        text: str,
        errors: Optional[Array["CodeError"]] = None,
        id: Optional[str] = None,
        mediaType: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        output: Optional["Any"] = None,
        programmingLanguage: Optional[str] = None
    ) -> None:
        super().__init__(
            text=text,
            id=id,
            mediaType=mediaType,
            meta=meta,
            programmingLanguage=programmingLanguage
        )
        if errors is not None:
            self.errors = errors
        if output is not None:
            self.output = output


class CodeError(Entity):
    """
    An error that occurred when parsing, compiling or executing a Code node.
    """

    errorMessage: str
    """The error message or brief description of the error."""

    errorType: Optional[str] = None
    """The type of error e.g. "SyntaxError", "ZeroDivisionError"."""

    stackTrace: Optional[str] = None
    """Stack trace leading up to the error."""


    def __init__(
        self,
        errorMessage: str,
        errorType: Optional[str] = None,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        stackTrace: Optional[str] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if errorMessage is not None:
            self.errorMessage = errorMessage
        if errorType is not None:
            self.errorType = errorType
        if stackTrace is not None:
            self.stackTrace = stackTrace


class Date(Entity):
    """A date encoded as a ISO 8601 string."""

    value: str
    """The date as an ISO 8601 string."""


    def __init__(
        self,
        value: str,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if value is not None:
            self.value = value


class Mark(Entity):
    """
    A base class for nodes that mark some other inline content in some way
    (e.g. as being emphasised, or quoted).
    """

    content: Array["InlineContent"]
    """The content that is marked."""


    def __init__(
        self,
        content: Array["InlineContent"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if content is not None:
            self.content = content


class Delete(Mark):
    """Content that is marked for deletion"""

    def __init__(
        self,
        content: Array["InlineContent"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            content=content,
            id=id,
            meta=meta
        )



class Emphasis(Mark):
    """Emphasised content."""

    def __init__(
        self,
        content: Array["InlineContent"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            content=content,
            id=id,
            meta=meta
        )



class Thing(Entity):
    """The most generic type of item."""

    alternateNames: Optional[Array[str]] = None
    """Alternate names (aliases) for the item."""

    description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None
    """A description of the item."""

    identifiers: Optional[Array[Union["PropertyValue", str]]] = None
    """Any kind of identifier for any kind of Thing."""

    images: Optional[Array[Union["ImageObject", str]]] = None
    """Images of the item."""

    name: Optional[str] = None
    """The name of the item."""

    url: Optional[str] = None
    """The URL of the item."""


    def __init__(
        self,
        alternateNames: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if alternateNames is not None:
            self.alternateNames = alternateNames
        if description is not None:
            self.description = description
        if identifiers is not None:
            self.identifiers = identifiers
        if images is not None:
            self.images = images
        if name is not None:
            self.name = name
        if url is not None:
            self.url = url


class Brand(Thing):
    """
    A brand used by an organization or person for labeling a product, product
    group, or similar.
    """

    name: str # type: ignore
    """The name of the item."""

    logo: Optional[Union["ImageObject", str]] = None
    """A logo associated with the brand."""

    reviews: Optional[Array[str]] = None
    """Reviews of the brand."""


    def __init__(
        self,
        name: str,
        alternateNames: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        logo: Optional[Union["ImageObject", str]] = None,
        meta: Optional[Dict[str, Any]] = None,
        reviews: Optional[Array[str]] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            name=name,
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            url=url
        )
        if name is not None:
            self.name = name
        if logo is not None:
            self.logo = logo
        if reviews is not None:
            self.reviews = reviews


class ContactPoint(Thing):
    """A contact point, usually within an organization."""

    availableLanguages: Optional[Array[str]] = None
    """Languages (human not programming) in which it is possible to communicate
with the organization/department etc.
"""

    emails: Optional[Array[str]] = None
    """Email address for correspondence."""

    telephoneNumbers: Optional[Array[str]] = None
    """Telephone numbers for the contact point."""


    def __init__(
        self,
        alternateNames: Optional[Array[str]] = None,
        availableLanguages: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        emails: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        telephoneNumbers: Optional[Array[str]] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            url=url
        )
        if availableLanguages is not None:
            self.availableLanguages = availableLanguages
        if emails is not None:
            self.emails = emails
        if telephoneNumbers is not None:
            self.telephoneNumbers = telephoneNumbers


class CreativeWork(Thing):
    """
    A creative work, including books, movies, photographs, software programs,
    etc.
    """

    about: Optional[Array["ThingTypes"]] = None
    """The subject matter of the content."""

    authors: Optional[Array[Union["Person", "Organization"]]] = None
    """The authors of this creative work."""

    comments: Optional[Array["Comment"]] = None
    """Comments about this creative work."""

    content: Optional[Union[Array["Any"], str]] = None
    """The structured content of this creative work c.f. property `text`."""

    dateAccepted: Optional["Date"] = None
    """Date/time of acceptance."""

    dateCreated: Optional["Date"] = None
    """Date/time of creation."""

    dateModified: Optional["Date"] = None
    """Date/time of most recent modification."""

    datePublished: Optional["Date"] = None
    """Date of first publication."""

    dateReceived: Optional["Date"] = None
    """Date/time that work was received."""

    editors: Optional[Array["Person"]] = None
    """People who edited the `CreativeWork`."""

    fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None
    """Grants that funded the `CreativeWork`; reverse of `fundedItems`."""

    funders: Optional[Array[Union["Person", "Organization"]]] = None
    """People or organizations that funded the `CreativeWork`."""

    genre: Optional[Array[str]] = None
    """Genre of the creative work, broadcast channel or group."""

    isPartOf: Optional["CreativeWorkTypes"] = None
    """An item or other CreativeWork that this CreativeWork is a part of.
"""

    keywords: Optional[Array[str]] = None
    """Keywords or tags used to describe this content.
Multiple entries in a keywords list are typically delimited by commas.
"""

    licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None
    """License documents that applies to this content, typically indicated by URL.
"""

    maintainers: Optional[Array[Union["Person", "Organization"]]] = None
    """The people or organizations who maintain this CreativeWork."""

    parts: Optional[Array["CreativeWorkTypes"]] = None
    """Elements of the collection which can be a variety of different elements,
such as Articles, Datatables, Tables and more.
"""

    publisher: Optional[Union["Person", "Organization"]] = None
    """A publisher of the CreativeWork.
"""

    references: Optional[Array[Union["CreativeWorkTypes", str]]] = None
    """References to other creative works, such as another publication,
web page, scholarly article, etc.
"""

    text: Optional[str] = None
    """The textual content of this creative work."""

    title: Optional[Union[Array["InlineContent"], str]] = None
    """The title of the creative work."""

    version: Optional[Union[str, float]] = None
    """The version of the creative work."""


    def __init__(
        self,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            url=url
        )
        if about is not None:
            self.about = about
        if authors is not None:
            self.authors = authors
        if comments is not None:
            self.comments = comments
        if content is not None:
            self.content = content
        if dateAccepted is not None:
            self.dateAccepted = dateAccepted
        if dateCreated is not None:
            self.dateCreated = dateCreated
        if dateModified is not None:
            self.dateModified = dateModified
        if datePublished is not None:
            self.datePublished = datePublished
        if dateReceived is not None:
            self.dateReceived = dateReceived
        if editors is not None:
            self.editors = editors
        if fundedBy is not None:
            self.fundedBy = fundedBy
        if funders is not None:
            self.funders = funders
        if genre is not None:
            self.genre = genre
        if isPartOf is not None:
            self.isPartOf = isPartOf
        if keywords is not None:
            self.keywords = keywords
        if licenses is not None:
            self.licenses = licenses
        if maintainers is not None:
            self.maintainers = maintainers
        if parts is not None:
            self.parts = parts
        if publisher is not None:
            self.publisher = publisher
        if references is not None:
            self.references = references
        if text is not None:
            self.text = text
        if title is not None:
            self.title = title
        if version is not None:
            self.version = version


class Article(CreativeWork):
    """An article, including news and scholarly articles."""

    content: Optional[Array["BlockContent"]] = None # type: ignore
    """The structured content of this article."""

    pageEnd: Optional[Union[int, str]] = None
    """The page on which the article ends; for example "138" or "xvi"."""

    pageStart: Optional[Union[int, str]] = None
    """The page on which the article starts; for example "135" or "xiii"."""

    pagination: Optional[str] = None
    """Any description of pages that is not separated into pageStart and pageEnd;
for example, "1-6, 9, 55".
"""


    def __init__(
        self,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Array["BlockContent"]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        pageEnd: Optional[Union[int, str]] = None,
        pageStart: Optional[Union[int, str]] = None,
        pagination: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if content is not None:
            self.content = content
        if pageEnd is not None:
            self.pageEnd = pageEnd
        if pageStart is not None:
            self.pageStart = pageStart
        if pagination is not None:
            self.pagination = pagination


class Claim(CreativeWork):
    """A claim represents specific reviewable facts or statements."""

    content: Array["BlockContent"] # type: ignore
    """Content of the claim, usually a single paragraph."""

    claimType: Optional["EClaimType"] = None
    """Kind of the claim."""

    label: Optional[str] = None
    """A short label for the claim."""


    def __init__(
        self,
        content: Array["BlockContent"],
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        claimType: Optional["EClaimType"] = None,
        comments: Optional[Array["Comment"]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        label: Optional[str] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if content is not None:
            self.content = content
        if claimType is not None:
            self.claimType = claimType
        if label is not None:
            self.label = label


class Collection(CreativeWork):
    """A collection of CreativeWorks or other artifacts."""

    parts: Array["CreativeWorkTypes"] # type: ignore
    """Elements of the collection which can be a variety of different elements,
such as Articles, Datatables, Tables and more.
"""


    def __init__(
        self,
        parts: Array["CreativeWorkTypes"],
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            parts=parts,
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if parts is not None:
            self.parts = parts


class Comment(CreativeWork):
    """A comment on an item, e.g on a Article, or SoftwareSourceCode."""

    commentAspect: Optional[str] = None
    """The part or facet of the item that is being commented on."""

    parentItem: Optional["Comment"] = None
    """The parent comment of this comment."""


    def __init__(
        self,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        commentAspect: Optional[str] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parentItem: Optional["Comment"] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if commentAspect is not None:
            self.commentAspect = commentAspect
        if parentItem is not None:
            self.parentItem = parentItem


class Datatable(CreativeWork):
    """A table of data."""

    columns: Array["DatatableColumn"]
    """The columns of data."""


    def __init__(
        self,
        columns: Array["DatatableColumn"],
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if columns is not None:
            self.columns = columns


class MediaObject(CreativeWork):
    """
    A media object, such as an image, video, or audio object embedded in a web
    page or a downloadable dataset.
    """

    contentUrl: str
    """URL for the actual bytes of the media object, for example the image file or video file.
"""

    bitrate: Optional[float] = None
    """Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
"""

    contentSize: Optional[float] = None
    """File size in megabits (Mbit, Mb).
"""

    embedUrl: Optional[str] = None
    """URL that can be used to embed the media on a web page via a specific media player.
"""

    mediaType: Optional[str] = None
    """IANA media type (MIME type)."""


    def __init__(
        self,
        contentUrl: str,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        bitrate: Optional[float] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        contentSize: Optional[float] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        embedUrl: Optional[str] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        mediaType: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if contentUrl is not None:
            self.contentUrl = contentUrl
        if bitrate is not None:
            self.bitrate = bitrate
        if contentSize is not None:
            self.contentSize = contentSize
        if embedUrl is not None:
            self.embedUrl = embedUrl
        if mediaType is not None:
            self.mediaType = mediaType


class AudioObject(MediaObject):
    """An audio file"""

    caption: Optional[str] = None
    """The caption for this audio recording."""

    transcript: Optional[str] = None
    """The transcript of this audio recording."""


    def __init__(
        self,
        contentUrl: str,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        bitrate: Optional[float] = None,
        caption: Optional[str] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        contentSize: Optional[float] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        embedUrl: Optional[str] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        mediaType: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        transcript: Optional[str] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            contentUrl=contentUrl,
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            bitrate=bitrate,
            comments=comments,
            content=content,
            contentSize=contentSize,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            embedUrl=embedUrl,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            mediaType=mediaType,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if caption is not None:
            self.caption = caption
        if transcript is not None:
            self.transcript = transcript


class DatatableColumn(Thing):
    """A column of data within a Datatable."""

    name: str # type: ignore
    """The name of the item."""

    values: Array["Any"]
    """The data values of the column."""

    validator: Optional["ArrayValidator"] = None
    """The validator to use to validate data in the column."""


    def __init__(
        self,
        name: str,
        values: Array["Any"],
        alternateNames: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        url: Optional[str] = None,
        validator: Optional["ArrayValidator"] = None
    ) -> None:
        super().__init__(
            name=name,
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            url=url
        )
        if name is not None:
            self.name = name
        if values is not None:
            self.values = values
        if validator is not None:
            self.validator = validator


class DefinedTerm(Thing):
    """A word, name, acronym, phrase, etc. with a formal definition."""

    name: str # type: ignore
    """The name of the item."""

    termCode: Optional[str] = None
    """A code that identifies this DefinedTerm within a DefinedTermSet"""


    def __init__(
        self,
        name: str,
        alternateNames: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        termCode: Optional[str] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            name=name,
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            url=url
        )
        if name is not None:
            self.name = name
        if termCode is not None:
            self.termCode = termCode


class Validator(Entity):
    """A base for all validator types."""

    def __init__(
        self,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )



class ArrayValidator(Validator):
    """A validator specifying constraints on an array node."""

    contains: Optional["ValidatorTypes"] = None
    """An array node is valid if at least one of its items is valid against the `contains` schema."""

    itemsValidator: Optional["ValidatorTypes"] = None
    """Another validator node specifying the constraints on all items in the array."""

    maxItems: Optional[int] = None
    """An array node is valid if its size is less than, or equal to, this value."""

    minItems: Optional[int] = None
    """An array node is valid if its size is greater than, or equal to, this value."""

    uniqueItems: Optional[bool] = None
    """A flag to indicate that each value in the array should be unique."""


    def __init__(
        self,
        contains: Optional["ValidatorTypes"] = None,
        id: Optional[str] = None,
        itemsValidator: Optional["ValidatorTypes"] = None,
        maxItems: Optional[int] = None,
        meta: Optional[Dict[str, Any]] = None,
        minItems: Optional[int] = None,
        uniqueItems: Optional[bool] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if contains is not None:
            self.contains = contains
        if itemsValidator is not None:
            self.itemsValidator = itemsValidator
        if maxItems is not None:
            self.maxItems = maxItems
        if minItems is not None:
            self.minItems = minItems
        if uniqueItems is not None:
            self.uniqueItems = uniqueItems


class BooleanValidator(Validator):
    """A schema specifying that a node must be a boolean value."""

    def __init__(
        self,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )



class ConstantValidator(Validator):
    """A validator specifying a constant value that a node must have."""

    value: Optional["Any"] = None
    """The value that the node must have."""


    def __init__(
        self,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        value: Optional["Any"] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if value is not None:
            self.value = value


class EnumValidator(Validator):
    """A schema specifying that a node must be one of several values."""

    values: Optional[Array["Any"]] = None
    """A node is valid if it is equal to any of these values."""


    def __init__(
        self,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        values: Optional[Array["Any"]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if values is not None:
            self.values = values


class Enumeration(Thing):
    """
    Lists or enumerations, for example, a list of cuisines or music genres,
    etc.
    """

    def __init__(
        self,
        alternateNames: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            url=url
        )



class Figure(CreativeWork):
    """
    Encapsulates one or more images, videos, tables, etc, and provides captions
    and labels for them.
    """

    caption: Optional[Union[Array["BlockContent"], str]] = None
    """A caption for the figure."""

    label: Optional[str] = None
    """A short label for the figure."""


    def __init__(
        self,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        caption: Optional[Union[Array["BlockContent"], str]] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        label: Optional[str] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if caption is not None:
            self.caption = caption
        if label is not None:
            self.label = label


class Function(Entity):
    """
    A function with a name, which might take Parameters and return a value of a
    certain type.
    """

    name: Optional[str] = None
    """The name of the function."""

    parameters: Optional[Array["Parameter"]] = None
    """The parameters of the function."""

    returns: Optional["ValidatorTypes"] = None
    """The return type of the function."""


    def __init__(
        self,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parameters: Optional[Array["Parameter"]] = None,
        returns: Optional["ValidatorTypes"] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if name is not None:
            self.name = name
        if parameters is not None:
            self.parameters = parameters
        if returns is not None:
            self.returns = returns


class Grant(Thing):
    """A grant, typically financial or otherwise quantifiable, of resources."""

    fundedItems: Optional[Array["Thing"]] = None
    """Indicates an item funded or sponsored through a Grant."""

    sponsors: Optional[Array[Union["Person", "Organization"]]] = None
    """A person or organization that supports a thing through a pledge, promise, or financial contribution."""


    def __init__(
        self,
        alternateNames: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        fundedItems: Optional[Array["Thing"]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        sponsors: Optional[Array[Union["Person", "Organization"]]] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            url=url
        )
        if fundedItems is not None:
            self.fundedItems = fundedItems
        if sponsors is not None:
            self.sponsors = sponsors


class Heading(Entity):
    """A heading."""

    content: Array["InlineContent"]
    """Content of the heading."""

    depth: Optional[int] = None
    """The depth of the heading."""


    def __init__(
        self,
        content: Array["InlineContent"],
        depth: Optional[int] = None,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if content is not None:
            self.content = content
        if depth is not None:
            self.depth = depth


class ImageObject(MediaObject):
    """An image file."""

    caption: Optional[str] = None
    """The caption for this image."""

    thumbnail: Optional["ImageObject"] = None
    """Thumbnail image of this image."""


    def __init__(
        self,
        contentUrl: str,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        bitrate: Optional[float] = None,
        caption: Optional[str] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        contentSize: Optional[float] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        embedUrl: Optional[str] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        mediaType: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        thumbnail: Optional["ImageObject"] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            contentUrl=contentUrl,
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            bitrate=bitrate,
            comments=comments,
            content=content,
            contentSize=contentSize,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            embedUrl=embedUrl,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            mediaType=mediaType,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if caption is not None:
            self.caption = caption
        if thumbnail is not None:
            self.thumbnail = thumbnail


class Include(Entity):
    """
    A directive to include content from an external source (e.g. file, URL) or
    content.
    """

    source: str
    """The source of the content, a URL or file path, or the content itself."""

    content: Optional[Array["BlockContent"]] = None
    """The content to be included."""

    mediaType: Optional[str] = None
    """Media type, typically expressed using a MIME format, of the source content."""


    def __init__(
        self,
        source: str,
        content: Optional[Array["BlockContent"]] = None,
        id: Optional[str] = None,
        mediaType: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if source is not None:
            self.source = source
        if content is not None:
            self.content = content
        if mediaType is not None:
            self.mediaType = mediaType


class IntegerValidator(Validator):
    """A validator specifying the constraints on an integer node."""

    def __init__(
        self,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )



class Link(Entity):
    """
    A hyperlink to other pages, sections within the same document, resources,
    or any URL.
    """

    content: Array["InlineContent"]
    """The textual content of the link."""

    target: str
    """The target of the link."""

    exportFrom: Optional[str] = None
    """A compilation directive giving the name of the variable to export
to the link target.
"""

    importTo: Optional[str] = None
    """A compilation directive giving the name of the variable to import
the link target as.
"""

    relation: Optional[str] = None
    """The relation between the target and the current thing."""

    title: Optional[str] = None
    """A title for the link."""


    def __init__(
        self,
        content: Array["InlineContent"],
        target: str,
        exportFrom: Optional[str] = None,
        id: Optional[str] = None,
        importTo: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        relation: Optional[str] = None,
        title: Optional[str] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if content is not None:
            self.content = content
        if target is not None:
            self.target = target
        if exportFrom is not None:
            self.exportFrom = exportFrom
        if importTo is not None:
            self.importTo = importTo
        if relation is not None:
            self.relation = relation
        if title is not None:
            self.title = title


class List(Entity):
    """A list of items."""

    items: Array["ListItem"]
    """The items in the list"""

    order: Optional["EItemListOrder"] = None
    """Type of ordering."""


    def __init__(
        self,
        items: Array["ListItem"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        order: Optional["EItemListOrder"] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if items is not None:
            self.items = items
        if order is not None:
            self.order = order


class ListItem(Thing):
    """A single item in a list."""

    content: Optional[Union[Array["BlockContent"], Array["InlineContent"]]] = None
    """The content of the list item."""

    isChecked: Optional[bool] = None
    """A flag to indicate if this list item is checked."""

    item: Optional["Any"] = None
    """The item represented by this list item."""

    position: Optional[int] = None
    """The position of the item in a series or sequence of items."""


    def __init__(
        self,
        alternateNames: Optional[Array[str]] = None,
        content: Optional[Union[Array["BlockContent"], Array["InlineContent"]]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isChecked: Optional[bool] = None,
        item: Optional["Any"] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        position: Optional[int] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            url=url
        )
        if content is not None:
            self.content = content
        if isChecked is not None:
            self.isChecked = isChecked
        if item is not None:
            self.item = item
        if position is not None:
            self.position = position


class Math(Entity):
    """A mathematical variable or equation."""

    text: str
    """The text of the equation in the language."""

    errors: Optional[Array[str]] = None
    """Errors that occurred when parsing the math equation."""

    mathLanguage: Optional[str] = None
    """The language used for the equation e.g tex, mathml, asciimath."""


    def __init__(
        self,
        text: str,
        errors: Optional[Array[str]] = None,
        id: Optional[str] = None,
        mathLanguage: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if text is not None:
            self.text = text
        if errors is not None:
            self.errors = errors
        if mathLanguage is not None:
            self.mathLanguage = mathLanguage


class MathBlock(Math):
    """A block of math, e.g an equation, to be treated as block content."""

    label: Optional[str] = None
    """A short label for the math block."""


    def __init__(
        self,
        text: str,
        errors: Optional[Array[str]] = None,
        id: Optional[str] = None,
        label: Optional[str] = None,
        mathLanguage: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            text=text,
            errors=errors,
            id=id,
            mathLanguage=mathLanguage,
            meta=meta
        )
        if label is not None:
            self.label = label


class MathFragment(Math):
    """
    A fragment of math, e.g a variable name, to be treated as inline content.
    """

    def __init__(
        self,
        text: str,
        errors: Optional[Array[str]] = None,
        id: Optional[str] = None,
        mathLanguage: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            text=text,
            errors=errors,
            id=id,
            mathLanguage=mathLanguage,
            meta=meta
        )



class MonetaryGrant(Grant):
    """A monetary grant."""

    amounts: Optional[float] = None
    """The amount of money."""

    funders: Optional[Array[Union["Person", "Organization"]]] = None
    """A person or organization that supports (sponsors) something through some kind of financial contribution.
"""


    def __init__(
        self,
        alternateNames: Optional[Array[str]] = None,
        amounts: Optional[float] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        fundedItems: Optional[Array["Thing"]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        sponsors: Optional[Array[Union["Person", "Organization"]]] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            fundedItems=fundedItems,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            sponsors=sponsors,
            url=url
        )
        if amounts is not None:
            self.amounts = amounts
        if funders is not None:
            self.funders = funders


class NontextualAnnotation(Mark):
    """Inline text that has a non-textual annotation."""

    def __init__(
        self,
        content: Array["InlineContent"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            content=content,
            id=id,
            meta=meta
        )



class Note(Entity):
    """
    Additional content which is not part of the main content of a document.
    """

    content: Array["BlockContent"]
    """Content of the note, usually a paragraph."""

    noteType: Optional["ENoteType"] = None
    """Determines where the note content is displayed within the document."""


    def __init__(
        self,
        content: Array["BlockContent"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        noteType: Optional["ENoteType"] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if content is not None:
            self.content = content
        if noteType is not None:
            self.noteType = noteType


class NumberValidator(Validator):
    """A validator specifying the constraints on a numeric node."""

    exclusiveMaximum: Optional[float] = None
    """The exclusive upper limit for a numeric node."""

    exclusiveMinimum: Optional[float] = None
    """The exclusive lower limit for a numeric node."""

    maximum: Optional[float] = None
    """The inclusive upper limit for a numeric node."""

    minimum: Optional[float] = None
    """The inclusive lower limit for a numeric node."""

    multipleOf: Optional[float] = None
    """A number that a numeric node must be a multiple of."""


    def __init__(
        self,
        exclusiveMaximum: Optional[float] = None,
        exclusiveMinimum: Optional[float] = None,
        id: Optional[str] = None,
        maximum: Optional[float] = None,
        meta: Optional[Dict[str, Any]] = None,
        minimum: Optional[float] = None,
        multipleOf: Optional[float] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if exclusiveMaximum is not None:
            self.exclusiveMaximum = exclusiveMaximum
        if exclusiveMinimum is not None:
            self.exclusiveMinimum = exclusiveMinimum
        if maximum is not None:
            self.maximum = maximum
        if minimum is not None:
            self.minimum = minimum
        if multipleOf is not None:
            self.multipleOf = multipleOf


class Organization(Thing):
    """An organization such as a school, NGO, corporation, club, etc."""

    address: Optional[Union["PostalAddress", str]] = None
    """Postal address for the organization.
"""

    brands: Optional[Array["Brand"]] = None
    """Brands that the organization is connected with.
"""

    contactPoints: Optional[Array["ContactPoint"]] = None
    """Correspondence/Contact points for the organization.
"""

    departments: Optional[Array["Organization"]] = None
    """Departments within the organization. For example, Department of Computer Science, Research & Development etc.
"""

    funders: Optional[Array[Union["Organization", "Person"]]] = None
    """Organization(s) or person(s) funding the organization.
"""

    legalName: Optional[str] = None
    """Legal name for the Organization. Should only include letters and spaces.
"""

    logo: Optional[Union["ImageObject", str]] = None
    """The logo of the organization."""

    members: Optional[Array[Union["Organization", "Person"]]] = None
    """Person(s) or organization(s) who are members of this organization.
"""

    parentOrganization: Optional["Organization"] = None
    """Entity that the Organization is a part of. For example, parentOrganization to a department is a university.
"""


    def __init__(
        self,
        address: Optional[Union["PostalAddress", str]] = None,
        alternateNames: Optional[Array[str]] = None,
        brands: Optional[Array["Brand"]] = None,
        contactPoints: Optional[Array["ContactPoint"]] = None,
        departments: Optional[Array["Organization"]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        funders: Optional[Array[Union["Organization", "Person"]]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        legalName: Optional[str] = None,
        logo: Optional[Union["ImageObject", str]] = None,
        members: Optional[Array[Union["Organization", "Person"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parentOrganization: Optional["Organization"] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            url=url
        )
        if address is not None:
            self.address = address
        if brands is not None:
            self.brands = brands
        if contactPoints is not None:
            self.contactPoints = contactPoints
        if departments is not None:
            self.departments = departments
        if funders is not None:
            self.funders = funders
        if legalName is not None:
            self.legalName = legalName
        if logo is not None:
            self.logo = logo
        if members is not None:
            self.members = members
        if parentOrganization is not None:
            self.parentOrganization = parentOrganization


class Paragraph(Entity):
    """Paragraph"""

    content: Array["InlineContent"]
    """The contents of the paragraph."""


    def __init__(
        self,
        content: Array["InlineContent"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if content is not None:
            self.content = content


class Variable(Entity):
    """A variable representing a name / value pair."""

    name: str
    """The name of the variable."""

    isReadonly: Optional[bool] = None
    """Whether or not a property is mutable. Default is false."""

    validator: Optional["ValidatorTypes"] = None
    """The validator that the value is validated against."""

    value: Optional["Any"] = None
    """The value of the variable."""


    def __init__(
        self,
        name: str,
        id: Optional[str] = None,
        isReadonly: Optional[bool] = None,
        meta: Optional[Dict[str, Any]] = None,
        validator: Optional["ValidatorTypes"] = None,
        value: Optional["Any"] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if name is not None:
            self.name = name
        if isReadonly is not None:
            self.isReadonly = isReadonly
        if validator is not None:
            self.validator = validator
        if value is not None:
            self.value = value


class Parameter(Variable):
    """A parameter that can be set and used in evaluated code."""

    default: Optional["Any"] = None
    """The default value of the parameter."""

    isExtensible: Optional[bool] = None
    """Indicates that this parameter is variadic and can accept multiple named arguments."""

    isRequired: Optional[bool] = None
    """Is this parameter required, if not it should have a default or default is assumed to be null."""

    isVariadic: Optional[bool] = None
    """Indicates that this parameter is variadic and can accept multiple arguments."""


    def __init__(
        self,
        name: str,
        default: Optional["Any"] = None,
        id: Optional[str] = None,
        isExtensible: Optional[bool] = None,
        isReadonly: Optional[bool] = None,
        isRequired: Optional[bool] = None,
        isVariadic: Optional[bool] = None,
        meta: Optional[Dict[str, Any]] = None,
        validator: Optional["ValidatorTypes"] = None,
        value: Optional["Any"] = None
    ) -> None:
        super().__init__(
            name=name,
            id=id,
            isReadonly=isReadonly,
            meta=meta,
            validator=validator,
            value=value
        )
        if default is not None:
            self.default = default
        if isExtensible is not None:
            self.isExtensible = isExtensible
        if isRequired is not None:
            self.isRequired = isRequired
        if isVariadic is not None:
            self.isVariadic = isVariadic


class Periodical(CreativeWork):
    """A periodical publication."""

    dateEnd: Optional["Date"] = None
    """The date this Periodical ceased publication."""

    dateStart: Optional["Date"] = None
    """The date this Periodical was first published."""

    issns: Optional[Array[str]] = None
    """The International Standard Serial Number(s) (ISSN) that identifies this serial publication."""


    def __init__(
        self,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateEnd: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        dateStart: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        issns: Optional[Array[str]] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if dateEnd is not None:
            self.dateEnd = dateEnd
        if dateStart is not None:
            self.dateStart = dateStart
        if issns is not None:
            self.issns = issns


class Person(Thing):
    """A person (alive, dead, undead, or fictional)."""

    address: Optional[Union["PostalAddress", str]] = None
    """Postal address for the person."""

    affiliations: Optional[Array["Organization"]] = None
    """Organizations that the person is affiliated with."""

    emails: Optional[Array[str]] = None
    """Email addresses for the person."""

    familyNames: Optional[Array[str]] = None
    """Family name. In the U.S., the last name of a person."""

    funders: Optional[Array[Union["Organization", "Person"]]] = None
    """A person or organization that supports (sponsors) something through
some kind of financial contribution.
"""

    givenNames: Optional[Array[str]] = None
    """Given name. In the U.S., the first name of a person."""

    honorificPrefix: Optional[str] = None
    """An honorific prefix preceding a person's name such as Dr/Mrs/Mr."""

    honorificSuffix: Optional[str] = None
    """An honorific suffix after a person's name such as MD/PhD/MSCSW."""

    jobTitle: Optional[str] = None
    """The job title of the person (for example, Financial Manager)."""

    memberOf: Optional[Array["Organization"]] = None
    """An organization (or program membership) to which this person belongs."""

    telephoneNumbers: Optional[Array[str]] = None
    """Telephone numbers for the person."""


    def __init__(
        self,
        address: Optional[Union["PostalAddress", str]] = None,
        affiliations: Optional[Array["Organization"]] = None,
        alternateNames: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        emails: Optional[Array[str]] = None,
        familyNames: Optional[Array[str]] = None,
        funders: Optional[Array[Union["Organization", "Person"]]] = None,
        givenNames: Optional[Array[str]] = None,
        honorificPrefix: Optional[str] = None,
        honorificSuffix: Optional[str] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        jobTitle: Optional[str] = None,
        memberOf: Optional[Array["Organization"]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        telephoneNumbers: Optional[Array[str]] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            url=url
        )
        if address is not None:
            self.address = address
        if affiliations is not None:
            self.affiliations = affiliations
        if emails is not None:
            self.emails = emails
        if familyNames is not None:
            self.familyNames = familyNames
        if funders is not None:
            self.funders = funders
        if givenNames is not None:
            self.givenNames = givenNames
        if honorificPrefix is not None:
            self.honorificPrefix = honorificPrefix
        if honorificSuffix is not None:
            self.honorificSuffix = honorificSuffix
        if jobTitle is not None:
            self.jobTitle = jobTitle
        if memberOf is not None:
            self.memberOf = memberOf
        if telephoneNumbers is not None:
            self.telephoneNumbers = telephoneNumbers


class PostalAddress(ContactPoint):
    """A physical mailing address."""

    addressCountry: Optional[str] = None
    """The country."""

    addressLocality: Optional[str] = None
    """The locality in which the street address is, and which is in the region."""

    addressRegion: Optional[str] = None
    """The region in which the locality is, and which is in the country."""

    postOfficeBoxNumber: Optional[str] = None
    """The post office box number."""

    postalCode: Optional[str] = None
    """The postal code."""

    streetAddress: Optional[str] = None
    """The street address."""


    def __init__(
        self,
        addressCountry: Optional[str] = None,
        addressLocality: Optional[str] = None,
        addressRegion: Optional[str] = None,
        alternateNames: Optional[Array[str]] = None,
        availableLanguages: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        emails: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        postOfficeBoxNumber: Optional[str] = None,
        postalCode: Optional[str] = None,
        streetAddress: Optional[str] = None,
        telephoneNumbers: Optional[Array[str]] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            availableLanguages=availableLanguages,
            description=description,
            emails=emails,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            telephoneNumbers=telephoneNumbers,
            url=url
        )
        if addressCountry is not None:
            self.addressCountry = addressCountry
        if addressLocality is not None:
            self.addressLocality = addressLocality
        if addressRegion is not None:
            self.addressRegion = addressRegion
        if postOfficeBoxNumber is not None:
            self.postOfficeBoxNumber = postOfficeBoxNumber
        if postalCode is not None:
            self.postalCode = postalCode
        if streetAddress is not None:
            self.streetAddress = streetAddress


class Product(Thing):
    """
    Any offered product or service. For example, a pair of shoes; a haircut; or
    an episode of a TV show streamed online.
    """

    brands: Optional[Array["Brand"]] = None
    """Brands that the product is labelled with."""

    logo: Optional[Union["ImageObject", str]] = None
    """The logo of the product."""

    productID: Optional[str] = None
    """Product identification code."""


    def __init__(
        self,
        alternateNames: Optional[Array[str]] = None,
        brands: Optional[Array["Brand"]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        logo: Optional[Union["ImageObject", str]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        productID: Optional[str] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            url=url
        )
        if brands is not None:
            self.brands = brands
        if logo is not None:
            self.logo = logo
        if productID is not None:
            self.productID = productID


class PropertyValue(Thing):
    """A property-value pair."""

    value: Union[bool, int, float, str]
    """The value of the property."""

    propertyID: Optional[str] = None
    """A commonly used identifier for the characteristic represented by the property."""


    def __init__(
        self,
        value: Union[bool, int, float, str],
        alternateNames: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        propertyID: Optional[str] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            url=url
        )
        if value is not None:
            self.value = value
        if propertyID is not None:
            self.propertyID = propertyID


class PublicationIssue(CreativeWork):
    """
    A part of a successively published publication such as a periodical or
    publication volume, often numbered.
    """

    issueNumber: Optional[Union[int, str]] = None
    """Identifies the issue of publication; for example, "iii" or "2"."""

    pageEnd: Optional[Union[int, str]] = None
    """The page on which the issue ends; for example "138" or "xvi"."""

    pageStart: Optional[Union[int, str]] = None
    """The page on which the issue starts; for example "135" or "xiii"."""

    pagination: Optional[str] = None
    """Any description of pages that is not separated into pageStart and pageEnd;
for example, "1-6, 9, 55".
"""


    def __init__(
        self,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        issueNumber: Optional[Union[int, str]] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        pageEnd: Optional[Union[int, str]] = None,
        pageStart: Optional[Union[int, str]] = None,
        pagination: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if issueNumber is not None:
            self.issueNumber = issueNumber
        if pageEnd is not None:
            self.pageEnd = pageEnd
        if pageStart is not None:
            self.pageStart = pageStart
        if pagination is not None:
            self.pagination = pagination


class PublicationVolume(CreativeWork):
    """
    A part of a successively published publication such as a periodical or
    multi-volume work.
    """

    pageEnd: Optional[Union[int, str]] = None
    """The page on which the volume ends; for example "138" or "xvi"."""

    pageStart: Optional[Union[int, str]] = None
    """The page on which the volume starts; for example "135" or "xiii"."""

    pagination: Optional[str] = None
    """Any description of pages that is not separated into pageStart and pageEnd;
for example, "1-6, 9, 55".
"""

    volumeNumber: Optional[Union[int, str]] = None
    """Identifies the volume of publication or multi-part work; for example, "iii" or "2".
"""


    def __init__(
        self,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        pageEnd: Optional[Union[int, str]] = None,
        pageStart: Optional[Union[int, str]] = None,
        pagination: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None,
        volumeNumber: Optional[Union[int, str]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if pageEnd is not None:
            self.pageEnd = pageEnd
        if pageStart is not None:
            self.pageStart = pageStart
        if pagination is not None:
            self.pagination = pagination
        if volumeNumber is not None:
            self.volumeNumber = volumeNumber


class Quote(Mark):
    """Inline, quoted content."""

    cite: Optional[Union["Cite", str]] = None
    """The source of the quote."""


    def __init__(
        self,
        content: Array["InlineContent"],
        cite: Optional[Union["Cite", str]] = None,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            content=content,
            id=id,
            meta=meta
        )
        if cite is not None:
            self.cite = cite


class QuoteBlock(Entity):
    """A section quoted from somewhere else."""

    content: Array["BlockContent"]
    """The content of the quote."""

    cite: Optional[Union["Cite", str]] = None
    """The source of the quote."""


    def __init__(
        self,
        content: Array["BlockContent"],
        cite: Optional[Union["Cite", str]] = None,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if content is not None:
            self.content = content
        if cite is not None:
            self.cite = cite


class Review(CreativeWork):
    """A review of an item, e.g of an Article, or SoftwareSourceCode."""

    itemReviewed: Optional["Thing"] = None
    """The item that is being reviewed."""

    reviewAspect: Optional[str] = None
    """The part or facet of the item that is being reviewed."""


    def __init__(
        self,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        itemReviewed: Optional["Thing"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        reviewAspect: Optional[str] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if itemReviewed is not None:
            self.itemReviewed = itemReviewed
        if reviewAspect is not None:
            self.reviewAspect = reviewAspect


class SoftwareApplication(CreativeWork):
    """A software application."""

    softwareRequirements: Optional[Array["SoftwareApplication"]] = None
    """Requirements for application, including shared libraries that
are not included in the application distribution.
"""

    softwareVersion: Optional[str] = None
    """Version of the software."""


    def __init__(
        self,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        softwareRequirements: Optional[Array["SoftwareApplication"]] = None,
        softwareVersion: Optional[str] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if softwareRequirements is not None:
            self.softwareRequirements = softwareRequirements
        if softwareVersion is not None:
            self.softwareVersion = softwareVersion


class SoftwareEnvironment(Thing):
    """A computational environment."""

    name: str # type: ignore
    """The name of the item."""

    adds: Optional[Array["SoftwareSourceCode"]] = None
    """The packages that this environment adds to the base environments listed under `extends` (if any).,"""

    extends: Optional[Array["SoftwareEnvironment"]] = None
    """Other environments that this environment extends by adding or removing packages.,"""

    removes: Optional[Array["SoftwareSourceCode"]] = None
    """The packages that this environment removes from the base environments listed under `extends` (if any).,"""


    def __init__(
        self,
        name: str,
        adds: Optional[Array["SoftwareSourceCode"]] = None,
        alternateNames: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        extends: Optional[Array["SoftwareEnvironment"]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        removes: Optional[Array["SoftwareSourceCode"]] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            name=name,
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            url=url
        )
        if name is not None:
            self.name = name
        if adds is not None:
            self.adds = adds
        if extends is not None:
            self.extends = extends
        if removes is not None:
            self.removes = removes


class SoftwareSession(Thing):
    """
    Definition of a compute session, including its software and compute
    resource requirements and status.
    """

    clientsLimit: Optional[float] = None
    """The maximum number of concurrent clients the session is limited to."""

    clientsRequest: Optional[float] = None
    """The maximum number of concurrent clients requested for the session."""

    cpuLimit: Optional[float] = None
    """The amount of CPU the session is limited to."""

    cpuRequest: Optional[float] = None
    """The amount of CPU requested for the session."""

    dateEnd: Optional["Date"] = None
    """The date-time that the session ended."""

    dateStart: Optional["Date"] = None
    """The date-time that the session began."""

    durationLimit: Optional[float] = None
    """The maximum duration (seconds) the session is limited to."""

    durationRequest: Optional[float] = None
    """The maximum duration (seconds) requested for the session."""

    environment: Optional["SoftwareEnvironment"] = None
    """The software environment to execute this session in."""

    memoryLimit: Optional[float] = None
    """The amount of memory that the session is limited to."""

    memoryRequest: Optional[float] = None
    """The amount of memory requested for the session."""

    networkTransferLimit: Optional[float] = None
    """The amount of network data transfer (GiB) that the session is limited to."""

    networkTransferRequest: Optional[float] = None
    """The amount of network data transfer (GiB) requested for the session."""

    status: Optional["ESessionStatus"] = None
    """The status of the session (starting, stopped, etc)."""

    timeoutLimit: Optional[float] = None
    """The inactivity timeout (seconds) the session is limited to."""

    timeoutRequest: Optional[float] = None
    """The inactivity timeout (seconds) requested for the session."""

    volumeMounts: Optional[Array["VolumeMount"]] = None
    """Volumes to mount in the session."""


    def __init__(
        self,
        alternateNames: Optional[Array[str]] = None,
        clientsLimit: Optional[float] = None,
        clientsRequest: Optional[float] = None,
        cpuLimit: Optional[float] = None,
        cpuRequest: Optional[float] = None,
        dateEnd: Optional["Date"] = None,
        dateStart: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        durationLimit: Optional[float] = None,
        durationRequest: Optional[float] = None,
        environment: Optional["SoftwareEnvironment"] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        memoryLimit: Optional[float] = None,
        memoryRequest: Optional[float] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        networkTransferLimit: Optional[float] = None,
        networkTransferRequest: Optional[float] = None,
        status: Optional["ESessionStatus"] = None,
        timeoutLimit: Optional[float] = None,
        timeoutRequest: Optional[float] = None,
        url: Optional[str] = None,
        volumeMounts: Optional[Array["VolumeMount"]] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            url=url
        )
        if clientsLimit is not None:
            self.clientsLimit = clientsLimit
        if clientsRequest is not None:
            self.clientsRequest = clientsRequest
        if cpuLimit is not None:
            self.cpuLimit = cpuLimit
        if cpuRequest is not None:
            self.cpuRequest = cpuRequest
        if dateEnd is not None:
            self.dateEnd = dateEnd
        if dateStart is not None:
            self.dateStart = dateStart
        if durationLimit is not None:
            self.durationLimit = durationLimit
        if durationRequest is not None:
            self.durationRequest = durationRequest
        if environment is not None:
            self.environment = environment
        if memoryLimit is not None:
            self.memoryLimit = memoryLimit
        if memoryRequest is not None:
            self.memoryRequest = memoryRequest
        if networkTransferLimit is not None:
            self.networkTransferLimit = networkTransferLimit
        if networkTransferRequest is not None:
            self.networkTransferRequest = networkTransferRequest
        if status is not None:
            self.status = status
        if timeoutLimit is not None:
            self.timeoutLimit = timeoutLimit
        if timeoutRequest is not None:
            self.timeoutRequest = timeoutRequest
        if volumeMounts is not None:
            self.volumeMounts = volumeMounts


class SoftwareSourceCode(CreativeWork):
    """
    Computer programming source code. Example: Full (compile ready) solutions,
    code snippet samples, scripts, templates.
    """

    codeRepository: Optional[str] = None
    """Link to the repository where the un-compiled, human readable code and related
code is located.
"""

    codeSampleType: Optional[str] = None
    """What type of code sample: full (compile ready) solution, code snippet, inline code, scripts, template.
"""

    programmingLanguage: Optional[str] = None
    """The computer programming language.
"""

    runtimePlatform: Optional[Array[str]] = None
    """Runtime platform or script interpreter dependencies (Example - Java v1,
Python2.3, .Net Framework 3.0).
"""

    softwareRequirements: Optional[Array[Union["SoftwareSourceCode", "SoftwareApplication", str]]] = None
    """Dependency requirements for the software."""

    targetProducts: Optional[Array["SoftwareApplication"]] = None
    """Target operating system or product to which the code applies.
"""


    def __init__(
        self,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        codeRepository: Optional[str] = None,
        codeSampleType: Optional[str] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        programmingLanguage: Optional[str] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        runtimePlatform: Optional[Array[str]] = None,
        softwareRequirements: Optional[Array[Union["SoftwareSourceCode", "SoftwareApplication", str]]] = None,
        targetProducts: Optional[Array["SoftwareApplication"]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if codeRepository is not None:
            self.codeRepository = codeRepository
        if codeSampleType is not None:
            self.codeSampleType = codeSampleType
        if programmingLanguage is not None:
            self.programmingLanguage = programmingLanguage
        if runtimePlatform is not None:
            self.runtimePlatform = runtimePlatform
        if softwareRequirements is not None:
            self.softwareRequirements = softwareRequirements
        if targetProducts is not None:
            self.targetProducts = targetProducts


class StringValidator(Validator):
    """A schema specifying constraints on a string node."""

    maxLength: Optional[int] = None
    """The maximum length for a string node."""

    minLength: Optional[int] = None
    """The minimum length for a string node."""

    pattern: Optional[str] = None
    """A regular expression that a string node must match."""


    def __init__(
        self,
        id: Optional[str] = None,
        maxLength: Optional[int] = None,
        meta: Optional[Dict[str, Any]] = None,
        minLength: Optional[int] = None,
        pattern: Optional[str] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if maxLength is not None:
            self.maxLength = maxLength
        if minLength is not None:
            self.minLength = minLength
        if pattern is not None:
            self.pattern = pattern


class Strong(Mark):
    """Strongly emphasised content."""

    def __init__(
        self,
        content: Array["InlineContent"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            content=content,
            id=id,
            meta=meta
        )



class Subscript(Mark):
    """Subscripted content."""

    def __init__(
        self,
        content: Array["InlineContent"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            content=content,
            id=id,
            meta=meta
        )



class Superscript(Mark):
    """Superscripted content."""

    def __init__(
        self,
        content: Array["InlineContent"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            content=content,
            id=id,
            meta=meta
        )



class Table(CreativeWork):
    """A table."""

    rows: Array["TableRow"]
    """Rows of cells in the table.
"""

    caption: Optional[Union[Array["BlockContent"], str]] = None
    """A caption for the table."""

    label: Optional[str] = None
    """A short label for the table."""


    def __init__(
        self,
        rows: Array["TableRow"],
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        caption: Optional[Union[Array["BlockContent"], str]] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        label: Optional[str] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            comments=comments,
            content=content,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if rows is not None:
            self.rows = rows
        if caption is not None:
            self.caption = caption
        if label is not None:
            self.label = label


class TableCell(Entity):
    """A cell within a `Table`."""

    cellType: Optional["ECellType"] = None
    """Indicates whether the cell is a header or data."""

    colspan: Optional[int] = None
    """How many columns the cell extends.
"""

    content: Optional[Union[Array["BlockContent"], Array["InlineContent"]]] = None
    """Contents of the table cell."""

    name: Optional[str] = None
    """The name of the cell."""

    rowspan: Optional[int] = None
    """How many columns the cell extends."""


    def __init__(
        self,
        cellType: Optional["ECellType"] = None,
        colspan: Optional[int] = None,
        content: Optional[Union[Array["BlockContent"], Array["InlineContent"]]] = None,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        rowspan: Optional[int] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if cellType is not None:
            self.cellType = cellType
        if colspan is not None:
            self.colspan = colspan
        if content is not None:
            self.content = content
        if name is not None:
            self.name = name
        if rowspan is not None:
            self.rowspan = rowspan


class TableRow(Entity):
    """A row within a Table."""

    cells: Array["TableCell"]
    """An array of cells in the row."""

    rowType: Optional["ERowType"] = None
    """If present, indicates that all cells in this row should be treated as header cells.
"""


    def __init__(
        self,
        cells: Array["TableCell"],
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        rowType: Optional["ERowType"] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if cells is not None:
            self.cells = cells
        if rowType is not None:
            self.rowType = rowType


class ThematicBreak(Entity):
    """
    A thematic break, such as a scene change in a story, a transition to
    another topic, or a new document.
    """

    def __init__(
        self,
        id: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )



class TupleValidator(Validator):
    """
    A validator specifying constraints on an array of heterogeneous items.
    """

    items: Optional[Array["ValidatorTypes"]] = None
    """An array of validators specifying the constraints on each successive item in the array."""


    def __init__(
        self,
        id: Optional[str] = None,
        items: Optional[Array["ValidatorTypes"]] = None,
        meta: Optional[Dict[str, Any]] = None
    ) -> None:
        super().__init__(
            id=id,
            meta=meta
        )
        if items is not None:
            self.items = items


class VideoObject(MediaObject):
    """A video file."""

    caption: Optional[str] = None
    """The caption for this video recording."""

    thumbnail: Optional["ImageObject"] = None
    """Thumbnail image of this video recording."""

    transcript: Optional[str] = None
    """The transcript of this video recording."""


    def __init__(
        self,
        contentUrl: str,
        about: Optional[Array["ThingTypes"]] = None,
        alternateNames: Optional[Array[str]] = None,
        authors: Optional[Array[Union["Person", "Organization"]]] = None,
        bitrate: Optional[float] = None,
        caption: Optional[str] = None,
        comments: Optional[Array["Comment"]] = None,
        content: Optional[Union[Array["Any"], str]] = None,
        contentSize: Optional[float] = None,
        dateAccepted: Optional["Date"] = None,
        dateCreated: Optional["Date"] = None,
        dateModified: Optional["Date"] = None,
        datePublished: Optional["Date"] = None,
        dateReceived: Optional["Date"] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        editors: Optional[Array["Person"]] = None,
        embedUrl: Optional[str] = None,
        fundedBy: Optional[Array[Union["Grant", "MonetaryGrant"]]] = None,
        funders: Optional[Array[Union["Person", "Organization"]]] = None,
        genre: Optional[Array[str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        isPartOf: Optional["CreativeWorkTypes"] = None,
        keywords: Optional[Array[str]] = None,
        licenses: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        maintainers: Optional[Array[Union["Person", "Organization"]]] = None,
        mediaType: Optional[str] = None,
        meta: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        parts: Optional[Array["CreativeWorkTypes"]] = None,
        publisher: Optional[Union["Person", "Organization"]] = None,
        references: Optional[Array[Union["CreativeWorkTypes", str]]] = None,
        text: Optional[str] = None,
        thumbnail: Optional["ImageObject"] = None,
        title: Optional[Union[Array["InlineContent"], str]] = None,
        transcript: Optional[str] = None,
        url: Optional[str] = None,
        version: Optional[Union[str, float]] = None
    ) -> None:
        super().__init__(
            contentUrl=contentUrl,
            about=about,
            alternateNames=alternateNames,
            authors=authors,
            bitrate=bitrate,
            comments=comments,
            content=content,
            contentSize=contentSize,
            dateAccepted=dateAccepted,
            dateCreated=dateCreated,
            dateModified=dateModified,
            datePublished=datePublished,
            dateReceived=dateReceived,
            description=description,
            editors=editors,
            embedUrl=embedUrl,
            fundedBy=fundedBy,
            funders=funders,
            genre=genre,
            id=id,
            identifiers=identifiers,
            images=images,
            isPartOf=isPartOf,
            keywords=keywords,
            licenses=licenses,
            maintainers=maintainers,
            mediaType=mediaType,
            meta=meta,
            name=name,
            parts=parts,
            publisher=publisher,
            references=references,
            text=text,
            title=title,
            url=url,
            version=version
        )
        if caption is not None:
            self.caption = caption
        if thumbnail is not None:
            self.thumbnail = thumbnail
        if transcript is not None:
            self.transcript = transcript


class VolumeMount(Thing):
    """Describes a volume mount from a host to container."""

    mountDestination: str
    """The mount location inside the container."""

    mountOptions: Optional[Array[str]] = None
    """A list of options to use when applying the mount."""

    mountSource: Optional[str] = None
    """The mount source directory on the host."""

    mountType: Optional[str] = None
    """The type of mount."""


    def __init__(
        self,
        mountDestination: str,
        alternateNames: Optional[Array[str]] = None,
        description: Optional[Union[Array["BlockContent"], Array["InlineContent"], str]] = None,
        id: Optional[str] = None,
        identifiers: Optional[Array[Union["PropertyValue", str]]] = None,
        images: Optional[Array[Union["ImageObject", str]]] = None,
        meta: Optional[Dict[str, Any]] = None,
        mountOptions: Optional[Array[str]] = None,
        mountSource: Optional[str] = None,
        mountType: Optional[str] = None,
        name: Optional[str] = None,
        url: Optional[str] = None
    ) -> None:
        super().__init__(
            alternateNames=alternateNames,
            description=description,
            id=id,
            identifiers=identifiers,
            images=images,
            meta=meta,
            name=name,
            url=url
        )
        if mountDestination is not None:
            self.mountDestination = mountDestination
        if mountOptions is not None:
            self.mountOptions = mountOptions
        if mountSource is not None:
            self.mountSource = mountSource
        if mountType is not None:
            self.mountType = mountType


class CitationIntentEnumeration(Enum):
    """
    The type or nature of a citation, both factually and rhetorically.
    """
    # The citing entity agrees with statements, ideas or conclusions presented in the cited entity
    AgreesWith = "AgreesWith"

    # The citing entity cites the cited entity as one that provides an authoritative description or definition of the subject under discussion
    CitesAsAuthority = "CitesAsAuthority"

    # The citing entity cites the cited entity as source of data
    CitesAsDataSource = "CitesAsDataSource"

    # The citing entity cites the cited entity as source of factual evidence for statements it contains
    CitesAsEvidence = "CitesAsEvidence"

    # The citing entity cites the cited entity as being the container of metadata describing the citing entity
    CitesAsMetadataDocument = "CitesAsMetadataDocument"

    # The citing entity cites the cited entity as providing or containing a possible solution to the issues being discussed
    CitesAsPotentialSolution = "CitesAsPotentialSolution"

    # The citing entity cites the cited entity as an item of recommended reading
    CitesAsRecommendedReading = "CitesAsRecommendedReading"

    # The citing entity cites the cited entity as one that is related
    CitesAsRelated = "CitesAsRelated"

    # The citing entity cites the cited entity as being the entity from which the citing entity is derived, or about which the citing entity contains metadata
    CitesAsSourceDocument = "CitesAsSourceDocument"

    # The citing entity cites the cited entity as a source of information on the subject under discussion
    CitesForInformation = "CitesForInformation"

    # The citing entity is used to create or compile the cited entity
    Compiles = "Compiles"

    # The citing entity confirms facts, ideas or statements presented in the cited entity
    Confirms = "Confirms"

    # The citing entity contains a statement of fact or a logical assertion (or a collection of such facts and/or assertions) originally present in the cited entity
    ContainsAssertionFrom = "ContainsAssertionFrom"

    # The citing entity corrects statements, ideas or conclusions presented in the cited entity
    Corrects = "Corrects"

    # The citing entity acknowledges contributions made by the cited entity
    Credits = "Credits"

    # The citing entity critiques statements, ideas or conclusions presented in the cited entity
    Critiques = "Critiques"

    # The citing entity express derision for the cited entity, or for ideas or conclusions contained within it
    Derides = "Derides"

    # The citing entity describes the cited entity
    Describes = "Describes"

    # The citing entity disagrees with statements, ideas or conclusions presented in the cited entity
    DisagreesWith = "DisagreesWith"

    # The citing entity discusses statements, ideas or conclusions presented in the cited entity
    Discusses = "Discusses"

    # The citing entity disputes statements, ideas or conclusions presented in the cited entity
    Disputes = "Disputes"

    # The citing entity documents information about the cited entity
    Documents = "Documents"

    # The citing entity extends facts, ideas or understandings presented in the cited entity
    Extends = "Extends"

    # The cited entity provides background information for the citing entity
    GivesBackgroundTo = "GivesBackgroundTo"

    # The cited entity provides intellectual or factual support for the citing entity
    GivesSupportTo = "GivesSupportTo"

    # The cited entity evokes a reply from the citing entity
    HasReplyFrom = "HasReplyFrom"

    # The citing entity includes one or more excerpts from the cited entity
    IncludesExcerptFrom = "IncludesExcerptFrom"

    # The citing entity includes one or more quotations from the cited entity
    IncludesQuotationFrom = "IncludesQuotationFrom"

    # The cited entity contains statements, ideas or conclusions with which the citing entity agrees
    IsAgreedWithBy = "IsAgreedWithBy"

    # The cited entity is cited as providing an authoritative description or definition of the subject under discussion in the citing entity
    IsCitedAsAuthorityBy = "IsCitedAsAuthorityBy"

    # The cited entity is cited as a data source by the citing entity
    IsCitedAsDataSourceBy = "IsCitedAsDataSourceBy"

    # The cited entity is cited for providing factual evidence to the citing entity
    IsCitedAsEvidenceBy = "IsCitedAsEvidenceBy"

    # The cited entity is cited as being the container of metadata relating to the citing entity
    IsCitedAsMetadataDocumentBy = "IsCitedAsMetadataDocumentBy"

    # The cited entity is cited as providing or containing a possible solution to the issues being discussed in the citing entity
    IsCitedAsPontentialSolutionBy = "IsCitedAsPontentialSolutionBy"

    # The cited entity is cited by the citing entity as an item of recommended reading
    IsCitedAsRecommendedReadingBy = "IsCitedAsRecommendedReadingBy"

    # The cited entity is cited as being related to the citing entity
    IsCitedAsRelatedBy = "IsCitedAsRelatedBy"

    # The cited entity is cited as being the entity from which the citing entity is derived, or about which the citing entity contains metadata
    IsCitedAsSourceDocumentBy = "IsCitedAsSourceDocumentBy"

    # The cited entity (the subject of the RDF triple) is cited by the citing entity (the object of the triple)
    IsCitedBy = "IsCitedBy"

    # The cited entity is cited as a source of information on the subject under discussion in the citing entity
    IsCitedForInformationBy = "IsCitedForInformationBy"

    # The cited entity is the result of a compile or creation event using the citing entity
    IsCompiledBy = "IsCompiledBy"

    # The cited entity presents facts, ideas or statements that are confirmed by the citing entity
    IsConfirmedBy = "IsConfirmedBy"

    # The cited entity presents statements, ideas or conclusions that are corrected by the citing entity
    IsCorrectedBy = "IsCorrectedBy"

    # The cited entity makes contributions that are acknowledged by the citing entity
    IsCreditedBy = "IsCreditedBy"

    # The cited entity presents statements, ideas or conclusions that are critiqued by the citing entity
    IsCritiquedBy = "IsCritiquedBy"

    # The cited entity contains ideas or conclusions for which the citing entity express derision
    IsDeridedBy = "IsDeridedBy"

    # The cited entity is described by the citing entity
    IsDescribedBy = "IsDescribedBy"

    # The cited entity presents statements, ideas or conclusions that are disagreed with by the citing entity
    IsDisagreedWithBy = "IsDisagreedWithBy"

    # The cited entity presents statements, ideas or conclusions that are discussed by the citing entity
    IsDiscussedBy = "IsDiscussedBy"

    # The cited entity presents statements, ideas or conclusions that are disputed by the citing entity
    IsDisputedBy = "IsDisputedBy"

    # Information about the cited entity is documented by the citing entity
    IsDocumentedBy = "IsDocumentedBy"

    # The cited entity presents facts, ideas or understandings that are extended by the citing entity
    IsExtendedBy = "IsExtendedBy"

    # The cited entity is the target for an HTTP Uniform Resource Locator (URL) link within the citing entity
    IsLinkedToBy = "IsLinkedToBy"

    # The characteristic style or content of the cited entity is imitated by the citing entity for comic effect, usually without explicit citation
    IsParodiedBy = "IsParodiedBy"

    # The cited entity is plagiarized by the author of the citing entity, who includes within the citing entity textual or other elements from the cited entity without formal acknowledgement of their source
    IsPlagiarizedBy = "IsPlagiarizedBy"

    # The cited entity presents statements, ideas or conclusions that are qualified or have conditions placed upon them by the citing entity
    IsQualifiedBy = "IsQualifiedBy"

    # The cited entity presents statements, ideas or conclusions that are refuted by the citing entity
    IsRefutedBy = "IsRefutedBy"

    # The cited entity is formally retracted by the citing entity
    IsRetractedBy = "IsRetractedBy"

    # The cited entity presents statements, ideas or conclusions that are reviewed by the citing entity
    IsReviewedBy = "IsReviewedBy"

    # The cited entity or aspects of its contents are ridiculed by the citing entity
    IsRidiculedBy = "IsRidiculedBy"

    # The cited entity is cited because the citing article contains speculations on its content or ideas
    IsSpeculatedOnBy = "IsSpeculatedOnBy"

    # The cited entity receives intellectual or factual support from the citing entity
    IsSupportedBy = "IsSupportedBy"

    # The cited entity presents statements, ideas, hypotheses or understanding that are updated by the cited entity
    IsUpdatedBy = "IsUpdatedBy"

    # A property that permits you to express appreciation of or interest in something that is the object of the RDF triple, or to express that it is worth thinking about even if you do not agree with its content, enabling social media 'likes' statements to be encoded in RDF
    Likes = "Likes"

    # The citing entity provides a link, in the form of an HTTP Uniform Resource Locator (URL), to the cited entity
    LinksTo = "LinksTo"

    # The citing entity obtains background information from the cited entity
    ObtainsBackgroundFrom = "ObtainsBackgroundFrom"

    # The citing entity obtains intellectual or factual support from the cited entity
    ObtainsSupportFrom = "ObtainsSupportFrom"

    # The citing entity imitates the characteristic style or content of the cited entity for comic effect, usually without explicit citation
    Parodies = "Parodies"

    # A property indicating that the author of the citing entity plagiarizes the cited entity, by including textual or other elements from the cited entity without formal acknowledgement of their source
    Plagiarizes = "Plagiarizes"

    # The cited entity contains and is the original source of a statement of fact or a logical assertion (or a collection of such facts and/or assertions) that is to be found in the citing entity
    ProvidesAssertionFor = "ProvidesAssertionFor"

    # The cited entity presents conclusions that are used in work described in the citing entity
    ProvidesConclusionsFor = "ProvidesConclusionsFor"

    # The cited entity presents data that are used in work described in the citing entity
    ProvidesDataFor = "ProvidesDataFor"

    # The cited entity contains information, usually of a textual nature, that is excerpted by (used as an excerpt within) the citing entity
    ProvidesExcerptFor = "ProvidesExcerptFor"

    # The cited entity details a method that is used in work described by the citing entity
    ProvidesMethodFor = "ProvidesMethodFor"

    # The cited entity contains information, usually of a textual nature, that is quoted by (used as a quotation within) the citing entity
    ProvidesQuotationFor = "ProvidesQuotationFor"

    # The citing entity qualifies or places conditions or restrictions upon statements, ideas or conclusions presented in the cited entity
    Qualifies = "Qualifies"

    # The citing entity refutes statements, ideas or conclusions presented in the cited entity
    Refutes = "Refutes"

    # The citing entity replies to statements, ideas or criticisms presented in the cited entity
    RepliesTo = "RepliesTo"

    # The citing entity constitutes a formal retraction of the cited entity
    Retracts = "Retracts"

    # The citing entity reviews statements, ideas or conclusions presented in the cited entity
    Reviews = "Reviews"

    # The citing entity ridicules the cited entity or aspects of its contents
    Ridicules = "Ridicules"

    # Each entity has at least one author that shares a common institutional affiliation with an author of the other entity
    SharesAuthorInstitutionWith = "SharesAuthorInstitutionWith"

    # Each entity has at least one author in common with the other entity
    SharesAuthorWith = "SharesAuthorWith"

    # The two entities result from activities that have been funded by the same funding agency
    SharesFundingAgencyWith = "SharesFundingAgencyWith"

    # The citing and cited bibliographic resources are published in the same journal
    SharesJournalWith = "SharesJournalWith"

    # The citing and cited bibliographic resources are published in same publication venue
    SharesPublicationVenueWith = "SharesPublicationVenueWith"

    # The citing entity speculates on something within or related to the cited entity, without firm evidence
    SpeculatesOn = "SpeculatesOn"

    # The citing entity provides intellectual or factual support for statements, ideas or conclusions presented in the cited entity
    Supports = "Supports"

    # The citing entity updates statements, ideas, hypotheses or understanding presented in the cited entity
    Updates = "Updates"

    # The citing entity describes work that uses conclusions presented in the cited entity
    UsesConclusionsFrom = "UsesConclusionsFrom"

    # The citing entity describes work that uses data presented in the cited entity
    UsesDataFrom = "UsesDataFrom"

    # The citing entity describes work that uses a method detailed in the cited entity
    UsesMethodIn = "UsesMethodIn"



"""
Union type for valid block content.
"""
BlockContent = Union["Claim", "CodeBlock", "CodeChunk", "Collection", "Figure", "Heading", "List", "MathBlock", "Paragraph", "QuoteBlock", "Table", "ThematicBreak"]


"""
All type schemas that are derived from CodeBlock
"""
CodeBlockTypes = Union["CodeBlock", "CodeChunk"]


"""
All type schemas that are derived from CodeFragment
"""
CodeFragmentTypes = Union["CodeFragment", "CodeExpression"]


"""
All type schemas that are derived from Code
"""
CodeTypes = Union["Code", "CodeBlock", "CodeChunk", "CodeExpression", "CodeFragment"]


"""
All type schemas that are derived from ContactPoint
"""
ContactPointTypes = Union["ContactPoint", "PostalAddress"]


"""
All type schemas that are derived from CreativeWork
"""
CreativeWorkTypes = Union["CreativeWork", "Article", "AudioObject", "Claim", "Collection", "Comment", "Datatable", "Figure", "ImageObject", "MediaObject", "Periodical", "PublicationIssue", "PublicationVolume", "Review", "SoftwareApplication", "SoftwareSourceCode", "Table", "VideoObject"]


"""
All type schemas that are derived from Entity
"""
EntityTypes = Union["Entity", "ArrayValidator", "Article", "AudioObject", "BooleanValidator", "Brand", "CitationIntentEnumeration", "Cite", "CiteGroup", "Claim", "Code", "CodeBlock", "CodeChunk", "CodeError", "CodeExpression", "CodeFragment", "Collection", "Comment", "ConstantValidator", "ContactPoint", "CreativeWork", "Datatable", "DatatableColumn", "Date", "DefinedTerm", "Delete", "Emphasis", "EnumValidator", "Enumeration", "Figure", "Function", "Grant", "Heading", "ImageObject", "Include", "IntegerValidator", "Link", "List", "ListItem", "Mark", "Math", "MathBlock", "MathFragment", "MediaObject", "MonetaryGrant", "NontextualAnnotation", "Note", "NumberValidator", "Organization", "Paragraph", "Parameter", "Periodical", "Person", "PostalAddress", "Product", "PropertyValue", "PublicationIssue", "PublicationVolume", "Quote", "QuoteBlock", "Review", "SoftwareApplication", "SoftwareEnvironment", "SoftwareSession", "SoftwareSourceCode", "StringValidator", "Strong", "Subscript", "Superscript", "Table", "TableCell", "TableRow", "ThematicBreak", "Thing", "TupleValidator", "Validator", "Variable", "VideoObject", "VolumeMount"]


"""
All type schemas that are derived from Enumeration
"""
EnumerationTypes = Union["Enumeration", "CitationIntentEnumeration"]


"""
All type schemas that are derived from Grant
"""
GrantTypes = Union["Grant", "MonetaryGrant"]


"""
Union type for valid inline content.
"""
InlineContent = Union["AudioObject", "Cite", "CiteGroup", "CodeExpression", "CodeFragment", "Delete", "Emphasis", "ImageObject", "Link", "MathFragment", "NontextualAnnotation", "Note", "Quote", "Strong", "Subscript", "Superscript", "VideoObject", None, bool, int, float, str]


"""
All type schemas that are derived from Mark
"""
MarkTypes = Union["Mark", "Delete", "Emphasis", "NontextualAnnotation", "Quote", "Strong", "Subscript", "Superscript"]


"""
All type schemas that are derived from Math
"""
MathTypes = Union["Math", "MathBlock", "MathFragment"]


"""
All type schemas that are derived from MediaObject
"""
MediaObjectTypes = Union["MediaObject", "AudioObject", "ImageObject", "VideoObject"]


"""
Union type for all schema nodes, including primitives and entities
"""
Node = Union["Entity", "ArrayValidator", "Article", "AudioObject", "BooleanValidator", "Brand", "CitationIntentEnumeration", "Cite", "CiteGroup", "Claim", "Code", "CodeBlock", "CodeChunk", "CodeError", "CodeExpression", "CodeFragment", "Collection", "Comment", "ConstantValidator", "ContactPoint", "CreativeWork", "Datatable", "DatatableColumn", "Date", "DefinedTerm", "Delete", "Emphasis", "EnumValidator", "Enumeration", "Figure", "Function", "Grant", "Heading", "ImageObject", "Include", "IntegerValidator", "Link", "List", "ListItem", "Mark", "Math", "MathBlock", "MathFragment", "MediaObject", "MonetaryGrant", "NontextualAnnotation", "Note", "NumberValidator", "Organization", "Paragraph", "Parameter", "Periodical", "Person", "PostalAddress", "Product", "PropertyValue", "PublicationIssue", "PublicationVolume", "Quote", "QuoteBlock", "Review", "SoftwareApplication", "SoftwareEnvironment", "SoftwareSession", "SoftwareSourceCode", "StringValidator", "Strong", "Subscript", "Superscript", "Table", "TableCell", "TableRow", "ThematicBreak", "Thing", "TupleValidator", "Validator", "Variable", "VideoObject", "VolumeMount", None, bool, int, float, str, Dict[str, Any], Array["Any"]]


"""
All type schemas that are derived from Thing
"""
ThingTypes = Union["Thing", "Article", "AudioObject", "Brand", "CitationIntentEnumeration", "Claim", "Collection", "Comment", "ContactPoint", "CreativeWork", "Datatable", "DatatableColumn", "DefinedTerm", "Enumeration", "Figure", "Grant", "ImageObject", "ListItem", "MediaObject", "MonetaryGrant", "Organization", "Periodical", "Person", "PostalAddress", "Product", "PropertyValue", "PublicationIssue", "PublicationVolume", "Review", "SoftwareApplication", "SoftwareEnvironment", "SoftwareSession", "SoftwareSourceCode", "Table", "VideoObject", "VolumeMount"]


"""
All type schemas that are derived from Validator
"""
ValidatorTypes = Union["Validator", "ArrayValidator", "BooleanValidator", "ConstantValidator", "EnumValidator", "IntegerValidator", "NumberValidator", "StringValidator", "TupleValidator"]


"""
All type schemas that are derived from Variable
"""
VariableTypes = Union["Variable", "Parameter"]

