# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2017-11-16 01:12
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import jsonfield.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('pinax_stripe', '0009_auto_20170825_1841'),
    ]

    operations = [
        migrations.CreateModel(
            name='Account',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stripe_id', models.CharField(max_length=191, unique=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('business_name', models.TextField(blank=True, null=True)),
                ('business_url', models.TextField(blank=True, null=True)),
                ('charges_enabled', models.BooleanField(default=False)),
                ('country', models.CharField(max_length=2)),
                ('debit_negative_balances', models.BooleanField(default=False)),
                ('decline_charge_on_avs_failure', models.BooleanField(default=False)),
                ('decline_charge_on_cvc_failure', models.BooleanField(default=False)),
                ('default_currency', models.CharField(max_length=3)),
                ('details_submitted', models.BooleanField(default=False)),
                ('display_name', models.TextField()),
                ('email', models.TextField(blank=True, null=True)),
                ('legal_entity_address_city', models.TextField(blank=True, null=True)),
                ('legal_entity_address_country', models.TextField(blank=True, null=True)),
                ('legal_entity_address_line1', models.TextField(blank=True, null=True)),
                ('legal_entity_address_line2', models.TextField(blank=True, null=True)),
                ('legal_entity_address_postal_code', models.TextField(blank=True, null=True)),
                ('legal_entity_address_state', models.TextField(blank=True, null=True)),
                ('legal_entity_dob', models.DateField(null=True)),
                ('legal_entity_first_name', models.TextField(blank=True, null=True)),
                ('legal_entity_gender', models.TextField(blank=True, null=True)),
                ('legal_entity_last_name', models.TextField(blank=True, null=True)),
                ('legal_entity_maiden_name', models.TextField(blank=True, null=True)),
                ('legal_entity_personal_id_number_provided', models.BooleanField(default=False)),
                ('legal_entity_phone_number', models.TextField(blank=True, null=True)),
                ('legal_entity_ssn_last_4_provided', models.BooleanField(default=False)),
                ('legal_entity_type', models.TextField(blank=True, null=True)),
                ('legal_entity_verification_details', models.TextField(blank=True, null=True)),
                ('legal_entity_verification_details_code', models.TextField(blank=True, null=True)),
                ('legal_entity_verification_document', models.TextField(blank=True, null=True)),
                ('legal_entity_verification_status', models.TextField(blank=True, null=True)),
                ('type', models.TextField(blank=True, null=True)),
                ('metadata', jsonfield.fields.JSONField(blank=True, null=True)),
                ('stripe_publishable_key', models.CharField(blank=True, max_length=100, null=True)),
                ('product_description', models.TextField(blank=True, null=True)),
                ('statement_descriptor', models.TextField(blank=True, null=True)),
                ('support_email', models.TextField(blank=True, null=True)),
                ('support_phone', models.TextField(blank=True, null=True)),
                ('timezone', models.TextField(blank=True, null=True)),
                ('tos_acceptance_date', models.DateField(null=True)),
                ('tos_acceptance_ip', models.TextField(blank=True, null=True)),
                ('tos_acceptance_user_agent', models.TextField(blank=True, null=True)),
                ('transfer_schedule_delay_days', models.PositiveSmallIntegerField(null=True)),
                ('transfer_schedule_interval', models.TextField(blank=True, null=True)),
                ('transfer_schedule_monthly_anchor', models.PositiveSmallIntegerField(null=True)),
                ('transfer_schedule_weekly_anchor', models.TextField(blank=True, null=True)),
                ('transfer_statement_descriptor', models.TextField(blank=True, null=True)),
                ('transfers_enabled', models.BooleanField(default=False)),
                ('verification_disabled_reason', models.TextField(blank=True, null=True)),
                ('verification_due_by', models.DateTimeField(blank=True, null=True)),
                ('verification_timestamp', models.DateTimeField(blank=True, null=True)),
                ('verification_fields_needed', jsonfield.fields.JSONField(blank=True, null=True)),
                ('authorized', models.BooleanField(default=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='stripe_accounts', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BankAccount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stripe_id', models.CharField(max_length=191, unique=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('account_holder_name', models.TextField()),
                ('account_holder_type', models.TextField()),
                ('bank_name', models.TextField(blank=True, null=True)),
                ('country', models.TextField()),
                ('currency', models.TextField()),
                ('default_for_currency', models.BooleanField(default=False)),
                ('fingerprint', models.TextField()),
                ('last4', models.CharField(max_length=4)),
                ('metadata', jsonfield.fields.JSONField(blank=True, null=True)),
                ('routing_number', models.TextField()),
                ('status', models.TextField()),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bank_accounts', to='pinax_stripe.Account')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UserAccount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_accounts', related_query_name='user_account', to='pinax_stripe.Account')),
            ],
        ),
        migrations.AddField(
            model_name='charge',
            name='available',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='charge',
            name='available_on',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='charge',
            name='fee',
            field=models.DecimalField(blank=True, decimal_places=2, max_digits=9, null=True),
        ),
        migrations.AddField(
            model_name='charge',
            name='fee_currency',
            field=models.CharField(blank=True, max_length=10, null=True),
        ),
        migrations.AddField(
            model_name='charge',
            name='transfer_group',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='amount_reversed',
            field=models.DecimalField(blank=True, decimal_places=2, max_digits=9, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='application_fee',
            field=models.DecimalField(blank=True, decimal_places=2, max_digits=9, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='created',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='destination',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='destination_payment',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='failure_code',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='failure_message',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='livemode',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='transfer',
            name='metadata',
            field=jsonfield.fields.JSONField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='method',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='reversed',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='transfer',
            name='source_transaction',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='source_type',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='statement_descriptor',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='transfer_group',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='transfer',
            name='type',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='coupon',
            name='metadata',
            field=jsonfield.fields.JSONField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='customer',
            name='account_balance',
            field=models.DecimalField(blank=True, decimal_places=2, max_digits=9, null=True),
        ),
        migrations.AlterField(
            model_name='customer',
            name='user',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='event',
            name='validated_message',
            field=jsonfield.fields.JSONField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='plan',
            name='metadata',
            field=jsonfield.fields.JSONField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='useraccount',
            name='customer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_accounts', related_query_name='user_account', to='pinax_stripe.Customer'),
        ),
        migrations.AddField(
            model_name='useraccount',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_accounts', related_query_name='user_account', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='customer',
            name='stripe_account',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='pinax_stripe.Account'),
        ),
        migrations.AddField(
            model_name='customer',
            name='users',
            field=models.ManyToManyField(related_name='customers', related_query_name='customers', through='pinax_stripe.UserAccount', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='event',
            name='stripe_account',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='pinax_stripe.Account'),
        ),
        migrations.AddField(
            model_name='plan',
            name='stripe_account',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='pinax_stripe.Account'),
        ),
        migrations.AddField(
            model_name='transfer',
            name='stripe_account',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='pinax_stripe.Account'),
        ),
        migrations.AlterUniqueTogether(
            name='useraccount',
            unique_together=set([('user', 'account')]),
        ),
    ]
