# coding: utf-8

"""
    Wise Platform API

    Comprehensive API for Wise platform services including: - Profile - Activity tracking and management - Quote creation and management - Recipient - Transfer 

    The version of the OpenAPI document: 0.0.2
    Contact: maksim.ploter@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from wise_api_client.models.transfer_details import TransferDetails
from typing import Optional, Set
from typing_extensions import Self

class StandardTransfer(BaseModel):
    """
    StandardTransfer
    """ # noqa: E501
    id: StrictInt
    user: StrictInt
    target_account: StrictInt = Field(alias="targetAccount")
    source_account: Optional[StrictInt] = Field(default=None, alias="sourceAccount")
    quote: Optional[StrictInt] = None
    quote_uuid: StrictStr = Field(alias="quoteUuid")
    status: StrictStr
    reference: Optional[StrictStr] = None
    rate: Union[StrictFloat, StrictInt]
    created: datetime
    business: Optional[StrictInt] = None
    transfer_request: Optional[StrictInt] = Field(default=None, alias="transferRequest")
    details: TransferDetails
    has_active_issues: Optional[StrictBool] = Field(default=None, alias="hasActiveIssues")
    source_currency: Annotated[str, Field(strict=True)] = Field(alias="sourceCurrency")
    source_value: Union[StrictFloat, StrictInt] = Field(alias="sourceValue")
    target_currency: Annotated[str, Field(strict=True)] = Field(alias="targetCurrency")
    target_value: Union[StrictFloat, StrictInt] = Field(alias="targetValue")
    customer_transaction_id: Optional[StrictStr] = Field(default=None, alias="customerTransactionId")
    __properties: ClassVar[List[str]] = ["id", "user", "targetAccount", "sourceAccount", "quote", "quoteUuid", "status", "reference", "rate", "created", "business", "transferRequest", "details", "hasActiveIssues", "sourceCurrency", "sourceValue", "targetCurrency", "targetValue", "customerTransactionId"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pending', 'processing', 'funded', 'cancelled', 'outgoing_payment_sent', 'funds_refunded']):
            raise ValueError("must be one of enum values ('pending', 'processing', 'funded', 'cancelled', 'outgoing_payment_sent', 'funds_refunded')")
        return value

    @field_validator('source_currency')
    def source_currency_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[A-Z]{3}$", value):
            raise ValueError(r"must validate the regular expression /^[A-Z]{3}$/")
        return value

    @field_validator('target_currency')
    def target_currency_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[A-Z]{3}$", value):
            raise ValueError(r"must validate the regular expression /^[A-Z]{3}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StandardTransfer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of details
        if self.details:
            _dict['details'] = self.details.to_dict()
        # set to None if source_account (nullable) is None
        # and model_fields_set contains the field
        if self.source_account is None and "source_account" in self.model_fields_set:
            _dict['sourceAccount'] = None

        # set to None if quote (nullable) is None
        # and model_fields_set contains the field
        if self.quote is None and "quote" in self.model_fields_set:
            _dict['quote'] = None

        # set to None if business (nullable) is None
        # and model_fields_set contains the field
        if self.business is None and "business" in self.model_fields_set:
            _dict['business'] = None

        # set to None if transfer_request (nullable) is None
        # and model_fields_set contains the field
        if self.transfer_request is None and "transfer_request" in self.model_fields_set:
            _dict['transferRequest'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StandardTransfer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "user": obj.get("user"),
            "targetAccount": obj.get("targetAccount"),
            "sourceAccount": obj.get("sourceAccount"),
            "quote": obj.get("quote"),
            "quoteUuid": obj.get("quoteUuid"),
            "status": obj.get("status"),
            "reference": obj.get("reference"),
            "rate": obj.get("rate"),
            "created": obj.get("created"),
            "business": obj.get("business"),
            "transferRequest": obj.get("transferRequest"),
            "details": TransferDetails.from_dict(obj["details"]) if obj.get("details") is not None else None,
            "hasActiveIssues": obj.get("hasActiveIssues"),
            "sourceCurrency": obj.get("sourceCurrency"),
            "sourceValue": obj.get("sourceValue"),
            "targetCurrency": obj.get("targetCurrency"),
            "targetValue": obj.get("targetValue"),
            "customerTransactionId": obj.get("customerTransactionId")
        })
        return _obj


