# coding: utf-8

"""
    Wise Platform API

    Comprehensive API for Wise platform services including: - Profile - Activity tracking and management - Quote creation and management - Recipient - Transfer 

    The version of the OpenAPI document: 0.0.2
    Contact: maksim.ploter@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wise_api_client.models.recipient_common_field_map import RecipientCommonFieldMap
from wise_api_client.models.recipient_details import RecipientDetails
from wise_api_client.models.recipient_display_fields_inner import RecipientDisplayFieldsInner
from wise_api_client.models.recipient_name import RecipientName
from typing import Optional, Set
from typing_extensions import Self

class Recipient(BaseModel):
    """
    Recipient
    """ # noqa: E501
    id: Optional[StrictInt] = None
    creator_id: Optional[StrictInt] = Field(default=None, alias="creatorId")
    profile_id: Optional[StrictInt] = Field(default=None, alias="profileId")
    name: Optional[RecipientName] = None
    currency: Optional[StrictStr] = None
    country: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    legal_entity_type: Optional[StrictStr] = Field(default=None, alias="legalEntityType")
    active: Optional[StrictBool] = None
    details: Optional[RecipientDetails] = None
    common_field_map: Optional[RecipientCommonFieldMap] = Field(default=None, alias="commonFieldMap")
    hash: Optional[StrictStr] = None
    account_summary: Optional[StrictStr] = Field(default=None, alias="accountSummary")
    long_account_summary: Optional[StrictStr] = Field(default=None, alias="longAccountSummary")
    display_fields: Optional[List[RecipientDisplayFieldsInner]] = Field(default=None, alias="displayFields")
    owned_by_customer: Optional[StrictBool] = Field(default=None, alias="ownedByCustomer")
    __properties: ClassVar[List[str]] = ["id", "creatorId", "profileId", "name", "currency", "country", "type", "legalEntityType", "active", "details", "commonFieldMap", "hash", "accountSummary", "longAccountSummary", "displayFields", "ownedByCustomer"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Recipient from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of name
        if self.name:
            _dict['name'] = self.name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of details
        if self.details:
            _dict['details'] = self.details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of common_field_map
        if self.common_field_map:
            _dict['commonFieldMap'] = self.common_field_map.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in display_fields (list)
        _items = []
        if self.display_fields:
            for _item_display_fields in self.display_fields:
                if _item_display_fields:
                    _items.append(_item_display_fields.to_dict())
            _dict['displayFields'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Recipient from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "creatorId": obj.get("creatorId"),
            "profileId": obj.get("profileId"),
            "name": RecipientName.from_dict(obj["name"]) if obj.get("name") is not None else None,
            "currency": obj.get("currency"),
            "country": obj.get("country"),
            "type": obj.get("type"),
            "legalEntityType": obj.get("legalEntityType"),
            "active": obj.get("active"),
            "details": RecipientDetails.from_dict(obj["details"]) if obj.get("details") is not None else None,
            "commonFieldMap": RecipientCommonFieldMap.from_dict(obj["commonFieldMap"]) if obj.get("commonFieldMap") is not None else None,
            "hash": obj.get("hash"),
            "accountSummary": obj.get("accountSummary"),
            "longAccountSummary": obj.get("longAccountSummary"),
            "displayFields": [RecipientDisplayFieldsInner.from_dict(_item) for _item in obj["displayFields"]] if obj.get("displayFields") is not None else None,
            "ownedByCustomer": obj.get("ownedByCustomer")
        })
        return _obj


