# coding: utf-8

"""
    Wise Platform API

    Comprehensive API for Wise platform services including: - Profile - Activity tracking and management - Quote creation and management - Recipient - Transfer 

    The version of the OpenAPI document: 0.0.2
    Contact: maksim.ploter@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wise_api_client.models.personal_profile_details_occupations_inner import PersonalProfileDetailsOccupationsInner
from typing import Optional, Set
from typing_extensions import Self

class PersonalProfileDetails(BaseModel):
    """
    PersonalProfileDetails
    """ # noqa: E501
    first_name: Optional[StrictStr] = Field(default=None, alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, alias="lastName")
    date_of_birth: Optional[date] = Field(default=None, alias="dateOfBirth")
    phone_number: Optional[StrictStr] = Field(default=None, alias="phoneNumber")
    avatar: Optional[StrictStr] = None
    occupations: Optional[List[PersonalProfileDetailsOccupationsInner]] = None
    primary_address: Optional[StrictInt] = Field(default=None, alias="primaryAddress")
    first_name_in_kana: Optional[StrictStr] = Field(default=None, alias="firstNameInKana")
    last_name_in_kana: Optional[StrictStr] = Field(default=None, alias="lastNameInKana")
    __properties: ClassVar[List[str]] = ["firstName", "lastName", "dateOfBirth", "phoneNumber", "avatar", "occupations", "primaryAddress", "firstNameInKana", "lastNameInKana"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PersonalProfileDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in occupations (list)
        _items = []
        if self.occupations:
            for _item_occupations in self.occupations:
                if _item_occupations:
                    _items.append(_item_occupations.to_dict())
            _dict['occupations'] = _items
        # set to None if primary_address (nullable) is None
        # and model_fields_set contains the field
        if self.primary_address is None and "primary_address" in self.model_fields_set:
            _dict['primaryAddress'] = None

        # set to None if first_name_in_kana (nullable) is None
        # and model_fields_set contains the field
        if self.first_name_in_kana is None and "first_name_in_kana" in self.model_fields_set:
            _dict['firstNameInKana'] = None

        # set to None if last_name_in_kana (nullable) is None
        # and model_fields_set contains the field
        if self.last_name_in_kana is None and "last_name_in_kana" in self.model_fields_set:
            _dict['lastNameInKana'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PersonalProfileDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "dateOfBirth": obj.get("dateOfBirth"),
            "phoneNumber": obj.get("phoneNumber"),
            "avatar": obj.get("avatar"),
            "occupations": [PersonalProfileDetailsOccupationsInner.from_dict(_item) for _item in obj["occupations"]] if obj.get("occupations") is not None else None,
            "primaryAddress": obj.get("primaryAddress"),
            "firstNameInKana": obj.get("firstNameInKana"),
            "lastNameInKana": obj.get("lastNameInKana")
        })
        return _obj


