# coding: utf-8

"""
    Wise Platform API

    Comprehensive API for Wise platform services including: - Profile - Activity tracking and management - Quote creation and management - Recipient - Transfer 

    The version of the OpenAPI document: 0.0.2
    Contact: maksim.ploter@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wise_api_client.models.fee_details import FeeDetails
from wise_api_client.models.price_details import PriceDetails
from typing import Optional, Set
from typing_extensions import Self

class PaymentOption(BaseModel):
    """
    PaymentOption
    """ # noqa: E501
    disabled: Optional[StrictBool] = None
    estimated_delivery: Optional[datetime] = Field(default=None, alias="estimatedDelivery")
    formatted_estimated_delivery: Optional[StrictStr] = Field(default=None, alias="formattedEstimatedDelivery")
    fee: Optional[FeeDetails] = None
    price: Optional[PriceDetails] = None
    pay_in: Optional[StrictStr] = Field(default=None, alias="payIn")
    pay_out: Optional[StrictStr] = Field(default=None, alias="payOut")
    __properties: ClassVar[List[str]] = ["disabled", "estimatedDelivery", "formattedEstimatedDelivery", "fee", "price", "payIn", "payOut"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentOption from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of fee
        if self.fee:
            _dict['fee'] = self.fee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict['price'] = self.price.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentOption from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "disabled": obj.get("disabled"),
            "estimatedDelivery": obj.get("estimatedDelivery"),
            "formattedEstimatedDelivery": obj.get("formattedEstimatedDelivery"),
            "fee": FeeDetails.from_dict(obj["fee"]) if obj.get("fee") is not None else None,
            "price": PriceDetails.from_dict(obj["price"]) if obj.get("price") is not None else None,
            "payIn": obj.get("payIn"),
            "payOut": obj.get("payOut")
        })
        return _obj


