# coding: utf-8

"""
    Wise Platform API

    Comprehensive API for Wise platform services including: - Profile - Activity tracking and management - Quote creation and management - Recipient - Transfer 

    The version of the OpenAPI document: 0.0.2
    Contact: maksim.ploter@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class OriginatorAddress(BaseModel):
    """
    OriginatorAddress
    """ # noqa: E501
    first_line: StrictStr = Field(alias="firstLine")
    city: StrictStr
    state_code: Optional[StrictStr] = Field(default=None, alias="stateCode")
    country_code: Annotated[str, Field(strict=True)] = Field(alias="countryCode")
    post_code: Optional[StrictStr] = Field(default=None, alias="postCode")
    __properties: ClassVar[List[str]] = ["firstLine", "city", "stateCode", "countryCode", "postCode"]

    @field_validator('country_code')
    def country_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[A-Z]{2}$", value):
            raise ValueError(r"must validate the regular expression /^[A-Z]{2}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OriginatorAddress from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if state_code (nullable) is None
        # and model_fields_set contains the field
        if self.state_code is None and "state_code" in self.model_fields_set:
            _dict['stateCode'] = None

        # set to None if post_code (nullable) is None
        # and model_fields_set contains the field
        if self.post_code is None and "post_code" in self.model_fields_set:
            _dict['postCode'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OriginatorAddress from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "firstLine": obj.get("firstLine"),
            "city": obj.get("city"),
            "stateCode": obj.get("stateCode"),
            "countryCode": obj.get("countryCode"),
            "postCode": obj.get("postCode")
        })
        return _obj


