# coding: utf-8

"""
    Wise Platform API

    Comprehensive API for Wise platform services including: - Profile - Activity tracking and management - Quote creation and management - Recipient - Transfer 

    The version of the OpenAPI document: 0.0.2
    Contact: maksim.ploter@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wise_api_client.models.originator_address import OriginatorAddress
from wise_api_client.models.originator_name import OriginatorName
from typing import Optional, Set
from typing_extensions import Self

class Originator(BaseModel):
    """
    Originator
    """ # noqa: E501
    legal_entity_type: StrictStr = Field(alias="legalEntityType")
    reference: StrictStr
    name: Optional[OriginatorName] = None
    date_of_birth: Optional[date] = Field(default=None, alias="dateOfBirth")
    business_registration_code: Optional[StrictStr] = Field(default=None, alias="businessRegistrationCode")
    address: OriginatorAddress
    account_details: Optional[StrictStr] = Field(default=None, alias="accountDetails")
    __properties: ClassVar[List[str]] = ["legalEntityType", "reference", "name", "dateOfBirth", "businessRegistrationCode", "address", "accountDetails"]

    @field_validator('legal_entity_type')
    def legal_entity_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['PRIVATE', 'BUSINESS']):
            raise ValueError("must be one of enum values ('PRIVATE', 'BUSINESS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Originator from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of name
        if self.name:
            _dict['name'] = self.name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # set to None if business_registration_code (nullable) is None
        # and model_fields_set contains the field
        if self.business_registration_code is None and "business_registration_code" in self.model_fields_set:
            _dict['businessRegistrationCode'] = None

        # set to None if account_details (nullable) is None
        # and model_fields_set contains the field
        if self.account_details is None and "account_details" in self.model_fields_set:
            _dict['accountDetails'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Originator from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "legalEntityType": obj.get("legalEntityType"),
            "reference": obj.get("reference"),
            "name": OriginatorName.from_dict(obj["name"]) if obj.get("name") is not None else None,
            "dateOfBirth": obj.get("dateOfBirth"),
            "businessRegistrationCode": obj.get("businessRegistrationCode"),
            "address": OriginatorAddress.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "accountDetails": obj.get("accountDetails")
        })
        return _obj


