# coding: utf-8

"""
    Wise Platform API

    Comprehensive API for Wise platform services including: - Profile - Activity tracking and management - Quote creation and management - Recipient - Transfer 

    The version of the OpenAPI document: 0.0.2
    Contact: maksim.ploter@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from wise_api_client.models.create_personal_profile_request_address import CreatePersonalProfileRequestAddress
from wise_api_client.models.create_personal_profile_request_contact_details import CreatePersonalProfileRequestContactDetails
from typing import Optional, Set
from typing_extensions import Self

class CreatePersonalProfileRequest(BaseModel):
    """
    CreatePersonalProfileRequest
    """ # noqa: E501
    first_name: Annotated[str, Field(strict=True, max_length=30)] = Field(alias="firstName")
    last_name: Annotated[str, Field(strict=True, max_length=30)] = Field(alias="lastName")
    address: CreatePersonalProfileRequestAddress
    contact_details: CreatePersonalProfileRequestContactDetails = Field(alias="contactDetails")
    __properties: ClassVar[List[str]] = ["firstName", "lastName", "address", "contactDetails"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreatePersonalProfileRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contact_details
        if self.contact_details:
            _dict['contactDetails'] = self.contact_details.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreatePersonalProfileRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "address": CreatePersonalProfileRequestAddress.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "contactDetails": CreatePersonalProfileRequestContactDetails.from_dict(obj["contactDetails"]) if obj.get("contactDetails") is not None else None
        })
        return _obj


