# coding: utf-8

"""
    Wise Platform API

    Comprehensive API for Wise platform services including: - Profile - Activity tracking and management - Quote creation and management - Recipient - Transfer 

    The version of the OpenAPI document: 0.0.2
    Contact: maksim.ploter@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class BankingPartnerInvoice(BaseModel):
    """
    BankingPartnerInvoice
    """ # noqa: E501
    processor_name: Optional[StrictStr] = Field(default=None, alias="processorName")
    delivery_mode: Optional[StrictStr] = Field(default=None, alias="deliveryMode")
    banking_partner_reference: Optional[StrictStr] = Field(default=None, alias="bankingPartnerReference")
    banking_partner_name: Optional[StrictStr] = Field(default=None, alias="bankingPartnerName")
    mt103: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["processorName", "deliveryMode", "bankingPartnerReference", "bankingPartnerName", "mt103"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BankingPartnerInvoice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if mt103 (nullable) is None
        # and model_fields_set contains the field
        if self.mt103 is None and "mt103" in self.model_fields_set:
            _dict['mt103'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BankingPartnerInvoice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "processorName": obj.get("processorName"),
            "deliveryMode": obj.get("deliveryMode"),
            "bankingPartnerReference": obj.get("bankingPartnerReference"),
            "bankingPartnerName": obj.get("bankingPartnerName"),
            "mt103": obj.get("mt103")
        })
        return _obj


