# coding: utf-8

"""
    Wise Platform API

    Comprehensive API for Wise platform services including: - Profile - Activity tracking and management - Quote creation and management - Recipient - Transfer 

    The version of the OpenAPI document: 0.0.2
    Contact: maksim.ploter@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wise_api_client.models.activity_resource import ActivityResource
from wise_api_client.models.activity_status import ActivityStatus
from wise_api_client.models.activity_type import ActivityType
from typing import Optional, Set
from typing_extensions import Self

class Activity(BaseModel):
    """
    Activity
    """ # noqa: E501
    id: StrictStr = Field(description="Unique activity identifier")
    type: ActivityType
    resource: ActivityResource
    title: StrictStr = Field(description="Title with custom formatting tags: <strong>, <positive>, <negative>, <strikethrough> ")
    description: Optional[StrictStr] = Field(default=None, description="Brief activity summary")
    primary_amount: Optional[StrictStr] = Field(default=None, description="Currency-formatted primary amount (e.g., \"100 USD\")", alias="primaryAmount")
    secondary_amount: Optional[StrictStr] = Field(default=None, description="Currency-formatted secondary amount (optional)", alias="secondaryAmount")
    status: ActivityStatus
    created_on: datetime = Field(alias="createdOn")
    updated_on: datetime = Field(alias="updatedOn")
    __properties: ClassVar[List[str]] = ["id", "type", "resource", "title", "description", "primaryAmount", "secondaryAmount", "status", "createdOn", "updatedOn"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Activity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of resource
        if self.resource:
            _dict['resource'] = self.resource.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Activity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "resource": ActivityResource.from_dict(obj["resource"]) if obj.get("resource") is not None else None,
            "title": obj.get("title"),
            "description": obj.get("description"),
            "primaryAmount": obj.get("primaryAmount"),
            "secondaryAmount": obj.get("secondaryAmount"),
            "status": obj.get("status"),
            "createdOn": obj.get("createdOn"),
            "updatedOn": obj.get("updatedOn")
        })
        return _obj


