# coding: utf-8

"""
    Wise Platform API

    Comprehensive API for Wise platform services including: - Profile - Activity tracking and management - Quote creation and management - Recipient - Transfer 

    The version of the OpenAPI document: 0.0.2
    Contact: maksim.ploter@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wise_api_client.models.account_requirements_inner_fields_inner_group_inner_values_allowed_inner import AccountRequirementsInnerFieldsInnerGroupInnerValuesAllowedInner
from typing import Optional, Set
from typing_extensions import Self

class AccountRequirementsInnerFieldsInnerGroupInner(BaseModel):
    """
    AccountRequirementsInnerFieldsInnerGroupInner
    """ # noqa: E501
    key: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    required: Optional[StrictBool] = None
    validation_regexp: Optional[StrictStr] = Field(default=None, alias="validationRegexp")
    values_allowed: Optional[List[AccountRequirementsInnerFieldsInnerGroupInnerValuesAllowedInner]] = Field(default=None, alias="valuesAllowed")
    __properties: ClassVar[List[str]] = ["key", "name", "type", "required", "validationRegexp", "valuesAllowed"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccountRequirementsInnerFieldsInnerGroupInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in values_allowed (list)
        _items = []
        if self.values_allowed:
            for _item_values_allowed in self.values_allowed:
                if _item_values_allowed:
                    _items.append(_item_values_allowed.to_dict())
            _dict['valuesAllowed'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccountRequirementsInnerFieldsInnerGroupInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "required": obj.get("required"),
            "validationRegexp": obj.get("validationRegexp"),
            "valuesAllowed": [AccountRequirementsInnerFieldsInnerGroupInnerValuesAllowedInner.from_dict(_item) for _item in obj["valuesAllowed"]] if obj.get("valuesAllowed") is not None else None
        })
        return _obj


