# coding: utf-8

"""
    Wise Platform API

    Comprehensive API for Wise platform services including: - Profile - Activity tracking and management - Quote creation and management - Recipient - Transfer 

    The version of the OpenAPI document: 0.0.2
    Contact: maksim.ploter@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated
from wise_api_client.models.activities_response import ActivitiesResponse
from wise_api_client.models.activity_resource_type import ActivityResourceType
from wise_api_client.models.activity_status import ActivityStatus

from wise_api_client.api_client import ApiClient, RequestSerialized
from wise_api_client.api_response import ApiResponse
from wise_api_client.rest import RESTResponseType


class ActivitiesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def v1_profiles_profile_id_activities_get(
        self,
        profile_id: Annotated[StrictStr, Field(description="ID of the user profile")],
        monetary_resource_type: Annotated[Optional[ActivityResourceType], Field(description="Filter by resource type")] = None,
        status: Annotated[Optional[ActivityStatus], Field(description="Filter by activity status")] = None,
        since: Annotated[Optional[datetime], Field(description="Filter activities created after this timestamp")] = None,
        until: Annotated[Optional[datetime], Field(description="Filter activities created before this timestamp")] = None,
        next_cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor for next page")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of results per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ActivitiesResponse:
        """List activities for a profile

        Retrieve paginated list of activities for a user profile with filtering options

        :param profile_id: ID of the user profile (required)
        :type profile_id: str
        :param monetary_resource_type: Filter by resource type
        :type monetary_resource_type: ActivityResourceType
        :param status: Filter by activity status
        :type status: ActivityStatus
        :param since: Filter activities created after this timestamp
        :type since: datetime
        :param until: Filter activities created before this timestamp
        :type until: datetime
        :param next_cursor: Pagination cursor for next page
        :type next_cursor: str
        :param size: Number of results per page
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_profiles_profile_id_activities_get_serialize(
            profile_id=profile_id,
            monetary_resource_type=monetary_resource_type,
            status=status,
            since=since,
            until=until,
            next_cursor=next_cursor,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActivitiesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v1_profiles_profile_id_activities_get_with_http_info(
        self,
        profile_id: Annotated[StrictStr, Field(description="ID of the user profile")],
        monetary_resource_type: Annotated[Optional[ActivityResourceType], Field(description="Filter by resource type")] = None,
        status: Annotated[Optional[ActivityStatus], Field(description="Filter by activity status")] = None,
        since: Annotated[Optional[datetime], Field(description="Filter activities created after this timestamp")] = None,
        until: Annotated[Optional[datetime], Field(description="Filter activities created before this timestamp")] = None,
        next_cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor for next page")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of results per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ActivitiesResponse]:
        """List activities for a profile

        Retrieve paginated list of activities for a user profile with filtering options

        :param profile_id: ID of the user profile (required)
        :type profile_id: str
        :param monetary_resource_type: Filter by resource type
        :type monetary_resource_type: ActivityResourceType
        :param status: Filter by activity status
        :type status: ActivityStatus
        :param since: Filter activities created after this timestamp
        :type since: datetime
        :param until: Filter activities created before this timestamp
        :type until: datetime
        :param next_cursor: Pagination cursor for next page
        :type next_cursor: str
        :param size: Number of results per page
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_profiles_profile_id_activities_get_serialize(
            profile_id=profile_id,
            monetary_resource_type=monetary_resource_type,
            status=status,
            since=since,
            until=until,
            next_cursor=next_cursor,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActivitiesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v1_profiles_profile_id_activities_get_without_preload_content(
        self,
        profile_id: Annotated[StrictStr, Field(description="ID of the user profile")],
        monetary_resource_type: Annotated[Optional[ActivityResourceType], Field(description="Filter by resource type")] = None,
        status: Annotated[Optional[ActivityStatus], Field(description="Filter by activity status")] = None,
        since: Annotated[Optional[datetime], Field(description="Filter activities created after this timestamp")] = None,
        until: Annotated[Optional[datetime], Field(description="Filter activities created before this timestamp")] = None,
        next_cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor for next page")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of results per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List activities for a profile

        Retrieve paginated list of activities for a user profile with filtering options

        :param profile_id: ID of the user profile (required)
        :type profile_id: str
        :param monetary_resource_type: Filter by resource type
        :type monetary_resource_type: ActivityResourceType
        :param status: Filter by activity status
        :type status: ActivityStatus
        :param since: Filter activities created after this timestamp
        :type since: datetime
        :param until: Filter activities created before this timestamp
        :type until: datetime
        :param next_cursor: Pagination cursor for next page
        :type next_cursor: str
        :param size: Number of results per page
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_profiles_profile_id_activities_get_serialize(
            profile_id=profile_id,
            monetary_resource_type=monetary_resource_type,
            status=status,
            since=since,
            until=until,
            next_cursor=next_cursor,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActivitiesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_profiles_profile_id_activities_get_serialize(
        self,
        profile_id,
        monetary_resource_type,
        status,
        since,
        until,
        next_cursor,
        size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if profile_id is not None:
            _path_params['profileId'] = profile_id
        # process the query parameters
        if monetary_resource_type is not None:
            
            _query_params.append(('monetaryResourceType', monetary_resource_type.value))
            
        if status is not None:
            
            _query_params.append(('status', status.value))
            
        if since is not None:
            if isinstance(since, datetime):
                _query_params.append(
                    (
                        'since',
                        since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('since', since))
            
        if until is not None:
            if isinstance(until, datetime):
                _query_params.append(
                    (
                        'until',
                        until.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('until', until))
            
        if next_cursor is not None:
            
            _query_params.append(('nextCursor', next_cursor))
            
        if size is not None:
            
            _query_params.append(('size', size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/profiles/{profileId}/activities',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


