# wise-api-client
Comprehensive API for Wise platform services including:
- Profile
- Activity tracking and management
- Quote creation and management
- Recipient
- Transfer


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.2
- Package version: 0.0.2
- Build date: 2025-04-04T16:47:05.081858584Z[Etc/UTC]
- Generator version: 7.13.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/maxploter/wise-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/maxploter/wise-python.git`)

Then import the package:
```python
import wise_api_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import wise_api_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import wise_api_client
from wise_api_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.sandbox.transferwise.tech
# See configuration.py for a list of all supported configuration parameters.
configuration = wise_api_client.Configuration(
    host = "https://api.sandbox.transferwise.tech"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = wise_api_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with wise_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = wise_api_client.ActivitiesApi(api_client)
    profile_id = 'profile_id_example' # str | ID of the user profile
    monetary_resource_type = wise_api_client.ActivityResourceType() # ActivityResourceType | Filter by resource type (optional)
    status = wise_api_client.ActivityStatus() # ActivityStatus | Filter by activity status (optional)
    since = '2013-10-20T19:20:30+01:00' # datetime | Filter activities created after this timestamp (optional)
    until = '2013-10-20T19:20:30+01:00' # datetime | Filter activities created before this timestamp (optional)
    next_cursor = 'next_cursor_example' # str | Pagination cursor for next page (optional)
    size = 10 # int | Number of results per page (optional) (default to 10)

    try:
        # List activities for a profile
        api_response = api_instance.v1_profiles_profile_id_activities_get(profile_id, monetary_resource_type=monetary_resource_type, status=status, since=since, until=until, next_cursor=next_cursor, size=size)
        print("The response of ActivitiesApi->v1_profiles_profile_id_activities_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ActivitiesApi->v1_profiles_profile_id_activities_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.sandbox.transferwise.tech*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActivitiesApi* | [**v1_profiles_profile_id_activities_get**](docs/ActivitiesApi.md#v1_profiles_profile_id_activities_get) | **GET** /v1/profiles/{profileId}/activities | List activities for a profile
*ProfilesApi* | [**create_business_profile**](docs/ProfilesApi.md#create_business_profile) | **POST** /v2/profiles/business-profile | Create a business profile
*ProfilesApi* | [**create_personal_profile**](docs/ProfilesApi.md#create_personal_profile) | **POST** /v2/profiles/personal-profile | Create a personal profile
*ProfilesApi* | [**v1_profiles_profile_id_directors_get**](docs/ProfilesApi.md#v1_profiles_profile_id_directors_get) | **GET** /v1/profiles/{profileId}/directors | List directors
*ProfilesApi* | [**v1_profiles_profile_id_directors_post**](docs/ProfilesApi.md#v1_profiles_profile_id_directors_post) | **POST** /v1/profiles/{profileId}/directors | Add directors
*ProfilesApi* | [**v1_profiles_profile_id_directors_put**](docs/ProfilesApi.md#v1_profiles_profile_id_directors_put) | **PUT** /v1/profiles/{profileId}/directors | Update directors
*ProfilesApi* | [**v1_profiles_profile_id_verification_documents_post**](docs/ProfilesApi.md#v1_profiles_profile_id_verification_documents_post) | **POST** /v1/profiles/{profileId}/verification-documents | Create identification document
*ProfilesApi* | [**v2_profiles_get**](docs/ProfilesApi.md#v2_profiles_get) | **GET** /v2/profiles | List profiles for a user account
*ProfilesApi* | [**v2_profiles_profile_id_business_profile_put**](docs/ProfilesApi.md#v2_profiles_profile_id_business_profile_put) | **PUT** /v2/profiles/{profileId}/business-profile | Update a business profile
*ProfilesApi* | [**v2_profiles_profile_id_get**](docs/ProfilesApi.md#v2_profiles_profile_id_get) | **GET** /v2/profiles/{profileId} | Retrieve a profile by ID
*ProfilesApi* | [**v2_profiles_profile_id_personal_profile_put**](docs/ProfilesApi.md#v2_profiles_profile_id_personal_profile_put) | **PUT** /v2/profiles/{profileId}/personal-profile | Update a personal profile
*ProfilesApi* | [**v3_profiles_profile_id_verification_status_bank_transfer_post**](docs/ProfilesApi.md#v3_profiles_profile_id_verification_status_bank_transfer_post) | **POST** /v3/profiles/{profileId}/verification-status/bank-transfer | Check verification status
*QuotesApi* | [**v3_profiles_profile_id_quotes_post**](docs/QuotesApi.md#v3_profiles_profile_id_quotes_post) | **POST** /v3/profiles/{profileId}/quotes | Create an authenticated quote
*QuotesApi* | [**v3_profiles_profile_id_quotes_quote_id_get**](docs/QuotesApi.md#v3_profiles_profile_id_quotes_quote_id_get) | **GET** /v3/profiles/{profileId}/quotes/{quoteId} | Retrieve a quote by ID
*QuotesApi* | [**v3_profiles_profile_id_quotes_quote_id_patch**](docs/QuotesApi.md#v3_profiles_profile_id_quotes_quote_id_patch) | **PATCH** /v3/profiles/{profileId}/quotes/{quoteId} | Update a quote
*QuotesApi* | [**v3_quotes_post**](docs/QuotesApi.md#v3_quotes_post) | **POST** /v3/quotes | Create an unauthenticated quote
*RecipientsApi* | [**v1_accounts_post**](docs/RecipientsApi.md#v1_accounts_post) | **POST** /v1/accounts | Create a recipient account
*RecipientsApi* | [**v1_quotes_quote_id_account_requirements_get**](docs/RecipientsApi.md#v1_quotes_quote_id_account_requirements_get) | **GET** /v1/quotes/{quoteId}/account-requirements | Get account requirements for a quote
*RecipientsApi* | [**v1_refund_accounts_post**](docs/RecipientsApi.md#v1_refund_accounts_post) | **POST** /v1/refund-accounts | Create a refund recipient account
*RecipientsApi* | [**v2_accounts_account_id_delete**](docs/RecipientsApi.md#v2_accounts_account_id_delete) | **DELETE** /v2/accounts/{accountId} | Deactivate a recipient account
*RecipientsApi* | [**v2_accounts_account_id_get**](docs/RecipientsApi.md#v2_accounts_account_id_get) | **GET** /v2/accounts/{accountId} | Get recipient account by ID
*RecipientsApi* | [**v2_accounts_get**](docs/RecipientsApi.md#v2_accounts_get) | **GET** /v2/accounts | List recipient accounts
*TransfersApi* | [**v1_profiles_profile_id_partner_licence_transfers_post**](docs/TransfersApi.md#v1_profiles_profile_id_partner_licence_transfers_post) | **POST** /v1/profiles/{profileId}/partner-licence-transfers | Create partner license transfer
*TransfersApi* | [**v1_transfer_requirements_post**](docs/TransfersApi.md#v1_transfer_requirements_post) | **POST** /v1/transfer-requirements | Get transfer requirements
*TransfersApi* | [**v1_transfers_get**](docs/TransfersApi.md#v1_transfers_get) | **GET** /v1/transfers | List transfers
*TransfersApi* | [**v1_transfers_post**](docs/TransfersApi.md#v1_transfers_post) | **POST** /v1/transfers | Create a standard transfer
*TransfersApi* | [**v1_transfers_transfer_id_documents_noc_get**](docs/TransfersApi.md#v1_transfers_transfer_id_documents_noc_get) | **GET** /v1/transfers/{transferId}/documents/noc | Get NOC document
*TransfersApi* | [**v1_transfers_transfer_id_get**](docs/TransfersApi.md#v1_transfers_transfer_id_get) | **GET** /v1/transfers/{transferId} | Get transfer by ID
*TransfersApi* | [**v1_transfers_transfer_id_invoices_bankingpartner_get**](docs/TransfersApi.md#v1_transfers_transfer_id_invoices_bankingpartner_get) | **GET** /v1/transfers/{transferId}/invoices/bankingpartner | Get banking partner invoice (v1)
*TransfersApi* | [**v1_transfers_transfer_id_payments_get**](docs/TransfersApi.md#v1_transfers_transfer_id_payments_get) | **GET** /v1/transfers/{transferId}/payments | List transfer payments
*TransfersApi* | [**v1_transfers_transfer_id_put**](docs/TransfersApi.md#v1_transfers_transfer_id_put) | **PUT** /v1/transfers/{transferId} | Cancel transfer
*TransfersApi* | [**v1_transfers_transfer_id_receipt_pdf_get**](docs/TransfersApi.md#v1_transfers_transfer_id_receipt_pdf_get) | **GET** /v1/transfers/{transferId}/receipt.pdf | Get transfer receipt PDF
*TransfersApi* | [**v2_profiles_profile_id_third_party_transfers_post**](docs/TransfersApi.md#v2_profiles_profile_id_third_party_transfers_post) | **POST** /v2/profiles/{profileId}/third-party-transfers | Create third-party transfer
*TransfersApi* | [**v2_profiles_profile_id_third_party_transfers_transfer_id_get**](docs/TransfersApi.md#v2_profiles_profile_id_third_party_transfers_transfer_id_get) | **GET** /v2/profiles/{profileId}/third-party-transfers/{transferId} | Get third-party transfer
*TransfersApi* | [**v2_transfers_transfer_id_invoices_bankingpartner_get**](docs/TransfersApi.md#v2_transfers_transfer_id_invoices_bankingpartner_get) | **GET** /v2/transfers/{transferId}/invoices/bankingpartner | Get banking partner invoice (v2)
*TransfersApi* | [**v3_profiles_profile_id_transfers_transfer_id_payments_post**](docs/TransfersApi.md#v3_profiles_profile_id_transfers_transfer_id_payments_post) | **POST** /v3/profiles/{profileId}/transfers/{transferId}/payments | Fund a transfer


## Documentation For Models

 - [AccountRequirementsInner](docs/AccountRequirementsInner.md)
 - [AccountRequirementsInnerFieldsInner](docs/AccountRequirementsInnerFieldsInner.md)
 - [AccountRequirementsInnerFieldsInnerGroupInner](docs/AccountRequirementsInnerFieldsInnerGroupInner.md)
 - [AccountRequirementsInnerFieldsInnerGroupInnerValuesAllowedInner](docs/AccountRequirementsInnerFieldsInnerGroupInnerValuesAllowedInner.md)
 - [ActivitiesResponse](docs/ActivitiesResponse.md)
 - [Activity](docs/Activity.md)
 - [ActivityResource](docs/ActivityResource.md)
 - [ActivityResourceType](docs/ActivityResourceType.md)
 - [ActivityStatus](docs/ActivityStatus.md)
 - [ActivityType](docs/ActivityType.md)
 - [Amount](docs/Amount.md)
 - [BankingPartnerInvoice](docs/BankingPartnerInvoice.md)
 - [BusinessProfile](docs/BusinessProfile.md)
 - [BusinessProfileDetails](docs/BusinessProfileDetails.md)
 - [CreateAuthenticatedQuoteRequest](docs/CreateAuthenticatedQuoteRequest.md)
 - [CreateAuthenticatedQuoteRequestPaymentMetadata](docs/CreateAuthenticatedQuoteRequestPaymentMetadata.md)
 - [CreateBusinessProfileRequest](docs/CreateBusinessProfileRequest.md)
 - [CreatePartnerLicenceTransferRequest](docs/CreatePartnerLicenceTransferRequest.md)
 - [CreatePersonalProfileRequest](docs/CreatePersonalProfileRequest.md)
 - [CreatePersonalProfileRequestAddress](docs/CreatePersonalProfileRequestAddress.md)
 - [CreatePersonalProfileRequestContactDetails](docs/CreatePersonalProfileRequestContactDetails.md)
 - [CreateRecipientRequest](docs/CreateRecipientRequest.md)
 - [CreateRecipientRequestDetails](docs/CreateRecipientRequestDetails.md)
 - [CreateStandardTransferRequest](docs/CreateStandardTransferRequest.md)
 - [CreateThirdPartyTransferRequest](docs/CreateThirdPartyTransferRequest.md)
 - [CreateUnauthenticatedQuoteRequest](docs/CreateUnauthenticatedQuoteRequest.md)
 - [Director](docs/Director.md)
 - [Error](docs/Error.md)
 - [FeeConfiguration](docs/FeeConfiguration.md)
 - [FeeDetails](docs/FeeDetails.md)
 - [Notice](docs/Notice.md)
 - [Originator](docs/Originator.md)
 - [OriginatorAddress](docs/OriginatorAddress.md)
 - [OriginatorName](docs/OriginatorName.md)
 - [OriginatorTransfer](docs/OriginatorTransfer.md)
 - [PaginatedRecipients](docs/PaginatedRecipients.md)
 - [PaymentOption](docs/PaymentOption.md)
 - [PaymentRequest](docs/PaymentRequest.md)
 - [PaymentResponse](docs/PaymentResponse.md)
 - [PaymentsListInner](docs/PaymentsListInner.md)
 - [PersonalProfile](docs/PersonalProfile.md)
 - [PersonalProfileDetails](docs/PersonalProfileDetails.md)
 - [PersonalProfileDetailsOccupationsInner](docs/PersonalProfileDetailsOccupationsInner.md)
 - [PriceDetails](docs/PriceDetails.md)
 - [PricingConfiguration](docs/PricingConfiguration.md)
 - [Quote](docs/Quote.md)
 - [Recipient](docs/Recipient.md)
 - [RecipientCommonFieldMap](docs/RecipientCommonFieldMap.md)
 - [RecipientDetails](docs/RecipientDetails.md)
 - [RecipientDisplayFieldsInner](docs/RecipientDisplayFieldsInner.md)
 - [RecipientName](docs/RecipientName.md)
 - [RequirementField](docs/RequirementField.md)
 - [StandardTransfer](docs/StandardTransfer.md)
 - [TotalPrice](docs/TotalPrice.md)
 - [TransferDetails](docs/TransferDetails.md)
 - [TransferRequirementsRequest](docs/TransferRequirementsRequest.md)
 - [TransferRequirementsResponseInner](docs/TransferRequirementsResponseInner.md)
 - [TransferRequirementsResponseInnerFieldsInner](docs/TransferRequirementsResponseInnerFieldsInner.md)
 - [UBO](docs/UBO.md)
 - [UpdateQuoteRequest](docs/UpdateQuoteRequest.md)
 - [UpdateQuoteRequestPaymentMetadata](docs/UpdateQuoteRequestPaymentMetadata.md)
 - [V1ProfilesProfileIdVerificationDocumentsPostRequest](docs/V1ProfilesProfileIdVerificationDocumentsPostRequest.md)
 - [V1RefundAccountsPostRequest](docs/V1RefundAccountsPostRequest.md)
 - [V1RefundAccountsPostRequestName](docs/V1RefundAccountsPostRequestName.md)
 - [V1TransfersGet200ResponseInner](docs/V1TransfersGet200ResponseInner.md)
 - [V2ProfilesGet200ResponseInner](docs/V2ProfilesGet200ResponseInner.md)
 - [V2ProfilesProfileIdBusinessProfilePutRequest](docs/V2ProfilesProfileIdBusinessProfilePutRequest.md)
 - [V2ProfilesProfileIdGet200Response](docs/V2ProfilesProfileIdGet200Response.md)
 - [V2ProfilesProfileIdPersonalProfilePutRequest](docs/V2ProfilesProfileIdPersonalProfilePutRequest.md)
 - [VerificationStatusResponse](docs/VerificationStatusResponse.md)
 - [VerificationStatusResponseRoutesInner](docs/VerificationStatusResponseRoutesInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author

maksim.ploter@gmail.com


