#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['delft3dfmpy']

package_data = \
{'': ['*'],
 'delft3dfmpy': ['converters/*',
                 'core/*',
                 'datamodels/*',
                 'io/*',
                 'io\\resources/*',
                 'io\\resources\\RRmodel/*',
                 'lib/*']}

install_requires = \
['geopandas',
 'rasterio',
 'imod',
 'numpy',
 'scipy',
 'pandas',
 'matplotlib',
 'pillow',
 'rasterstats',
 'tqdm',
 'netcdf4',
 'descartes',
 'contextily',
 'hkvsobekpy']

extras_require = \
{'dev': ['pytest',
         'pytest-cov',
         'black',
         'twine',
         'bumpversion',
         'watchdog',
         'coverage',
         'Sphinx']}

setup(name='delft3dfmpy',
      version='1.1.0',
      description='Top-level package for delft3dfmpy.',
      author='Deltares - HKV',
      author_email=None,
      url='https://github.com/openearth/delft3dfmpy',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
