from __future__ import absolute_import

import unittest

from authress.api import token_verifier

customDomain = 'authress.token-validation.test'

class TokenVerifierTest(unittest.IsolatedAsyncioTestCase):
  def setUp(self):
    pass

  def tearDown(self):
    pass

  def test_get_token_for_eddsa(self):
    """Test case for verify_token for EdDSA

    Verify that a valid token is generated by the service client token provider and can be verified by the token verifier
    """

    access_key = 'CLIENT.KEY.ACCOUNT.MC4CAQAwBQYDK2VwBCIEIDVjjrIVCH3dVRq4ixRzBwjVHSoB2QzZ2iJuHq1Wshwp'
    publicKey = { 'alg': 'EdDSA', 'kty': 'OKP', 'crv': 'Ed25519', 'x': 'JxtSC5tZZJuaW7Aeu5Kh_3tgCpPZRkHaaFyTj5sQ3KU' }

    identity = token_verifier.TokenVerifier().verify_token(authressCustomDomain=f"https://{customDomain}", token=access_key, options={ 'expectedPublicKey': publicKey })
    assert identity['iss'] == f'https://{customDomain}/v1/clients/CLIENT'