# coding: utf-8

"""
    Authress

    <p> <h2>Introduction</h2> <p>Welcome to the Authress Authorization API. <br>The Authress REST API provides the operations and resources necessary to create records, assign permissions, and verify any user in your platform.</p> <p><ul>   <li>Manage multitenant platforms and create user tenants for SSO connections.</li>   <li>Create records to assign roles and resources to grant access for users.</li>   <li>Check user access control by calling the authorization API at the right time.</li>   <li>Configure service clients to securely access services in your platform.</li> </ul></p> <p>For more in-depth scenarios check out the <a href=\"https://authress.io/knowledge-base\" target=\"_blank\">Authress knowledge base</a>.</p> </p>  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@authress.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictBool, constr, validator

class PermissionObject(BaseModel):
    """
    The collective action and associate grants on a permission
    """
    action: constr(strict=True, max_length=64, min_length=1) = Field(..., description="The action the permission grants, can be scoped using `:` and parent actions imply sub-resource permissions, action:* or action implies action:sub-action. This property is case-insensitive, it will always be cast to lowercase before comparing actions to user permissions.")
    allow: StrictBool = Field(..., description="Does this permission grant the user the ability to execute the action?")
    grant: StrictBool = Field(..., description="Allows the user to give the permission to others without being able to execute the action.")
    delegate: StrictBool = Field(..., description="Allows delegating or granting the permission to others without being able to execute the action.")
    __properties = ["action", "allow", "grant", "delegate"]

    @validator('action')
    def action_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([*]|[a-zA-Z0-9-_]+)(:([*]|[a-zA-Z0-9-_]+))*$", value):
            raise ValueError(r"must validate the regular expression /^([*]|[a-zA-Z0-9-_]+)(:([*]|[a-zA-Z0-9-_]+))*$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PermissionObject:
        """Create an instance of PermissionObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PermissionObject:
        """Create an instance of PermissionObject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PermissionObject.parse_obj(obj)

        _obj = PermissionObject.parse_obj({
            "action": obj.get("action"),
            "allow": obj.get("allow"),
            "grant": obj.get("grant"),
            "delegate": obj.get("delegate")
        })
        return _obj


