# coding: utf-8

"""
    Authress

    <p> <h2>Introduction</h2> <p>Welcome to the Authress Authorization API. <br>The Authress REST API provides the operations and resources necessary to create records, assign permissions, and verify any user in your platform.</p> <p><ul>   <li>Manage multitenant platforms and create user tenants for SSO connections.</li>   <li>Create records to assign roles and resources to grant access for users.</li>   <li>Check user access control by calling the authorization API at the right time.</li>   <li>Configure service clients to securely access services in your platform.</li> </ul></p> <p>For more in-depth scenarios check out the <a href=\"https://authress.io/knowledge-base\" target=\"_blank\">Authress knowledge base</a>.</p> </p>  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@authress.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr
from authress.models.account_links import AccountLinks
from authress.models.statement import Statement

class Invite(BaseModel):
    """
    The user invite used to invite users to your application or to Authress as an admin.
    """
    invite_id: StrictStr = Field(..., alias="inviteId", description="The unique identifier for the invite. Use this ID to accept the invite. This parameter is ignored during invite creation.")
    tenant_id: Optional[constr(strict=True, max_length=64, min_length=0)] = Field(None, alias="tenantId")
    statements: conlist(Statement) = Field(..., description="A list of statements which match roles to resources. The invited user will all statements apply to them when the invite is accepted.")
    links: AccountLinks = Field(...)
    __properties = ["inviteId", "tenantId", "statements", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Invite:
        """Create an instance of Invite from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "invite_id",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of tenant_id
        if self.tenant_id:
            _dict['tenantId'] = self.tenant_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in statements (list)
        _items = []
        if self.statements:
            for _item in self.statements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['statements'] = _items
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['links'] = self.links.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Invite:
        """Create an instance of Invite from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Invite.parse_obj(obj)

        _obj = Invite.parse_obj({
            "invite_id": obj.get("inviteId"),
            "tenant_id": obj.get("tenantId"),
            "statements": [Statement.from_dict(_item) for _item in obj.get("statements")] if obj.get("statements") is not None else None,
            "links": AccountLinks.from_dict(obj.get("links")) if obj.get("links") is not None else None
        })
        return _obj


