# coding: utf-8

"""
    Authress

    <p> <h2>Introduction</h2> <p>Welcome to the Authress Authorization API. <br>The Authress REST API provides the operations and resources necessary to create records, assign permissions, and verify any user in your platform.</p> <p><ul>   <li>Manage multitenant platforms and create user tenants for SSO connections.</li>   <li>Create records to assign roles and resources to grant access for users.</li>   <li>Check user access control by calling the authorization API at the right time.</li>   <li>Configure service clients to securely access services in your platform.</li> </ul></p> <p>For more in-depth scenarios check out the <a href=\"https://authress.io/knowledge-base\" target=\"_blank\">Authress knowledge base</a>.</p> </p>  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@authress.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional
from pydantic import BaseModel, Field, conlist, constr, validator
from authress.models.account_links import AccountLinks
from authress.models.user import User

class Group(BaseModel):
    """
    A group of users, which can be added to access records.
    """
    group_id: Optional[constr(strict=True, max_length=64, min_length=1)] = Field(None, alias="groupId", description="Unique identifier for the groupId, can be specified on record creation. Must begin with grp_.")
    name: constr(strict=True, max_length=128, min_length=1) = Field(..., description="A helpful name for this record")
    last_updated: Optional[datetime] = Field(None, alias="lastUpdated", description="The expected last time the group was updated")
    users: conlist(User) = Field(..., description="The list of users in this group")
    admins: conlist(User) = Field(..., description="The list of admins that can edit this record even if they do not have global record edit permissions.")
    links: AccountLinks = Field(...)
    tags: Optional[Dict[str, constr(strict=True, max_length=128)]] = Field(None, description="The tags associated with this resource, this property is an map. { key1: value1, key2: value2 }")
    __properties = ["groupId", "name", "lastUpdated", "users", "admins", "links", "tags"]

    @validator('group_id')
    def group_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^grp_[a-zA-Z0-9-_]+$", value):
            raise ValueError(r"must validate the regular expression /^grp_[a-zA-Z0-9-_]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Group:
        """Create an instance of Group from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "last_updated",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item in self.users:
                if _item:
                    _items.append(_item.to_dict())
            _dict['users'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in admins (list)
        _items = []
        if self.admins:
            for _item in self.admins:
                if _item:
                    _items.append(_item.to_dict())
            _dict['admins'] = _items
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['links'] = self.links.to_dict()
        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Group:
        """Create an instance of Group from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Group.parse_obj(obj)

        _obj = Group.parse_obj({
            "group_id": obj.get("groupId"),
            "name": obj.get("name"),
            "last_updated": obj.get("lastUpdated"),
            "users": [User.from_dict(_item) for _item in obj.get("users")] if obj.get("users") is not None else None,
            "admins": [User.from_dict(_item) for _item in obj.get("admins")] if obj.get("admins") is not None else None,
            "links": AccountLinks.from_dict(obj.get("links")) if obj.get("links") is not None else None,
            "tags": obj.get("tags")
        })
        return _obj


