# coding: utf-8

"""
    Authress

    <p> <h2>Introduction</h2> <p>Welcome to the Authress Authorization API. <br>The Authress REST API provides the operations and resources necessary to create records, assign permissions, and verify any user in your platform.</p> <p><ul>   <li>Manage multitenant platforms and create user tenants for SSO connections.</li>   <li>Create records to assign roles and resources to grant access for users.</li>   <li>Check user access control by calling the authorization API at the right time.</li>   <li>Configure service clients to securely access services in your platform.</li> </ul></p> <p>For more in-depth scenarios check out the <a href=\"https://authress.io/knowledge-base\" target=\"_blank\">Authress knowledge base</a>.</p> </p>  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@authress.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, Optional
from pydantic import BaseModel, Field, constr
from authress.models.extension_application import ExtensionApplication
from authress.models.extension_client import ExtensionClient

class Extension(BaseModel):
    """
    Extension
    """
    extension_id: constr(strict=True, max_length=64, min_length=1) = Field(..., alias="extensionId")
    name: Optional[constr(strict=True, max_length=128, min_length=1)] = Field(None, description="The name of the extension. This name is visible in the Authress management portal")
    created_time: datetime = Field(..., alias="createdTime")
    application: Optional[ExtensionApplication] = None
    client: ExtensionClient = Field(...)
    tags: Optional[Dict[str, constr(strict=True, max_length=128)]] = Field(None, description="The tags associated with this resource, this property is an map. { key1: value1, key2: value2 }")
    __properties = ["extensionId", "name", "createdTime", "application", "client", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Extension:
        """Create an instance of Extension from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "extension_id",
                            "created_time",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of application
        if self.application:
            _dict['application'] = self.application.to_dict()
        # override the default output from pydantic by calling `to_dict()` of client
        if self.client:
            _dict['client'] = self.client.to_dict()
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Extension:
        """Create an instance of Extension from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Extension.parse_obj(obj)

        _obj = Extension.parse_obj({
            "extension_id": obj.get("extensionId"),
            "name": obj.get("name"),
            "created_time": obj.get("createdTime"),
            "application": ExtensionApplication.from_dict(obj.get("application")) if obj.get("application") is not None else None,
            "client": ExtensionClient.from_dict(obj.get("client")) if obj.get("client") is not None else None,
            "tags": obj.get("tags")
        })
        return _obj


