# coding: utf-8

"""
    Authress

    <p> <h2>Introduction</h2> <p>Welcome to the Authress Authorization API. <br>The Authress REST API provides the operations and resources necessary to create records, assign permissions, and verify any user in your platform.</p> <p><ul>   <li>Manage multitenant platforms and create user tenants for SSO connections.</li>   <li>Create records to assign roles and resources to grant access for users.</li>   <li>Check user access control by calling the authorization API at the right time.</li>   <li>Configure service clients to securely access services in your platform.</li> </ul></p> <p>For more in-depth scenarios check out the <a href=\"https://authress.io/knowledge-base\" target=\"_blank\">Authress knowledge base</a>.</p> </p>  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@authress.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator

class ConnectionData(BaseModel):
    """
    ConnectionData
    """
    tenant_id: Optional[constr(strict=True, max_length=64, min_length=0)] = Field(None, alias="tenantId")
    name: Optional[constr(strict=True, max_length=64, min_length=1)] = None
    supported_content_type: Optional[StrictStr] = Field('application/json', alias="supportedContentType")
    __properties = ["tenantId", "name", "supportedContentType"]

    @validator('supported_content_type')
    def supported_content_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('application/json', 'application/x-www-form-urlencoded'):
            raise ValueError("must be one of enum values ('application/json', 'application/x-www-form-urlencoded')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ConnectionData:
        """Create an instance of ConnectionData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of tenant_id
        if self.tenant_id:
            _dict['tenantId'] = self.tenant_id.to_dict()
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ConnectionData:
        """Create an instance of ConnectionData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ConnectionData.parse_obj(obj)

        _obj = ConnectionData.parse_obj({
            "tenant_id": obj.get("tenantId"),
            "name": obj.get("name"),
            "supported_content_type": obj.get("supportedContentType") if obj.get("supportedContentType") is not None else 'application/json'
        })
        return _obj


