# coding: utf-8

"""
    Authress

    <p> <h2>Introduction</h2> <p>Welcome to the Authress Authorization API. <br>The Authress REST API provides the operations and resources necessary to create records, assign permissions, and verify any user in your platform.</p> <p><ul>   <li>Manage multitenant platforms and create user tenants for SSO connections.</li>   <li>Create records to assign roles and resources to grant access for users.</li>   <li>Check user access control by calling the authorization API at the right time.</li>   <li>Configure service clients to securely access services in your platform.</li> </ul></p> <p>For more in-depth scenarios check out the <a href=\"https://authress.io/knowledge-base\" target=\"_blank\">Authress knowledge base</a>.</p> </p>  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@authress.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool

class ClientOptions(BaseModel):
    """
    A set of client specific options
    """
    grant_user_permissions_access: Optional[StrictBool] = Field(False, alias="grantUserPermissionsAccess", description="Grant the client access to verify authorization on behalf of any user.")
    grant_token_generation: Optional[StrictBool] = Field(False, alias="grantTokenGeneration", description="Grant the client access to generate oauth tokens on behalf of the Authress account. **Security Warning**: This means that this client can impersonate any user, and should only be used when connecting an existing custom Authorization Server to Authress, when that server does not support a standard OAuth connection.")
    __properties = ["grantUserPermissionsAccess", "grantTokenGeneration"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ClientOptions:
        """Create an instance of ClientOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if grant_user_permissions_access (nullable) is None
        # and __fields_set__ contains the field
        if self.grant_user_permissions_access is None and "grant_user_permissions_access" in self.__fields_set__:
            _dict['grantUserPermissionsAccess'] = None

        # set to None if grant_token_generation (nullable) is None
        # and __fields_set__ contains the field
        if self.grant_token_generation is None and "grant_token_generation" in self.__fields_set__:
            _dict['grantTokenGeneration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ClientOptions:
        """Create an instance of ClientOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ClientOptions.parse_obj(obj)

        _obj = ClientOptions.parse_obj({
            "grant_user_permissions_access": obj.get("grantUserPermissionsAccess") if obj.get("grantUserPermissionsAccess") is not None else False,
            "grant_token_generation": obj.get("grantTokenGeneration") if obj.get("grantTokenGeneration") is not None else False
        })
        return _obj


