# coding: utf-8

"""
    Authress

    <p> <h2>Introduction</h2> <p>Welcome to the Authress Authorization API. <br>The Authress REST API provides the operations and resources necessary to create records, assign permissions, and verify any user in your platform.</p> <p><ul>   <li>Manage multitenant platforms and create user tenants for SSO connections.</li>   <li>Create records to assign roles and resources to grant access for users.</li>   <li>Check user access control by calling the authorization API at the right time.</li>   <li>Configure service clients to securely access services in your platform.</li> </ul></p> <p>For more in-depth scenarios check out the <a href=\"https://authress.io/knowledge-base\" target=\"_blank\">Authress knowledge base</a>.</p> </p>  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@authress.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class ClientAccessKey(BaseModel):
    """
    A client access key configuration. The configuration contains information about the key. On first creation the configuration also contains the raw `clientSecret` and `accessKey` for use with OAuth and the Authress SDKs.
    """
    key_id: Optional[StrictStr] = Field(None, alias="keyId", description="The unique ID of the client.")
    client_id: StrictStr = Field(..., alias="clientId", description="The unique ID of the client.")
    generation_date: Optional[datetime] = Field(None, alias="generationDate")
    client_secret: Optional[StrictStr] = Field(None, alias="clientSecret", description="The unencoded OAuth client secret used with the OAuth endpoints to request a JWT using the `client_credentials` grant type. Pass the clientId and the clientSecret to the documented /tokens endpoint.")
    access_key: Optional[StrictStr] = Field(None, alias="accessKey", description="An encoded access key which contains identifying information for client access token creation. For direct use with the Authress SDKs. This private access key must be saved on first creation as it is discarded afterwards. Authress only saves the corresponding public key to verify the private access key.")
    __properties = ["keyId", "clientId", "generationDate", "clientSecret", "accessKey"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ClientAccessKey:
        """Create an instance of ClientAccessKey from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "key_id",
                            "client_id",
                            "generation_date",
                            "client_secret",
                            "access_key",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ClientAccessKey:
        """Create an instance of ClientAccessKey from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ClientAccessKey.parse_obj(obj)

        _obj = ClientAccessKey.parse_obj({
            "key_id": obj.get("keyId"),
            "client_id": obj.get("clientId"),
            "generation_date": obj.get("generationDate"),
            "client_secret": obj.get("clientSecret"),
            "access_key": obj.get("accessKey")
        })
        return _obj


