# coding: utf-8

"""
    Authress

    <p> <h2>Introduction</h2> <p>Welcome to the Authress Authorization API. <br>The Authress REST API provides the operations and resources necessary to create records, assign permissions, and verify any user in your platform.</p> <p><ul>   <li>Manage multitenant platforms and create user tenants for SSO connections.</li>   <li>Create records to assign roles and resources to grant access for users.</li>   <li>Check user access control by calling the authorization API at the right time.</li>   <li>Configure service clients to securely access services in your platform.</li> </ul></p> <p>For more in-depth scenarios check out the <a href=\"https://authress.io/knowledge-base\" target=\"_blank\">Authress knowledge base</a>.</p> </p>  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@authress.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr
from authress.models.client_access_key import ClientAccessKey
from authress.models.client_options import ClientOptions

class Client(BaseModel):
    """
    A client configuration.
    """
    client_id: StrictStr = Field(..., alias="clientId", description="The unique ID of the client.")
    created_time: datetime = Field(..., alias="createdTime")
    name: Optional[constr(strict=True, max_length=128, min_length=1)] = Field(None, description="The name of the client")
    options: Optional[ClientOptions] = None
    verification_keys: Optional[conlist(ClientAccessKey)] = Field(None, alias="verificationKeys", description="A list of the service client access keys.")
    tags: Optional[Dict[str, constr(strict=True, max_length=128)]] = Field(None, description="The tags associated with this resource, this property is an map. { key1: value1, key2: value2 }")
    __properties = ["clientId", "createdTime", "name", "options", "verificationKeys", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Client:
        """Create an instance of Client from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "client_id",
                            "created_time",
                            "verification_keys",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in verification_keys (list)
        _items = []
        if self.verification_keys:
            for _item in self.verification_keys:
                if _item:
                    _items.append(_item.to_dict())
            _dict['verificationKeys'] = _items
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Client:
        """Create an instance of Client from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Client.parse_obj(obj)

        _obj = Client.parse_obj({
            "client_id": obj.get("clientId"),
            "created_time": obj.get("createdTime"),
            "name": obj.get("name"),
            "options": ClientOptions.from_dict(obj.get("options")) if obj.get("options") is not None else None,
            "verification_keys": [ClientAccessKey.from_dict(_item) for _item in obj.get("verificationKeys")] if obj.get("verificationKeys") is not None else None,
            "tags": obj.get("tags")
        })
        return _obj


