# coding: utf-8

"""
    Authress

    <p> <h2>Introduction</h2> <p>Welcome to the Authress Authorization API. <br>The Authress REST API provides the operations and resources necessary to create records, assign permissions, and verify any user in your platform.</p> <p><ul>   <li>Manage multitenant platforms and create user tenants for SSO connections.</li>   <li>Create records to assign roles and resources to grant access for users.</li>   <li>Check user access control by calling the authorization API at the right time.</li>   <li>Configure service clients to securely access services in your platform.</li> </ul></p> <p>For more in-depth scenarios check out the <a href=\"https://authress.io/knowledge-base\" target=\"_blank\">Authress knowledge base</a>.</p> </p>  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@authress.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from authress.models.access_template import AccessTemplate
from authress.models.account_links import AccountLinks

class AccessRequest(BaseModel):
    """
    The access requested by a user.
    """
    request_id: constr(strict=True, max_length=100, min_length=1) = Field(..., alias="requestId", description="Unique identifier for the request.")
    last_updated: Optional[datetime] = Field(None, alias="lastUpdated", description="The expected last time the request was updated")
    status: Optional[StrictStr] = Field(None, description="Current status of the access request.")
    access: AccessTemplate = Field(...)
    links: AccountLinks = Field(...)
    tags: Optional[Dict[str, constr(strict=True, max_length=128)]] = Field(None, description="The tags associated with this resource, this property is an map. { key1: value1, key2: value2 }")
    __properties = ["requestId", "lastUpdated", "status", "access", "links", "tags"]

    @validator('request_id')
    def request_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9-_:|~]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9-_:|~]+$/")
        return value

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('OPEN', 'APPROVED', 'DENIED', 'DELETED'):
            raise ValueError("must be one of enum values ('OPEN', 'APPROVED', 'DENIED', 'DELETED')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccessRequest:
        """Create an instance of AccessRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "request_id",
                            "last_updated",
                            "status",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of access
        if self.access:
            _dict['access'] = self.access.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['links'] = self.links.to_dict()
        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccessRequest:
        """Create an instance of AccessRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccessRequest.parse_obj(obj)

        _obj = AccessRequest.parse_obj({
            "request_id": obj.get("requestId"),
            "last_updated": obj.get("lastUpdated"),
            "status": obj.get("status"),
            "access": AccessTemplate.from_dict(obj.get("access")) if obj.get("access") is not None else None,
            "links": AccountLinks.from_dict(obj.get("links")) if obj.get("links") is not None else None,
            "tags": obj.get("tags")
        })
        return _obj


