# coding: utf-8

"""
    Authress

    <p> <h2>Introduction</h2> <p>Welcome to the Authress Authorization API. <br>The Authress REST API provides the operations and resources necessary to create records, assign permissions, and verify any user in your platform.</p> <p><ul>   <li>Manage multitenant platforms and create user tenants for SSO connections.</li>   <li>Create records to assign roles and resources to grant access for users.</li>   <li>Check user access control by calling the authorization API at the right time.</li>   <li>Configure service clients to securely access services in your platform.</li> </ul></p> <p>For more in-depth scenarios check out the <a href=\"https://authress.io/knowledge-base\" target=\"_blank\">Authress knowledge base</a>.</p> </p>  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@authress.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr, conint, constr, validator

from typing import Optional

from authress.models.permission_collection import PermissionCollection
from authress.models.user_resources_collection import UserResourcesCollection
from authress.models.user_role_collection import UserRoleCollection

from authress.http_client import HttpClient
from authress.api_response import ApiResponse
from authress.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class UserPermissionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = HttpClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def authorize_user(self, user_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The user to check permissions on")], resource_uri : Annotated[constr(strict=True, max_length=512, min_length=1), Field(..., description="The uri path of a resource to validate, must be URL encoded, uri segments are allowed, the resource must be a full path.")], permission : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="Permission to check, '*' and scoped permissions can also be checked here.")], **kwargs) -> None:  # noqa: E501
        """Verify user authorization  # noqa: E501

        Performs the user authorization check. Does the user have the specified permission to the resource?  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.authorize_user(user_id, resource_uri, permission, async_req=True)
        >>> result = thread.get()

        :param user_id: The user to check permissions on (required)
        :type user_id: str
        :param resource_uri: The uri path of a resource to validate, must be URL encoded, uri segments are allowed, the resource must be a full path. (required)
        :type resource_uri: str
        :param permission: Permission to check, '*' and scoped permissions can also be checked here. (required)
        :type permission: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the authorize_user_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.authorize_user_with_http_info(user_id, resource_uri, permission, **kwargs)  # noqa: E501

    @validate_arguments
    def authorize_user_with_http_info(self, user_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The user to check permissions on")], resource_uri : Annotated[constr(strict=True, max_length=512, min_length=1), Field(..., description="The uri path of a resource to validate, must be URL encoded, uri segments are allowed, the resource must be a full path.")], permission : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="Permission to check, '*' and scoped permissions can also be checked here.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Verify user authorization  # noqa: E501

        Performs the user authorization check. Does the user have the specified permission to the resource?  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.authorize_user_with_http_info(user_id, resource_uri, permission, async_req=True)
        >>> result = thread.get()

        :param user_id: The user to check permissions on (required)
        :type user_id: str
        :param resource_uri: The uri path of a resource to validate, must be URL encoded, uri segments are allowed, the resource must be a full path. (required)
        :type resource_uri: str
        :param permission: Permission to check, '*' and scoped permissions can also be checked here. (required)
        :type permission: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'user_id',
            'resource_uri',
            'permission'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authorize_user" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_id']:
            _path_params['userId'] = _params['user_id']

        if _params['resource_uri']:
            _path_params['resourceUri'] = _params['resource_uri']

        if _params['permission']:
            _path_params['permission'] = _params['permission']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/users/{userId}/resources/{resourceUri}/permissions/{permission}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_user_permissions_for_resource(self, user_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The user to check permissions on")], resource_uri : Annotated[constr(strict=True, max_length=512, min_length=1), Field(..., description="The uri path of a resource to validate, must be URL encoded, uri segments are allowed.")], **kwargs) -> PermissionCollection:  # noqa: E501
        """Get user permissions for resource  # noqa: E501

        Get a summary of the permissions a user has to a particular resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_permissions_for_resource(user_id, resource_uri, async_req=True)
        >>> result = thread.get()

        :param user_id: The user to check permissions on (required)
        :type user_id: str
        :param resource_uri: The uri path of a resource to validate, must be URL encoded, uri segments are allowed. (required)
        :type resource_uri: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PermissionCollection
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_user_permissions_for_resource_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_user_permissions_for_resource_with_http_info(user_id, resource_uri, **kwargs)  # noqa: E501

    @validate_arguments
    def get_user_permissions_for_resource_with_http_info(self, user_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The user to check permissions on")], resource_uri : Annotated[constr(strict=True, max_length=512, min_length=1), Field(..., description="The uri path of a resource to validate, must be URL encoded, uri segments are allowed.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get user permissions for resource  # noqa: E501

        Get a summary of the permissions a user has to a particular resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_permissions_for_resource_with_http_info(user_id, resource_uri, async_req=True)
        >>> result = thread.get()

        :param user_id: The user to check permissions on (required)
        :type user_id: str
        :param resource_uri: The uri path of a resource to validate, must be URL encoded, uri segments are allowed. (required)
        :type resource_uri: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PermissionCollection, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_id',
            'resource_uri'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_permissions_for_resource" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_id']:
            _path_params['userId'] = _params['user_id']

        if _params['resource_uri']:
            _path_params['resourceUri'] = _params['resource_uri']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/links+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PermissionCollection",
            '401': None,
            '404': None,
        }

        return self.api_client.call_api(
            '/v1/users/{userId}/resources/{resourceUri}/permissions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_user_resources(self, user_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The user to check permissions on")], resource_uri : Annotated[Optional[constr(strict=True, max_length=512, min_length=1)], Field(description="The top level uri path of a resource to query for. Will only match explicit or nested sub-resources. Will not partial match resource names.")] = None, collection_configuration : Annotated[Optional[StrictStr], Field(description="`TOP_LEVEL_ONLY` - returns only directly nested resources under the resourceUri. A query to `resourceUri=Collection` will return `Collection/resource_1`.<br>`INCLUDE_NESTED` - will return all sub-resources as well as deeply nested resources that the user has the specified permission to. A query to `resourceUri=Collection` will return `Collection/namespaces/ns/resources/resource_1`.<br><br>To return matching resources for nested resources, set this parameter to `INCLUDE_NESTED`.")] = None, permissions : Annotated[Optional[constr(strict=True, max_length=64, min_length=1)], Field(description="Permission to check, '*' and scoped permissions can also be checked here. By default if the user has any permission explicitly to a resource, it will be included in the list.")] = None, limit : Annotated[Optional[conint(strict=True, le=20, ge=1)], Field(description="Max number of results to return")] = None, cursor : Annotated[Optional[StrictStr], Field(description="Continuation cursor for paging")] = None, **kwargs) -> UserResourcesCollection:  # noqa: E501
        """List user resources  # noqa: E501

        Get the users resources. This result is a list of resource uris that a user has an permission to. By default only the top level matching resources are returned. To get a user's list of deeply nested resources, set the `collectionConfiguration` to be `INCLUDE_NESTED`. This collection is paginated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_resources(user_id, resource_uri, collection_configuration, permissions, limit, cursor, async_req=True)
        >>> result = thread.get()

        :param user_id: The user to check permissions on (required)
        :type user_id: str
        :param resource_uri: The top level uri path of a resource to query for. Will only match explicit or nested sub-resources. Will not partial match resource names.
        :type resource_uri: str
        :param collection_configuration: `TOP_LEVEL_ONLY` - returns only directly nested resources under the resourceUri. A query to `resourceUri=Collection` will return `Collection/resource_1`.<br>`INCLUDE_NESTED` - will return all sub-resources as well as deeply nested resources that the user has the specified permission to. A query to `resourceUri=Collection` will return `Collection/namespaces/ns/resources/resource_1`.<br><br>To return matching resources for nested resources, set this parameter to `INCLUDE_NESTED`.
        :type collection_configuration: str
        :param permissions: Permission to check, '*' and scoped permissions can also be checked here. By default if the user has any permission explicitly to a resource, it will be included in the list.
        :type permissions: str
        :param limit: Max number of results to return
        :type limit: int
        :param cursor: Continuation cursor for paging
        :type cursor: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserResourcesCollection
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_user_resources_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_user_resources_with_http_info(user_id, resource_uri, collection_configuration, permissions, limit, cursor, **kwargs)  # noqa: E501

    @validate_arguments
    def get_user_resources_with_http_info(self, user_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The user to check permissions on")], resource_uri : Annotated[Optional[constr(strict=True, max_length=512, min_length=1)], Field(description="The top level uri path of a resource to query for. Will only match explicit or nested sub-resources. Will not partial match resource names.")] = None, collection_configuration : Annotated[Optional[StrictStr], Field(description="`TOP_LEVEL_ONLY` - returns only directly nested resources under the resourceUri. A query to `resourceUri=Collection` will return `Collection/resource_1`.<br>`INCLUDE_NESTED` - will return all sub-resources as well as deeply nested resources that the user has the specified permission to. A query to `resourceUri=Collection` will return `Collection/namespaces/ns/resources/resource_1`.<br><br>To return matching resources for nested resources, set this parameter to `INCLUDE_NESTED`.")] = None, permissions : Annotated[Optional[constr(strict=True, max_length=64, min_length=1)], Field(description="Permission to check, '*' and scoped permissions can also be checked here. By default if the user has any permission explicitly to a resource, it will be included in the list.")] = None, limit : Annotated[Optional[conint(strict=True, le=20, ge=1)], Field(description="Max number of results to return")] = None, cursor : Annotated[Optional[StrictStr], Field(description="Continuation cursor for paging")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List user resources  # noqa: E501

        Get the users resources. This result is a list of resource uris that a user has an permission to. By default only the top level matching resources are returned. To get a user's list of deeply nested resources, set the `collectionConfiguration` to be `INCLUDE_NESTED`. This collection is paginated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_resources_with_http_info(user_id, resource_uri, collection_configuration, permissions, limit, cursor, async_req=True)
        >>> result = thread.get()

        :param user_id: The user to check permissions on (required)
        :type user_id: str
        :param resource_uri: The top level uri path of a resource to query for. Will only match explicit or nested sub-resources. Will not partial match resource names.
        :type resource_uri: str
        :param collection_configuration: `TOP_LEVEL_ONLY` - returns only directly nested resources under the resourceUri. A query to `resourceUri=Collection` will return `Collection/resource_1`.<br>`INCLUDE_NESTED` - will return all sub-resources as well as deeply nested resources that the user has the specified permission to. A query to `resourceUri=Collection` will return `Collection/namespaces/ns/resources/resource_1`.<br><br>To return matching resources for nested resources, set this parameter to `INCLUDE_NESTED`.
        :type collection_configuration: str
        :param permissions: Permission to check, '*' and scoped permissions can also be checked here. By default if the user has any permission explicitly to a resource, it will be included in the list.
        :type permissions: str
        :param limit: Max number of results to return
        :type limit: int
        :param cursor: Continuation cursor for paging
        :type cursor: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserResourcesCollection, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_id',
            'resource_uri',
            'collection_configuration',
            'permissions',
            'limit',
            'cursor'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_resources" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_id']:
            _path_params['userId'] = _params['user_id']


        # process the query parameters
        _query_params = []
        if _params.get('resource_uri') is not None:  # noqa: E501
            _query_params.append(('resourceUri', _params['resource_uri']))

        if _params.get('collection_configuration') is not None:  # noqa: E501
            _query_params.append(('collectionConfiguration', _params['collection_configuration']))

        if _params.get('permissions') is not None:  # noqa: E501
            _query_params.append(('permissions', _params['permissions']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('cursor') is not None:  # noqa: E501
            _query_params.append(('cursor', _params['cursor']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/links+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UserResourcesCollection",
            '401': None,
        }

        return self.api_client.call_api(
            '/v1/users/{userId}/resources', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_user_roles_for_resource(self, user_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The user to get roles for.")], resource_uri : Annotated[constr(strict=True, max_length=512, min_length=1), Field(..., description="The uri path of a resource to get roles for, must be URL encoded. Checks for explicit resource roles, roles attached to parent resources are not returned.")], **kwargs) -> UserRoleCollection:  # noqa: E501
        """Get user roles for resource  # noqa: E501

        Get a summary of the roles a user has to a particular resource. Users can be assigned roles from multiple access records, this may cause the same role to appear in the list more than once.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_roles_for_resource(user_id, resource_uri, async_req=True)
        >>> result = thread.get()

        :param user_id: The user to get roles for. (required)
        :type user_id: str
        :param resource_uri: The uri path of a resource to get roles for, must be URL encoded. Checks for explicit resource roles, roles attached to parent resources are not returned. (required)
        :type resource_uri: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserRoleCollection
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_user_roles_for_resource_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_user_roles_for_resource_with_http_info(user_id, resource_uri, **kwargs)  # noqa: E501

    @validate_arguments
    def get_user_roles_for_resource_with_http_info(self, user_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The user to get roles for.")], resource_uri : Annotated[constr(strict=True, max_length=512, min_length=1), Field(..., description="The uri path of a resource to get roles for, must be URL encoded. Checks for explicit resource roles, roles attached to parent resources are not returned.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get user roles for resource  # noqa: E501

        Get a summary of the roles a user has to a particular resource. Users can be assigned roles from multiple access records, this may cause the same role to appear in the list more than once.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_roles_for_resource_with_http_info(user_id, resource_uri, async_req=True)
        >>> result = thread.get()

        :param user_id: The user to get roles for. (required)
        :type user_id: str
        :param resource_uri: The uri path of a resource to get roles for, must be URL encoded. Checks for explicit resource roles, roles attached to parent resources are not returned. (required)
        :type resource_uri: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserRoleCollection, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_id',
            'resource_uri'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_roles_for_resource" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_id']:
            _path_params['userId'] = _params['user_id']

        if _params['resource_uri']:
            _path_params['resourceUri'] = _params['resource_uri']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/links+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UserRoleCollection",
            '401': None,
            '404': None,
        }

        return self.api_client.call_api(
            '/v1/users/{userId}/resources/{resourceUri}/roles', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
