# coding: utf-8

"""
    Authress

    <p> <h2>Introduction</h2> <p>Welcome to the Authress Authorization API. <br>The Authress REST API provides the operations and resources necessary to create records, assign permissions, and verify any user in your platform.</p> <p><ul>   <li>Manage multitenant platforms and create user tenants for SSO connections.</li>   <li>Create records to assign roles and resources to grant access for users.</li>   <li>Check user access control by calling the authorization API at the right time.</li>   <li>Configure service clients to securely access services in your platform.</li> </ul></p> <p>For more in-depth scenarios check out the <a href=\"https://authress.io/knowledge-base\" target=\"_blank\">Authress knowledge base</a>.</p> </p>  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@authress.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr, constr

from typing import Optional

from authress.models.extension import Extension
from authress.models.extension_collection import ExtensionCollection
from authress.models.o_auth_authorize_response import OAuthAuthorizeResponse
from authress.models.o_auth_token_request import OAuthTokenRequest
from authress.models.o_auth_token_response import OAuthTokenResponse

from authress.http_client import HttpClient
from authress.api_response import ApiResponse
from authress.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ExtensionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = HttpClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_extension(self, extension : Extension, **kwargs) -> Extension:  # noqa: E501
        """Create extension  # noqa: E501

        Specify the extension details for a new developer extension. Creating the extension enables developers to build applications that can log in to your platform and interact with your users' data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_extension(extension, async_req=True)
        >>> result = thread.get()

        :param extension: (required)
        :type extension: Extension
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Extension
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_extension_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_extension_with_http_info(extension, **kwargs)  # noqa: E501

    @validate_arguments
    def create_extension_with_http_info(self, extension : Extension, **kwargs) -> ApiResponse:  # noqa: E501
        """Create extension  # noqa: E501

        Specify the extension details for a new developer extension. Creating the extension enables developers to build applications that can log in to your platform and interact with your users' data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_extension_with_http_info(extension, async_req=True)
        >>> result = thread.get()

        :param extension: (required)
        :type extension: Extension
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Extension, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'extension'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_extension" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['extension'] is not None:
            _body_params = _params['extension']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/links+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "Extension",
            '401': None,
            '403': None,
        }

        return self.api_client.call_api(
            '/v1/extensions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_extension(self, extension_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The extension identifier.")], **kwargs) -> None:  # noqa: E501
        """Delete extension  # noqa: E501

        Deletes the specified extension. When deleted an extension can no longer be accessed. Additionally users cannot use that extension to log in, nor can the service client associated with the extension be used to access data secured by Authress. The related Access Records will automatically be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_extension(extension_id, async_req=True)
        >>> result = thread.get()

        :param extension_id: The extension identifier. (required)
        :type extension_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_extension_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_extension_with_http_info(extension_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_extension_with_http_info(self, extension_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The extension identifier.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete extension  # noqa: E501

        Deletes the specified extension. When deleted an extension can no longer be accessed. Additionally users cannot use that extension to log in, nor can the service client associated with the extension be used to access data secured by Authress. The related Access Records will automatically be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_extension_with_http_info(extension_id, async_req=True)
        >>> result = thread.get()

        :param extension_id: The extension identifier. (required)
        :type extension_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'extension_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_extension" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['extension_id']:
            _path_params['extensionId'] = _params['extension_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/extensions/{extensionId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_extension(self, extension_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The extension identifier.")], **kwargs) -> Extension:  # noqa: E501
        """Retrieve extension  # noqa: E501

        Gets the platform extension details for the existing extension.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_extension(extension_id, async_req=True)
        >>> result = thread.get()

        :param extension_id: The extension identifier. (required)
        :type extension_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Extension
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_extension_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_extension_with_http_info(extension_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_extension_with_http_info(self, extension_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The extension identifier.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Retrieve extension  # noqa: E501

        Gets the platform extension details for the existing extension.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_extension_with_http_info(extension_id, async_req=True)
        >>> result = thread.get()

        :param extension_id: The extension identifier. (required)
        :type extension_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Extension, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'extension_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['extension_id']:
            _path_params['extensionId'] = _params['extension_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/links+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Extension",
            '401': None,
            '403': None,
            '404': None,
        }

        return self.api_client.call_api(
            '/v1/extensions/{extensionId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_extensions(self, **kwargs) -> ExtensionCollection:  # noqa: E501
        """List extensions  # noqa: E501

        Lists the platform extensions. Extensions are the applications that developers of your platform have created for your users to interact with. Returns a paginated extension list for the account. Only extensions the user has access to are returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_extensions(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ExtensionCollection
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_extensions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_extensions_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_extensions_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """List extensions  # noqa: E501

        Lists the platform extensions. Extensions are the applications that developers of your platform have created for your users to interact with. Returns a paginated extension list for the account. Only extensions the user has access to are returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_extensions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ExtensionCollection, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extensions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/links+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ExtensionCollection",
            '401': None,
            '403': None,
        }

        return self.api_client.call_api(
            '/v1/extensions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def login(self, client_id : Annotated[StrictStr, Field(..., description="The client identifier to constrain the token to.")], code_challenge : Annotated[StrictStr, Field(..., description="The PKCE Code challenge generated by the extension UI to secure the code exchange from [RFC 7636](https://datatracker.ietf.org/doc/html/rfc7636).")], redirect_uri : Annotated[StrictStr, Field(..., description="The location to redirect the user back to after login. This redirect_uri must be a URL that matches one of the preconfigured urls in the Authress Application.")], code_challenge_method : Annotated[Optional[StrictStr], Field(description="The method used to generate the code_challenge from the code_verifier. `code_challenge_method(code_verifier) = code_challenge`")] = None, **kwargs) -> OAuthAuthorizeResponse:  # noqa: E501
        """OAuth Authorize  # noqa: E501

        *Note*: This endpoint is only to be used for [Authress Platform Extensions](https://authress.io/knowledge-base/docs/extensions/). If you are not building an app marketplace, then tokens can be directly requested for Service Clients, using the relevant [SDK](https://authress.io/app/#/api).<br><br>Start the OAuth login by redirecting the user to the OAuth Authorize endpoint. This generates a JWT for the user using the configured application, client ID, and connection.<br><br>The OAuth 2.1 authorization request that follows [RFC 6749](https://www.rfc-editor.org/rfc/rfc6749). Enables users to request a JWT signed by Authress and Returns an OAuth JWT containing the relevant user claims. Tokens generated must be verified before usage by validating the `sub`, `iss`, and `aud` properties in the JWT. Please note, that the properties in the request and response use snake_case to explicitly follow the standard.<br><br>The ExtensionClient in the [@authress/login](https://github.com/Authress/authress-login.js#platform-extension-login) npm package provides all the necessary logic to make this easy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.login(client_id, code_challenge, redirect_uri, code_challenge_method, async_req=True)
        >>> result = thread.get()

        :param client_id: The client identifier to constrain the token to. (required)
        :type client_id: str
        :param code_challenge: The PKCE Code challenge generated by the extension UI to secure the code exchange from [RFC 7636](https://datatracker.ietf.org/doc/html/rfc7636). (required)
        :type code_challenge: str
        :param redirect_uri: The location to redirect the user back to after login. This redirect_uri must be a URL that matches one of the preconfigured urls in the Authress Application. (required)
        :type redirect_uri: str
        :param code_challenge_method: The method used to generate the code_challenge from the code_verifier. `code_challenge_method(code_verifier) = code_challenge`
        :type code_challenge_method: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OAuthAuthorizeResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the login_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.login_with_http_info(client_id, code_challenge, redirect_uri, code_challenge_method, **kwargs)  # noqa: E501

    @validate_arguments
    def login_with_http_info(self, client_id : Annotated[StrictStr, Field(..., description="The client identifier to constrain the token to.")], code_challenge : Annotated[StrictStr, Field(..., description="The PKCE Code challenge generated by the extension UI to secure the code exchange from [RFC 7636](https://datatracker.ietf.org/doc/html/rfc7636).")], redirect_uri : Annotated[StrictStr, Field(..., description="The location to redirect the user back to after login. This redirect_uri must be a URL that matches one of the preconfigured urls in the Authress Application.")], code_challenge_method : Annotated[Optional[StrictStr], Field(description="The method used to generate the code_challenge from the code_verifier. `code_challenge_method(code_verifier) = code_challenge`")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """OAuth Authorize  # noqa: E501

        *Note*: This endpoint is only to be used for [Authress Platform Extensions](https://authress.io/knowledge-base/docs/extensions/). If you are not building an app marketplace, then tokens can be directly requested for Service Clients, using the relevant [SDK](https://authress.io/app/#/api).<br><br>Start the OAuth login by redirecting the user to the OAuth Authorize endpoint. This generates a JWT for the user using the configured application, client ID, and connection.<br><br>The OAuth 2.1 authorization request that follows [RFC 6749](https://www.rfc-editor.org/rfc/rfc6749). Enables users to request a JWT signed by Authress and Returns an OAuth JWT containing the relevant user claims. Tokens generated must be verified before usage by validating the `sub`, `iss`, and `aud` properties in the JWT. Please note, that the properties in the request and response use snake_case to explicitly follow the standard.<br><br>The ExtensionClient in the [@authress/login](https://github.com/Authress/authress-login.js#platform-extension-login) npm package provides all the necessary logic to make this easy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.login_with_http_info(client_id, code_challenge, redirect_uri, code_challenge_method, async_req=True)
        >>> result = thread.get()

        :param client_id: The client identifier to constrain the token to. (required)
        :type client_id: str
        :param code_challenge: The PKCE Code challenge generated by the extension UI to secure the code exchange from [RFC 7636](https://datatracker.ietf.org/doc/html/rfc7636). (required)
        :type code_challenge: str
        :param redirect_uri: The location to redirect the user back to after login. This redirect_uri must be a URL that matches one of the preconfigured urls in the Authress Application. (required)
        :type redirect_uri: str
        :param code_challenge_method: The method used to generate the code_challenge from the code_verifier. `code_challenge_method(code_verifier) = code_challenge`
        :type code_challenge_method: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OAuthAuthorizeResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'client_id',
            'code_challenge',
            'redirect_uri',
            'code_challenge_method'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method login" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('client_id') is not None:  # noqa: E501
            _query_params.append(('client_id', _params['client_id']))

        if _params.get('code_challenge') is not None:  # noqa: E501
            _query_params.append(('code_challenge', _params['code_challenge']))

        if _params.get('code_challenge_method') is not None:  # noqa: E501
            _query_params.append(('code_challenge_method', _params['code_challenge_method']))

        if _params.get('redirect_uri') is not None:  # noqa: E501
            _query_params.append(('redirect_uri', _params['redirect_uri']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/links+json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "OAuthAuthorizeResponse",
            '400': None,
            '401': None,
        }

        return self.api_client.call_api(
            '/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def request_token(self, o_auth_token_request : Annotated[OAuthTokenRequest, Field(..., description="The contents of an OAuth token request.")], **kwargs) -> OAuthTokenResponse:  # noqa: E501
        """OAuth Token  # noqa: E501

        *Note*: This endpoint is only to be used for [Authress Platform Extensions](https://authress.io/knowledge-base/docs/extensions/). If you are not building an app marketplace, then tokens can be directly requested for Service Clients, using the relevant [SDK](https://authress.io/app/#/api).<br><br>Request an OAuth JWT. Can either be called with service client credentials or as the second part of the user authorize login flow.<br>When using the `password` grant_type, service client authentication must be used via the Authress SDKs, and requires the `Authress:AuthenticateUser` role.<br><br>The OAuth 2.1 token request that follows [RFC 6749](https://www.rfc-editor.org/rfc/rfc6749). Enables users to request a JWT signed by Authress, and returns an OAuth JWT containing the relevant user claims. Tokens generated must be verified before usage by validating the `sub`, `iss`, and `aud` properties in the JWT. Please note, that the properties in the request and response use snake_case to explicitly follow the standard.<br><br>The ExtensionClient in the [@authress/login](https://github.com/Authress/authress-login.js#platform-extension-login) npm package provides all the necessary logic to make this easy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.request_token(o_auth_token_request, async_req=True)
        >>> result = thread.get()

        :param o_auth_token_request: The contents of an OAuth token request. (required)
        :type o_auth_token_request: OAuthTokenRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OAuthTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the request_token_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.request_token_with_http_info(o_auth_token_request, **kwargs)  # noqa: E501

    @validate_arguments
    def request_token_with_http_info(self, o_auth_token_request : Annotated[OAuthTokenRequest, Field(..., description="The contents of an OAuth token request.")], **kwargs) -> ApiResponse:  # noqa: E501
        """OAuth Token  # noqa: E501

        *Note*: This endpoint is only to be used for [Authress Platform Extensions](https://authress.io/knowledge-base/docs/extensions/). If you are not building an app marketplace, then tokens can be directly requested for Service Clients, using the relevant [SDK](https://authress.io/app/#/api).<br><br>Request an OAuth JWT. Can either be called with service client credentials or as the second part of the user authorize login flow.<br>When using the `password` grant_type, service client authentication must be used via the Authress SDKs, and requires the `Authress:AuthenticateUser` role.<br><br>The OAuth 2.1 token request that follows [RFC 6749](https://www.rfc-editor.org/rfc/rfc6749). Enables users to request a JWT signed by Authress, and returns an OAuth JWT containing the relevant user claims. Tokens generated must be verified before usage by validating the `sub`, `iss`, and `aud` properties in the JWT. Please note, that the properties in the request and response use snake_case to explicitly follow the standard.<br><br>The ExtensionClient in the [@authress/login](https://github.com/Authress/authress-login.js#platform-extension-login) npm package provides all the necessary logic to make this easy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.request_token_with_http_info(o_auth_token_request, async_req=True)
        >>> result = thread.get()

        :param o_auth_token_request: The contents of an OAuth token request. (required)
        :type o_auth_token_request: OAuthTokenRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OAuthTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'o_auth_token_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_token" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['o_auth_token_request'] is not None:
            _body_params = _params['o_auth_token_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/links+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "OAuthTokenResponse",
            '400': None,
            '401': None,
        }

        return self.api_client.call_api(
            '/api/authentication/oauth/tokens', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_extension(self, extension_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The extension identifier.")], extension : Extension, **kwargs) -> Extension:  # noqa: E501
        """Update extension  # noqa: E501

        Specify the updated extension. The extension will be updated and these changes will be reflected to the access control and user authentication associated with the extension.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_extension(extension_id, extension, async_req=True)
        >>> result = thread.get()

        :param extension_id: The extension identifier. (required)
        :type extension_id: str
        :param extension: (required)
        :type extension: Extension
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Extension
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_extension_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_extension_with_http_info(extension_id, extension, **kwargs)  # noqa: E501

    @validate_arguments
    def update_extension_with_http_info(self, extension_id : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The extension identifier.")], extension : Extension, **kwargs) -> ApiResponse:  # noqa: E501
        """Update extension  # noqa: E501

        Specify the updated extension. The extension will be updated and these changes will be reflected to the access control and user authentication associated with the extension.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_extension_with_http_info(extension_id, extension, async_req=True)
        >>> result = thread.get()

        :param extension_id: The extension identifier. (required)
        :type extension_id: str
        :param extension: (required)
        :type extension: Extension
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Extension, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'extension_id',
            'extension'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_extension" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['extension_id']:
            _path_params['extensionId'] = _params['extension_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['extension'] is not None:
            _body_params = _params['extension']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/links+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Extension",
            '401': None,
            '403': None,
            '404': None,
        }

        return self.api_client.call_api(
            '/v1/extensions/{extensionId}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
