"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackAppManifest = exports.SlackAppManifestShortcutType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const nodeUrl = require("url");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Type of shortcuts
 *
 * @see https://api.slack.com/interactivity/shortcuts
 */
var SlackAppManifestShortcutType;
(function (SlackAppManifestShortcutType) {
    /**
     * Message shortcuts are shown to users in the context menus of messages within Slack
     *
     * @see https://api.slack.com/interactivity/shortcuts/using#message_shortcuts
     */
    SlackAppManifestShortcutType["MESSAGE"] = "message";
    /**
     * Global shortcuts are available to users via the shortcuts button in the composer,
     * and when using search in Slack
     *
     * @see https://api.slack.com/interactivity/shortcuts/using#global_shortcuts
     */
    SlackAppManifestShortcutType["GLOBAL"] = "global";
})(SlackAppManifestShortcutType = exports.SlackAppManifestShortcutType || (exports.SlackAppManifestShortcutType = {}));
;
/**
 * A Slack app manifest
 *
 * @see https://api.slack.com/reference/manifests
 */
class SlackAppManifest {
    constructor(props) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        this.props = props;
        validateLength('app name', 35, props.name);
        validateLength('app description', 140, props.description);
        validateLength('app long description', 4000, props.longDescription);
        validateColor(props.backgroundColor);
        validateUrl((_b = props.eventSubscriptions) === null || _b === void 0 ? void 0 : _b.requestUrl);
        validateItems('bot events', 100, (_c = props.eventSubscriptions) === null || _c === void 0 ? void 0 : _c.botEvents);
        validateItems('users events', 100, (_d = props.eventSubscriptions) === null || _d === void 0 ? void 0 : _d.userEvents);
        validateUrl((_e = props.interactivity) === null || _e === void 0 ? void 0 : _e.requestUrl);
        validateUrl((_f = props.interactivity) === null || _f === void 0 ? void 0 : _f.messageMenuOptionsUrl);
        validateLength('bot display name', 80, (_g = props.botUser) === null || _g === void 0 ? void 0 : _g.displayName);
        validateItems('shortcuts', 5, props.shortcuts);
        (_h = props.shortcuts) === null || _h === void 0 ? void 0 : _h.forEach((shortcut) => {
            validateLength('shortcut callback ID', 255, shortcut.callbackId);
            validateLength('shortcut description', 150, shortcut.description);
        });
        validateItems('slash commands', 5, props.slashCommands);
        (_j = props.slashCommands) === null || _j === void 0 ? void 0 : _j.forEach((command) => {
            validateLength('slash command', 32, command.command);
            validateLength('slash command description', 2000, command.description),
                validateUrl(command.url);
            validateLength('slash command use hint', 1000, command.usageHint);
        });
        validateItems('workflow steps', 10, props.workflowSteps);
        (_k = props.workflowSteps) === null || _k === void 0 ? void 0 : _k.forEach((step) => {
            validateLength('workflow step name', 50, step.name);
            validateLength('workflow step callback ID', 50, step.callbackId);
        });
        validateItems('unfurls domains', 5, props.unfurlDomains);
        validateItems('OAuth redirect URLs', 1000, (_l = props.oauthConfig) === null || _l === void 0 ? void 0 : _l.redirectUrls);
        (_o = (_m = props.oauthConfig) === null || _m === void 0 ? void 0 : _m.redirectUrls) === null || _o === void 0 ? void 0 : _o.forEach((url) => {
            validateUrl(url, false);
        });
        validateItems('bot scopes', 255, (_p = props.oauthConfig) === null || _p === void 0 ? void 0 : _p.botScopes);
        validateItems('user scopes', 255, (_q = props.oauthConfig) === null || _q === void 0 ? void 0 : _q.userScopes);
    }
    render(construct) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v;
        const schema = {
            _metadata: {
                major_version: this.props.majorVersion,
                minor_version: this.props.minorVersion,
            },
            display_information: {
                name: this.props.name,
                description: this.props.description,
                long_description: this.props.longDescription,
                background_color: (_b = prefixWith('#', this.props.backgroundColor)) === null || _b === void 0 ? void 0 : _b.toLowerCase(),
            },
            settings: {
                allowed_ip_address_ranges: this.props.allowedIpAddressRanges,
                event_subscriptions: {
                    request_url: (_c = this.props.eventSubscriptions) === null || _c === void 0 ? void 0 : _c.requestUrl,
                    bot_events: (_d = this.props.eventSubscriptions) === null || _d === void 0 ? void 0 : _d.botEvents,
                    user_events: (_e = this.props.eventSubscriptions) === null || _e === void 0 ? void 0 : _e.userEvents,
                },
                interactivity: this.props.interactivity
                    ? {
                        is_enabled: (_g = (_f = this.props.interactivity) === null || _f === void 0 ? void 0 : _f.enabled) !== null && _g !== void 0 ? _g : true,
                        request_url: (_h = this.props.interactivity) === null || _h === void 0 ? void 0 : _h.requestUrl,
                        message_menu_options_url: (_j = this.props.interactivity) === null || _j === void 0 ? void 0 : _j.messageMenuOptionsUrl,
                    }
                    : undefined,
                org_deploy_enabled: this.props.orgDeploy,
                socket_mode_enabled: this.props.socketMode,
            },
            features: {
                app_home: {
                    home_tab_enabled: (_k = this.props.appHome) === null || _k === void 0 ? void 0 : _k.homeTab,
                    messages_tab_enabled: (_l = this.props.appHome) === null || _l === void 0 ? void 0 : _l.messagesTab,
                    messages_tab_read_only_enabled: (_m = this.props.appHome) === null || _m === void 0 ? void 0 : _m.messagesTabReadOnly,
                },
                bot_user: this.props.botUser
                    ? {
                        display_name: (_o = this.props.botUser) === null || _o === void 0 ? void 0 : _o.displayName,
                        always_online: (_p = this.props.botUser) === null || _p === void 0 ? void 0 : _p.alwaysOnline,
                    }
                    : undefined,
                shortcuts: (_q = this.props.shortcuts) === null || _q === void 0 ? void 0 : _q.map((shortcut) => ({
                    name: shortcut.name,
                    type: shortcut.type,
                    callback_id: shortcut.callbackId,
                    description: shortcut.description,
                })),
                slash_commands: (_r = this.props.slashCommands) === null || _r === void 0 ? void 0 : _r.map((command) => ({
                    command: prefixWith('/', command.command),
                    description: command.description,
                    url: command.url,
                    usage_hint: command.usageHint,
                    should_escape: command.shouldEscape,
                })),
                workflow_steps: (_s = this.props.workflowSteps) === null || _s === void 0 ? void 0 : _s.map((step) => ({
                    name: step.name,
                    callback_id: step.callbackId,
                })),
                unfurl_domains: this.props.unfurlDomains,
            },
            oauth_config: {
                redirect_urls: (_t = this.props.oauthConfig) === null || _t === void 0 ? void 0 : _t.redirectUrls,
                scopes: {
                    bot: (_u = this.props.oauthConfig) === null || _u === void 0 ? void 0 : _u.botScopes,
                    users: (_v = this.props.oauthConfig) === null || _v === void 0 ? void 0 : _v.userScopes,
                },
            },
        };
        return aws_cdk_lib_1.Stack.of(construct).toJsonString(removeUndefined(schema));
    }
}
exports.SlackAppManifest = SlackAppManifest;
_a = JSII_RTTI_SYMBOL_1;
SlackAppManifest[_a] = { fqn: "cloudstructs.SlackAppManifest", version: "0.4.22" };
function prefixWith(prefix, string) {
    if (!string) {
        return undefined;
    }
    if (string.startsWith(prefix)) {
        return string;
    }
    return `${prefix}${string}`;
}
function validateLength(description, max, xs) {
    if (xs && !aws_cdk_lib_1.Token.isUnresolved(xs) && xs.length > max) {
        throw new Error(`Maximum length for ${description} is ${max}, got ${xs.length}: ${xs}`);
    }
}
function validateItems(description, max, xs) {
    if (xs && !aws_cdk_lib_1.Token.isUnresolved(xs) && xs.length > max) {
        throw new Error(`Maximum number of items for ${description} is ${max}, got ${xs.length}`);
    }
}
function validateColor(color) {
    if (color && !aws_cdk_lib_1.Token.isUnresolved(color) && !/^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/.test(color)) {
        throw new Error(`Invalid hex color: ${color}`);
    }
}
function validateUrl(url, https = true) {
    if (url && !aws_cdk_lib_1.Token.isUnresolved(url)) {
        try {
            const parsed = new nodeUrl.URL(url);
            if (https && parsed.protocol !== 'https:') {
                throw new Error('Invalid protocol');
            }
        }
        catch (err) {
            throw new Error(`${url} is not a valid${https ? ' HTTPS' : ''} url`);
        }
    }
}
function removeUndefined(obj) {
    if (typeof obj === 'string') {
        return obj;
    }
    if (Array.isArray(obj)) {
        const ret = obj
            .map(v => (v && typeof v === 'object') ? removeUndefined(v) : v)
            .filter(v => !(v == null));
        return ret.length !== 0 ? ret : undefined;
    }
    const ret = Object.entries(obj)
        .map(([k, v]) => [k, v && typeof v === 'object' ? removeUndefined(v) : v])
        .reduce((a, [k, v]) => (v == null ? a : (a[k] = v, a)), {});
    return Object.keys(ret).length !== 0 ? ret : undefined;
}
//# sourceMappingURL=data:application/json;base64,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