"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsServiceRoller = exports.RollTrigger = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const targets = require("aws-cdk-lib/aws-events-targets");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
/**
 * The rule or schedule that should trigger a roll
 */
class RollTrigger {
    /**
     * Schedule that should trigger a roll
     */
    static fromSchedule(schedule) {
        return { schedule };
    }
    /**
     * Rule that should trigger a roll
     */
    static fromRule(rule) {
        return { rule };
    }
}
exports.RollTrigger = RollTrigger;
_a = JSII_RTTI_SYMBOL_1;
RollTrigger[_a] = { fqn: "cloudstructs.RollTrigger", version: "0.4.22" };
/**
 * Roll your ECS service tasks on schedule or with a rule
 */
class EcsServiceRoller extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _c, _d, _e, _f;
        super(scope, id);
        const rule = (_d = (_c = props.trigger) === null || _c === void 0 ? void 0 : _c.rule) !== null && _d !== void 0 ? _d : new events.Rule(this, 'Rule', {
            schedule: (_f = (_e = props.trigger) === null || _e === void 0 ? void 0 : _e.schedule) !== null && _f !== void 0 ? _f : events.Schedule.cron({
                minute: '0',
                hour: '0',
            }),
        });
        rule.addTarget(new targets.AwsApi({
            service: 'ECS',
            action: 'updateService',
            parameters: {
                service: props.service.serviceName,
                cluster: props.cluster.clusterName,
                forceNewDeployment: true,
            },
            // https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-supported-iam-actions-resources.html
            // arn:aws:ecs:<region>:<account>:service/<cluster-name>/<service-name>
            policyStatement: new iam.PolicyStatement({
                actions: ['ecs:UpdateService'],
                resources: [aws_cdk_lib_1.Stack.of(this).formatArn({
                        service: 'ecs',
                        resource: 'service',
                        resourceName: `${props.cluster.clusterName}/${props.service.serviceName}`,
                    })],
            }),
        }));
    }
}
exports.EcsServiceRoller = EcsServiceRoller;
_b = JSII_RTTI_SYMBOL_1;
EcsServiceRoller[_b] = { fqn: "cloudstructs.EcsServiceRoller", version: "0.4.22" };
//# sourceMappingURL=data:application/json;base64,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