var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, copyDefault, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && (copyDefault || key !== "default"))
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toESM = (module2, isNodeMode) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", !isNodeMode && module2 && module2.__esModule ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};
var __toCommonJS = /* @__PURE__ */ ((cache) => {
  return (module2, temp) => {
    return cache && cache.get(module2) || (temp = __reExport(__markAsModule({}), module2, 1), cache && cache.set(module2, temp), temp);
  };
})(typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : 0);

// src/toolkit-cleaner/clean-objects.lambda.ts
var clean_objects_lambda_exports = {};
__export(clean_objects_lambda_exports, {
  handler: () => handler
});
var path = __toESM(require("path"));
var import_aws_sdk = require("aws-sdk");
var s3 = new import_aws_sdk.S3();
async function handler(assetHashes) {
  var _a;
  if (!process.env.BUCKET_NAME) {
    throw new Error("Missing BUCKET_NAME");
  }
  let deleted = 0;
  let reclaimed = 0;
  let nextToken;
  let finished = false;
  while (!finished) {
    const response = await s3.listObjectsV2({
      Bucket: process.env.BUCKET_NAME,
      ContinuationToken: nextToken
    }).promise();
    const toDelete = (_a = response.Contents) == null ? void 0 : _a.filter((x) => {
      if (!x.Key) {
        return false;
      }
      const hash = path.basename(x.Key, path.extname(x.Key));
      let pred = !assetHashes.includes(hash);
      if (process.env.RETAIN_MILLISECONDS) {
        if (!x.LastModified) {
          return false;
        }
        const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
        pred = pred && x.LastModified < limitDate;
      }
      return pred;
    });
    if (toDelete && toDelete.length !== 0) {
      if (process.env.RUN) {
        await s3.deleteObjects({
          Bucket: process.env.BUCKET_NAME,
          Delete: {
            Objects: toDelete.map((x) => ({ Key: x.Key }))
          }
        }).promise();
      }
      deleted += toDelete.length;
      reclaimed += toDelete.reduce((acc, x) => acc + (x.Size ?? 0), 0);
    }
    nextToken = response.NextContinuationToken;
    if (nextToken === void 0) {
      finished = true;
    }
  }
  return {
    Deleted: deleted,
    Reclaimed: reclaimed
  };
}
module.exports = __toCommonJS(clean_objects_lambda_exports);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
