// Document loaded
document.addEventListener('DOMContentLoaded', function() {
    
    // New Task form
    const add_note_form = document.querySelector('#add-note-form');
    if (add_note_form) {
        // Handle form submit
        add_note_form.onsubmit = function () {
            
            // Form date
            const action = this.getAttribute('action');
            const method = this.getAttribute('method');
            const data = new FormData(this);

            // Submit form data via fetch api
            fetch(action, {
                method: method,
                body: data,
            })
            .then(response => response.json())
            .then(result => {
                // Result container
                let result_div = document.querySelector('#result');
                
                // Display the result container
                result_div.style.display = 'block';

                // An error occoured
                if (result.error) {
                    result_div.innerHTML = `${result.error}`;
                }

                // Everything is fine
                else if (result.success) {
                    // Show message
                    result_div.innerHTML = `${result.success}`;
                    
                    // Reset the form
                    this.reset();
                }
            });

            // Prevent default behavior
            return false

        };
    }

});