# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class Comment(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'text': 'str',
        'user_id': 'int',
        'is_resolved': 'bool',
        'annotations': 'list[Annotation]',
        'created_at': 'int'
    }

    attribute_map = {
        'id': 'id',
        'text': 'text',
        'user_id': 'user_id',
        'is_resolved': 'is_resolved',
        'annotations': 'annotations',
        'created_at': 'created_at'
    }

    def __init__(self, id=None, text=None, user_id=None, is_resolved=None, annotations=None, created_at=None, local_vars_configuration=None):  # noqa: E501
        """Comment - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._text = None
        self._user_id = None
        self._is_resolved = None
        self._annotations = None
        self._created_at = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if text is not None:
            self.text = text
        if user_id is not None:
            self.user_id = user_id
        if is_resolved is not None:
            self.is_resolved = is_resolved
        if annotations is not None:
            self.annotations = annotations
        if created_at is not None:
            self.created_at = created_at

    @property
    def id(self):
        """Gets the id of this Comment.  # noqa: E501

        A unique number identifying the Comment.  # noqa: E501

        :return: The id of this Comment.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Comment.

        A unique number identifying the Comment.  # noqa: E501

        :param id: The id of this Comment.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def text(self):
        """Gets the text of this Comment.  # noqa: E501

        The comment text.  # noqa: E501

        :return: The text of this Comment.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this Comment.

        The comment text.  # noqa: E501

        :param text: The text of this Comment.  # noqa: E501
        :type: str
        """

        self._text = text

    @property
    def user_id(self):
        """Gets the user_id of this Comment.  # noqa: E501

        The User who created this Comment.  # noqa: E501

        :return: The user_id of this Comment.  # noqa: E501
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this Comment.

        The User who created this Comment.  # noqa: E501

        :param user_id: The user_id of this Comment.  # noqa: E501
        :type: int
        """

        self._user_id = user_id

    @property
    def is_resolved(self):
        """Gets the is_resolved of this Comment.  # noqa: E501

        Whether the Comment is resolved.  # noqa: E501

        :return: The is_resolved of this Comment.  # noqa: E501
        :rtype: bool
        """
        return self._is_resolved

    @is_resolved.setter
    def is_resolved(self, is_resolved):
        """Sets the is_resolved of this Comment.

        Whether the Comment is resolved.  # noqa: E501

        :param is_resolved: The is_resolved of this Comment.  # noqa: E501
        :type: bool
        """

        self._is_resolved = is_resolved

    @property
    def annotations(self):
        """Gets the annotations of this Comment.  # noqa: E501

        A list of optional Annotations.  # noqa: E501

        :return: The annotations of this Comment.  # noqa: E501
        :rtype: list[Annotation]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this Comment.

        A list of optional Annotations.  # noqa: E501

        :param annotations: The annotations of this Comment.  # noqa: E501
        :type: list[Annotation]
        """

        self._annotations = annotations

    @property
    def created_at(self):
        """Gets the created_at of this Comment.  # noqa: E501

        Time at which the object was created. Measured in seconds since the Unix epoch.  # noqa: E501

        :return: The created_at of this Comment.  # noqa: E501
        :rtype: int
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Comment.

        Time at which the object was created. Measured in seconds since the Unix epoch.  # noqa: E501

        :param created_at: The created_at of this Comment.  # noqa: E501
        :type: int
        """

        self._created_at = created_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Comment):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Comment):
            return True

        return self.to_dict() != other.to_dict()
