# coding: utf-8

"""
    😸 Cheshire-Cat API

    Open source and customizable AI architecture

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class BodyUploadUrl(BaseModel):
    """
    BodyUploadUrl
    """
    url: StrictStr = Field(..., description="URL of the website to which you want to save the content")
    chunk_size: Optional[StrictInt] = Field(400, description="Maximum length of each chunk after the document is split (in characters)")
    chunk_overlap: Optional[StrictInt] = Field(100, description="Chunk overlap (in characters)")
    __properties = ["url", "chunk_size", "chunk_overlap"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BodyUploadUrl:
        """Create an instance of BodyUploadUrl from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BodyUploadUrl:
        """Create an instance of BodyUploadUrl from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BodyUploadUrl.parse_obj(obj)

        _obj = BodyUploadUrl.parse_obj({
            "url": obj.get("url"),
            "chunk_size": obj.get("chunk_size") if obj.get("chunk_size") is not None else 400,
            "chunk_overlap": obj.get("chunk_overlap") if obj.get("chunk_overlap") is not None else 100
        })
        return _obj


