# Cheshire Cat API client
API to develop Python clients to interact with the Cheshire Cat.

The package allows to instantiate a [WebSocket](#documentation-for-websocket) client and provides the API to interact with all the [endpoints](#documentation-for-api-endpoints).

A part of this Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project.

For a deeper documentation about the available endpoints please, refers to the API [ReDoc](http://localhost:1865/redoc).
The official Cheshire Cat documentation is available [here](https://cheshire-cat-ai.github.io/docs/).

## Requirements.

Python 3.10

## Installation & Usage
### pip install

You can install the API with `pip`:

```sh
pip install cheshire-cat-api
```

Then import the package:
```python
import cheshire_cat_api as ccat
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following.

### Send a message via WebSocket

```python
import cheshire_cat_api as ccat

# Define the cat client manager with default settings and send a message to the server via WebSocket.
cat_client = ccat.CatClient() 
cat_client.send(message="Hello Cat!")

cat_client.close()
```

### Interact with the Endpoints

where required, the data models are documented [here](#documentation-for-models)
```python
import cheshire_cat_api as ccat

cat_client = ccat.CatClient()

# All the endpoints are exposed under the `api` module
# For example you can retrieve a list of the available plugins
plugins = cat_client.api.plugins.list_available_plugins()

# Please note that interacting with the RabbitHole to upload
# a URL requires to structure the body like this
from cheshire_cat_api.models.body_upload_url import BodyUploadUrl

body_upload_url = BodyUploadUrl(
    url="https://cheshire-cat-ai.github.io/docs/conceptual/cheshire_cat/rabbit_hole/",
    chunk_size=400,
    chunk_overlap=100,
    summary=False
)

# then you can make the request as follows
response = cat_client.api.rabbit_hole.upload_url(body_upload_url)
```

## Documentation for WebSocket

Both the classes are available with:
```python
from cheshire_cat_api import Settings, WebSocketSettings
```

| Class               | Name       | Default     | Description                                                                                                          |
|---------------------|------------|-------------|----------------------------------------------------------------------------------------------------------------------|
| *Settings*          | `base_url` | 'localhost' | base URL where the Cat is hosted                                                                                     |
| *Settings*          | `auth_key` | ''          | authentication key for the endpoints                                                                                 |
| *Settings*          | `port`     | 1865        | port for the connection                                                                                              |
| *Settings*          | `secure`   | False       | if to instantiate a secure connection, i.e. `wss://`                                                                 |
| *Settings*          | `timeout`  | 10000       | timeout for the endpoints                                                                                            |
| *Settings*          | `instant`  | True        | if true the websocket connection is instantiated immediately, otherwise you can connect later with `CatClient.run()` |
| *WebSocketSettings* | `path`     | 'ws'        | the websocket path                                                                                                   |
| *WebSocketSettings* | `retries`  | 3           | maximum number of retries before calling `on_failed` event                                                           |
| *WebSocketSettings* | `delay`    | 5000        | delay for reconnect, in milliseconds                                                                                 |

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

| Class                           | Method                                                                                   | HTTP request                                            | Description                 |
|---------------------------------|------------------------------------------------------------------------------------------|---------------------------------------------------------|-----------------------------|
| *MemoryApi*                     | [**delete_element_in_memory**](docs/MemoryApi.md#delete_element_in_memory)               | **DELETE** /memory/point/{collection_id}/{memory_id}/   | Delete Element In Memory    |
| *MemoryApi*                     | [**get_collections**](docs/MemoryApi.md#get_collections)                                 | **GET** /memory/collections/                            | Get Collections             |
| *MemoryApi*                     | [**recall_memories_from_text**](docs/MemoryApi.md#recall_memories_from_text)             | **GET** /memory/recall/                                 | Recall Memories From Text   |
| *MemoryApi*                     | [**wipe_collections**](docs/MemoryApi.md#wipe_collections)                               | **DELETE** /memory/wipe-collections/                    | Wipe Collections            |
| *MemoryApi*                     | [**wipe_conversation_history**](docs/MemoryApi.md#wipe_conversation_history)             | **DELETE** /memory/working-memory/conversation-history/ | Wipe Conversation History   |
| *MemoryApi*                     | [**wipe_single_collection**](docs/MemoryApi.md#wipe_single_collection)                   | **DELETE** /memory/collections/{collection_id}          | Wipe Single Collection      |
| *PluginsApi*                    | [**delete_plugin**](docs/PluginsApi.md#delete_plugin)                                    | **DELETE** /plugins/{plugin_id}                         | Delete Plugin               |
| *PluginsApi*                    | [**get_plugin_details**](docs/PluginsApi.md#get_plugin_details)                          | **GET** /plugins/{plugin_id}                            | Get Plugin Details          |
| *PluginsApi*                    | [**get_plugin_settings**](docs/PluginsApi.md#get_plugin_settings)                        | **GET** /plugins/settings/{plugin_id}                   | Get Plugin Settings         |
| *PluginsApi*                    | [**install_plugin**](docs/PluginsApi.md#install_plugin)                                  | **POST** /plugins/upload/                               | Install Plugin              |
| *PluginsApi*                    | [**list_available_plugins**](docs/PluginsApi.md#list_available_plugins)                  | **GET** /plugins/                                       | List Available Plugins      |
| *PluginsApi*                    | [**toggle_plugin**](docs/PluginsApi.md#toggle_plugin)                                    | **PUT** /plugins/toggle/{plugin_id}                     | Toggle Plugin               |
| *PluginsApi*                    | [**upsert_plugin_settings**](docs/PluginsApi.md#upsert_plugin_settings)                  | **PUT** /plugins/settings/{plugin_id}                   | Upsert Plugin Settings      |
| *RabbitHoleApi*                 | [**upload_file**](docs/RabbitHoleApi.md#upload_file)                                     | **POST** /rabbithole/                                   | Upload File                 |
| *RabbitHoleApi*                 | [**upload_memory**](docs/RabbitHoleApi.md#upload_memory)                                 | **POST** /rabbithole/memory/                            | Upload Memory               |
| *RabbitHoleApi*                 | [**upload_url**](docs/RabbitHoleApi.md#upload_url)                                       | **POST** /rabbithole/web/                               | Upload Url                  |
| *SettingsEmbedderApi*           | [**get_embedder_settings**](docs/SettingsEmbedderApi.md#get_embedder_settings)           | **GET** /settings/embedder/                             | Get Embedder Settings       |
| *SettingsEmbedderApi*           | [**upsert_embedder_setting**](docs/SettingsEmbedderApi.md#upsert_embedder_setting)       | **PUT** /settings/embedder/{languageEmbedderName}       | Upsert Embedder Setting     |
| *SettingsGeneralApi*            | [**create_setting**](docs/SettingsGeneralApi.md#create_setting)                          | **POST** /settings/                                     | Create Setting              |
| *SettingsGeneralApi*            | [**delete_setting**](docs/SettingsGeneralApi.md#delete_setting)                          | **DELETE** /settings/{settingId}                        | Delete Setting              |
| *SettingsGeneralApi*            | [**get_setting**](docs/SettingsGeneralApi.md#get_setting)                                | **GET** /settings/{settingId}                           | Get Setting                 |
| *SettingsGeneralApi*            | [**get_settings**](docs/SettingsGeneralApi.md#get_settings)                              | **GET** /settings/                                      | Get Settings                |
| *SettingsGeneralApi*            | [**update_setting**](docs/SettingsGeneralApi.md#update_setting)                          | **PUT** /settings/{settingId}                           | Update Setting              |
| *SettingsLargeLanguageModelApi* | [**get_llm_settings**](docs/SettingsLargeLanguageModelApi.md#get_llm_settings)           | **GET** /settings/llm/                                  | Get Llm Settings            |
| *SettingsLargeLanguageModelApi* | [**upsert_llm_setting**](docs/SettingsLargeLanguageModelApi.md#upsert_llm_setting)       | **PUT** /settings/llm/{languageModelName}               | Upsert Llm Setting          |
| *SettingsPromptApi*             | [**get_default_prompt_settings**](docs/SettingsPromptApi.md#get_default_prompt_settings) | **GET** /settings/prompt/                               | Get Default Prompt Settings |
| *StatusApi*                     | [**home**](docs/StatusApi.md#home)                                                       | **GET** /                                               | Home                        |

## Documentation For Models

 - [BodyUploadUrl](docs/BodyUploadUrl.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [LocationInner](docs/LocationInner.md)
 - [SettingBody](docs/SettingBody.md)
 - [ValidationError](docs/ValidationError.md)





