"""Define controls found in ISO 27001."""

from . import ConstraintsGroup


class ISO27001Controls(ConstraintsGroup):
    """Enumeration of ISO 27001 controls.

    Using the definitions from
    http://gender.govmu.org/English/Documents/activities/gender%20infsys/AnnexIX1302.pdf
    """

    A_5 = "Security policy"
    A_5_1 = "Information security policy"
    A_5_1_1 = "Information security policy document"
    A_5_1_2 = "Review of the information security policy"

    A_6 = "Organization of information security"
    A_6_1 = "Internal organization"
    A_6_1_1 = "Management commitment to information security"
    A_6_1_2 = "Information  security coordination"
    A_6_1_3 = "Allocation of information security responsibilities"
    A_6_1_4 = "Authorization process for information processing facilities"
    A_6_1_5 = "Confidentiality agreements"
    A_6_1_6 = "Contact with authorities"
    A_6_1_7 = "Contact with special interest groups"
    A_6_1_8 = "Independent review of information security"
    A_6_2 = "External parties"
    A_6_2_1 = "Identification of risks related to external parties"
    A_6_2_2 = "Addressing security when dealing with customers"
    A_6_2_3 = "Addressing security in third party agreements"

    A_7 = "Asset management"
    A_7_1 = "Responsibility for assets"
    A_7_1_1 = "Inventory of assets"
    A_7_1_2 = "Ownership of assets"
    A_7_1_3 = "Acceptable use of assets"
    A_7_2 = "Information classification"
    A_7_2_1 = "Classification guidelines"
    A_7_2_2 = "Information labelling and handling"

    A_8 = "Human resources security"
    A_8_1 = "Prior to employment"
    A_8_1_1 = "Roles and responsibilities"
    A_8_1_2 = "Screening"
    A_8_1_3 = "Terms and conditions of employment"
    A_8_2 = "During employment"
    A_8_2_1 = "Management responsibilities"
    A_8_2_2 = "Information security awareness, education and training"
    A_8_2_3 = "Disciplinary process"
    A_8_3 = "Termination or change of employment"
    A_8_3_1 = "Termination responsibilities"
    A_8_3_2 = "Return of assets"
    A_8_3_3 = "Removal of access rights"

    A_9 = "Physical and environmental security"
    A_9_1 = "Secure areas"
    A_9_1_1 = "Physical security perimeter"
    A_9_1_2 = "Physical entry controls"
    A_9_1_3 = "Securing offices, rooms and facilities"
    A_9_1_4 = "Protecting against external and environmental threats"
    A_9_1_5 = "Working in secure areas"
    A_9_1_6 = "Public access, delivery and loading areas"
    A_9_2 = "Equipment security"
    A_9_2_1 = "Equipment siting and protection"
    A_9_2_2 = "Supporting utilities"
    A_9_2_3 = "Cabling security"
    A_9_2_4 = "Equipment maintenance"
    A_9_2_5 = "Security of equipment off premises"
    A_9_2_6 = "Secure disposal or re-use of equipment"
    A_9_2_7 = "Removal of property"

    A_10 = "Communications and operations management"
    A_10_1 = "Operational procedures and responsibilities"
    A_10_1_1 = "Documented operating procedures"
    A_10_1_2 = "Change management"
    A_10_1_3 = "Segregation of duties"
    A_10_1_4 = "Separation of development, test and operational facilities"
    A_10_2 = "Third party service delivery management"
    A_10_2_1 = "Service delivery"
    A_10_2_2 = "Monitoring and review of third party services"
    A_10_2_3 = "Managing changes to third party services"
    A_10_3 = "System planning and acceptance"
    A_10_3_1 = "Capacity management"
    A_10_3_2 = "System acceptance"
    A_10_4 = "Protection against malicious and mobile code"
    A_10_4_1 = "Controls against malicious code"
    A_10_4_2 = "Controls against mobile code"
    A_10_5 = "Back-up"
    A_10_5_1 = "Information back-up"
    A_10_6 = "Network security management"
    A_10_6_1 = "Network controls"
    A_10_6_2 = "Security of network services"
    A_10_7 = "Media handling"
    A_10_7_1 = "Management of removable media"
    A_10_7_2 = "Disposal of media"
    A_10_7_3 = "Information handling procedures"
    A_10_7_4 = "Security of system documentation"
    A_10_8 = "Exchange of information"
    A_10_8_1 = "Information exchange policies and procedures"
    A_10_8_2 = "Exchange agreements"
    A_10_8_3 = "Physical media in transit"
    A_10_8_4 = "Electronic messaging"
    A_10_8_5 = "Business information systems"
    A_10_9 = "Electronic commerce services"
    A_10_9_1 = "Electronic commerce"
    A_10_9_2 = "On-line transactions"
    A_10_9_3 = "Publicly available information"
    A_10_10 = "Monitoring"
    A_10_10_1 = "Audit logging"
    A_10_10_2 = "Monitoring system use"
    A_10_10_3 = "Protection of log information"
    A_10_10_4 = "Administrator and operator logs"
    A_10_10_5 = "Fault logging"
    A_10_10_6 = "Clock synchronization"

    A_11 = "Access control"
    A_11_1 = "Business requirement for access control"
    A_11_1_1 = "Access control policy"
    A_11_2 = "User access management"
    A_11_2_1 = "User registration"
    A_11_2_2 = "Privilege management"
    A_11_2_3 = "User password management"
    A_11_2_4 = "Review of user access rights"
    A_11_3 = "User responsibilities"
    A_11_3_1 = "Password use"
    A_11_3_2 = "Unattended user equipment"
    A_11_3_3 = "Clear desk and clear screen policy"
    A_11_4 = "Network access control"
    A_11_4_1 = "Policy on use of network services"
    A_11_4_2 = "User authentication for external connections"
    A_11_4_3 = "Equipment identification in networks"
    A_11_4_4 = "Remote diagnostic and configuration port protection"
    A_11_4_5 = "Segregation in networks"
    A_11_4_6 = "Network connection control"
    A_11_4_7 = "Network routing control"
    A_11_5 = "Operating system access control"
    A_11_5_1 = "Secure log-on procedures"
    A_11_5_2 = "User identification and authentication"
    A_11_5_3 = "Password management system"
    A_11_5_4 = "Use of system utilities"
    A_11_5_5 = "Session time-out"
    A_11_5_6 = "Limitation of connection time"
    A_11_6 = "Application and information access control"
    A_11_6_1 = "Information access restriction"
    A_11_6_2 = "Sensitive system isolation"
    A_11_7 = "Mobile computing and teleworking"
    A_11_7_1 = "Mobile computing and communications"
    A_11_7_2 = "Teleworking"

    A_12 = "Information systems acquisition, development and maintenance"
    A_12_1 = "Security requirements of information systems"
    A_12_1_1 = "Security requirements analysis and specification"
    A_12_2 = "Correct processing in applications"
    A_12_2_1 = "Input data validation"
    A_12_2_2 = "Control of internal processing"
    A_12_2_3 = "Message integrity"
    A_12_2_4 = "Output data validation"
    A_12_3 = "Cryptographic controls"
    A_12_3_1 = "Policy on the use of cryptographic controls"
    A_12_3_2 = "Key management"
    A_12_4 = "Security of system files"
    A_12_4_1 = "Control of operational software"
    A_12_4_2 = "Protection of system test data"
    A_12_4_3 = "Access control to program source code"
    A_12_5 = "Security in development and support processes"
    A_12_5_1 = "Change control procedures"
    A_12_5_2 = "Technical review of applications after operating system changes"
    A_12_5_3 = "Restrictions on changes to software packages"
    A_12_5_4 = "Information leakage"
    A_12_5_5 = "Outsourced software development"
    A_12_6 = "Technical Vulnerability Management"
    A_12_6_1 = "Control of technical vulnerabilities"

    A_13 = "Information security incident management"
    A_13_1 = "Reporting information security events and weaknesses"
    A_13_1_1 = "Reporting information security events"
    A_13_1_2 = "Reporting security weaknesses"
    A_13_2 = "Management of information security incidents and improvements"
    A_13_2_1 = "Responsibilities and procedures"
    A_13_2_2 = "Learning from information security incidents"
    A_13_2_3 = "Collection of evidence"

    A_14 = "Business continuity management"
    A_14_1 = "Information security aspects of business continuity management"
    A_14_1_1 = "Including information security in the business continuity management process"
    A_14_1_2 = "Business continuity and risk assessment"
    A_14_1_3 = "Developing and implementing continuity plans including information security"
    A_14_1_4 = "Business continuity planning framework"
    A_14_1_5 = "Testing, maintaining and reassessing business continuity plans"

    A_15 = "Compliance"
    A_15_1 = "Compliance with legal requirements"
    A_15_1_1 = "Identification of applicable legislation"
    A_15_1_2 = "Intellectual property rights (IPR)"
    A_15_1_3 = "Protection of organizational records"
    A_15_1_4 = "Data protection and privacy of personal information"
    A_15_1_5 = "Prevention of misuse of information processing facilities"
    A_15_1_6 = "Regulation of cryptographic controls"
    A_15_2 = "Compliance with security policies and standards, and technical compliance"
    A_15_2_1 = "Compliance with security policies and standards"
    A_15_2_2 = "Technical compliance checking"
    A_15_3 = "Information systems audit considerations"
    A_15_3_1 = "Information systems audit controls"
    A_15_3_2 = "Protection of information systems audit tools"
