"""
    LanXin+ OpenAPI

    LanXin+ OpenAPI Platform  # noqa: E501

    Generated by: https://openapi.lanxin.cn
"""

import unittest

from pprint import pprint
try:
    import lanxinplus_openapi
except ImportError:
    import sys
    sys.path.append(sys.argv[0].replace("\\test\\test_role_api.py", "\\"))  # noqa: E501
    import lanxinplus_openapi
from lanxinplus_openapi.api.role_api import RoleApi  # noqa: E501
from lanxinplus_openapi import Configuration
from lanxinplus_openapi.model.v1_org_role_create_request_body import V1OrgRoleCreateRequestBody
from lanxinplus_openapi.model.v1_org_role_create_response import V1OrgRoleCreateResponse
from lanxinplus_openapi.model.v1_org_role_members_fetch_response import V1OrgRoleMembersFetchResponse
from lanxinplus_openapi.model.v1_role_member_create_request_body import V1RoleMemberCreateRequestBody
from lanxinplus_openapi.model.v1_role_member_create_response import V1RoleMemberCreateResponse
from lanxinplus_openapi.model.v1_role_member_delete_request_body import V1RoleMemberDeleteRequestBody
from lanxinplus_openapi.model.v1_role_member_delete_response import V1RoleMemberDeleteResponse
from lanxinplus_openapi.api.auth_api import AuthApi


class TestRoleApi(unittest.TestCase):
    """RoleApi unit test stubs"""

    @classmethod
    def setUpClass(cls):
        # 蓝信开放平台网关地址, e.g.: https://example.com/open/apigw
        host = "host"
        # 应用ID, e.g.: 1234567-7654321
        app_id = "app_id"
        # 应用密钥, e.g.: D25F65E65D887AEFD9C92B00310286FA
        app_secret = "app_secret"

        cls.config = Configuration(host, app_id, app_secret)
        # Configuration.set_default(cls.config)
        cls.client = lanxinplus_openapi.ApiClient(configuration=cls.config)
        cls.api = RoleApi(api_client=cls.client)  # noqa: E501
        # get app_token
        try:
            api = AuthApi(api_client=cls.client)
            resp = api.v1_app_token_create("client_credential", cls.config.app_id, cls.config.app_secret)
            if resp.errCode == 0:
                cls.config.set_app_token(resp.data.appToken, resp.data.expiresIn)
            else:
                raise lanxinplus_openapi.ApiException(reason=resp.errMsg)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AuthApi->v1_apptoken_create: %s\n" % e)


    @classmethod
    def tearDownClass(cls):
        pass

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_v1_org_role_create(self):
        """Test case for v1_org_role_create
        创建角色  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        orgid = "orgid_example" # str | orgid
        v1_org_role_create_request_body = V1OrgRoleCreateRequestBody(
        creator="creator_example",
        description="description_example",
        roleName="roleName_example",
    ) # V1OrgRoleCreateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 创建角色
            resp = self.api.v1_org_role_create(app_token, orgid, v1_org_role_create_request_body)
            print("TestCase RoleApi->v1_org_role_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling RoleApi->v1_org_role_create: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 创建角色
            resp = self.api.v1_org_role_create(app_token, orgid, v1_org_role_create_request_body, user_token=user_token)
            print("TestCase RoleApi->v1_org_role_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling RoleApi->v1_org_role_create: %s\n" % e)
        '''


    def test_v1_org_role_members_fetch(self):
        """Test case for v1_org_role_members_fetch
        获取应用运营者列表  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        orgid = "orgid_example" # str | orgid
        roleid = "roleid_example" # str | roleid
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取应用运营者列表
            resp = self.api.v1_org_role_members_fetch(app_token, orgid, roleid)
            print("TestCase RoleApi->v1_org_role_members_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling RoleApi->v1_org_role_members_fetch: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取应用运营者列表
            resp = self.api.v1_org_role_members_fetch(app_token, orgid, roleid, user_token=user_token)
            print("TestCase RoleApi->v1_org_role_members_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling RoleApi->v1_org_role_members_fetch: %s\n" % e)
        '''


    def test_v1_role_member_create(self):
        """Test case for v1_role_member_create
        添加角色成员  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v1_role_member_create_request_body = V1RoleMemberCreateRequestBody(
        creator="creator_example",
        roleId="roleId_example",
        staffIds=[
            "staffIds_example",
        ],
    ) # V1RoleMemberCreateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 添加角色成员
            resp = self.api.v1_role_member_create(app_token, v1_role_member_create_request_body)
            print("TestCase RoleApi->v1_role_member_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling RoleApi->v1_role_member_create: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 添加角色成员
            resp = self.api.v1_role_member_create(app_token, v1_role_member_create_request_body, user_token=user_token)
            print("TestCase RoleApi->v1_role_member_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling RoleApi->v1_role_member_create: %s\n" % e)
        '''


    def test_v1_role_member_delete(self):
        """Test case for v1_role_member_delete
        删除角色成员  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        rolememberid = "rolememberid_example" # str | rolememberid
        v1_role_member_delete_request_body = V1RoleMemberDeleteRequestBody(
        operator="operator_example",
    ) # V1RoleMemberDeleteRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 删除角色成员
            resp = self.api.v1_role_member_delete(app_token, rolememberid, v1_role_member_delete_request_body)
            print("TestCase RoleApi->v1_role_member_delete: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling RoleApi->v1_role_member_delete: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 删除角色成员
            resp = self.api.v1_role_member_delete(app_token, rolememberid, v1_role_member_delete_request_body, user_token=user_token)
            print("TestCase RoleApi->v1_role_member_delete: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling RoleApi->v1_role_member_delete: %s\n" % e)
        '''



if __name__ == '__main__':
    unittest.main()
