"""
    LanXin+ OpenAPI

    LanXin+ OpenAPI Platform  # noqa: E501

    Generated by: https://openapi.lanxin.cn
"""

import unittest

from pprint import pprint
try:
    import lanxinplus_openapi
except ImportError:
    import sys
    sys.path.append(sys.argv[0].replace("\\test\\test_message_api.py", "\\"))  # noqa: E501
    import lanxinplus_openapi
from lanxinplus_openapi.api.message_api import MessageApi  # noqa: E501
from lanxinplus_openapi import Configuration
from lanxinplus_openapi.model.v1_chat_notification_fetch_response import V1ChatNotificationFetchResponse
from lanxinplus_openapi.model.v1_messages_create_request_body import V1MessagesCreateRequestBody
from lanxinplus_openapi.model.v1_messages_create_response import V1MessagesCreateResponse
from lanxinplus_openapi.model.v1_messages_notification_create_request_body import V1MessagesNotificationCreateRequestBody
from lanxinplus_openapi.model.v1_messages_notification_create_response import V1MessagesNotificationCreateResponse
from lanxinplus_openapi.model.v1_messages_revoke_request_body import V1MessagesRevokeRequestBody
from lanxinplus_openapi.model.v1_messages_revoke_response import V1MessagesRevokeResponse
from lanxinplus_openapi.model.v2_chat_notification_update_request_body import V2ChatNotificationUpdateRequestBody
from lanxinplus_openapi.model.v2_chat_notification_update_response import V2ChatNotificationUpdateResponse
from lanxinplus_openapi.model.v2_event_notification_create_request_body import V2EventNotificationCreateRequestBody
from lanxinplus_openapi.model.v2_event_notification_create_response import V2EventNotificationCreateResponse
from lanxinplus_openapi.model.system_msg import SystemMsg
from lanxinplus_openapi.model.status_info import StatusInfo
from lanxinplus_openapi.model.event import Event
from lanxinplus_openapi.model.push_data import PushData
from lanxinplus_openapi.api.auth_api import AuthApi


class TestMessageApi(unittest.TestCase):
    """MessageApi unit test stubs"""

    @classmethod
    def setUpClass(cls):
        # 蓝信开放平台网关地址, e.g.: https://example.com/open/apigw
        host = "host"
        # 应用ID, e.g.: 1234567-7654321
        app_id = "app_id"
        # 应用密钥, e.g.: D25F65E65D887AEFD9C92B00310286FA
        app_secret = "app_secret"

        cls.config = Configuration(host, app_id, app_secret)
        # Configuration.set_default(cls.config)
        cls.client = lanxinplus_openapi.ApiClient(configuration=cls.config)
        cls.api = MessageApi(api_client=cls.client)  # noqa: E501
        # get app_token
        try:
            api = AuthApi(api_client=cls.client)
            resp = api.v1_app_token_create("client_credential", cls.config.app_id, cls.config.app_secret)
            if resp.errCode == 0:
                cls.config.set_app_token(resp.data.appToken, resp.data.expiresIn)
            else:
                raise lanxinplus_openapi.ApiException(reason=resp.errMsg)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AuthApi->v1_apptoken_create: %s\n" % e)


    @classmethod
    def tearDownClass(cls):
        pass

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_v1_chat_notification_fetch(self):
        """Test case for v1_chat_notification_fetch
        获取通知消息会话状态  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        userid = "userid_example" # str | userid
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取通知消息会话状态
            resp = self.api.v1_chat_notification_fetch(app_token, userid)
            print("TestCase MessageApi->v1_chat_notification_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v1_chat_notification_fetch: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取通知消息会话状态
            resp = self.api.v1_chat_notification_fetch(app_token, userid, user_token=user_token)
            print("TestCase MessageApi->v1_chat_notification_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v1_chat_notification_fetch: %s\n" % e)
        '''


    def test_v1_messages_create(self):
        """Test case for v1_messages_create
        发送应用消息应用号通道  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v1_messages_create_request_body = V1MessagesCreateRequestBody(
        accountId="accountId_example",
        attach="attach_example",
        departmentIdList=[
            "departmentIdList_example",
        ],
        entryId="entryId_example",
        msgData={},
        msgType="msgType_example",
        userIdList=[
            "userIdList_example",
        ],
    ) # V1MessagesCreateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 发送应用消息应用号通道
            resp = self.api.v1_messages_create(app_token, v1_messages_create_request_body)
            print("TestCase MessageApi->v1_messages_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v1_messages_create: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 发送应用消息应用号通道
            resp = self.api.v1_messages_create(app_token, v1_messages_create_request_body, user_token=user_token)
            print("TestCase MessageApi->v1_messages_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v1_messages_create: %s\n" % e)
        '''


    def test_v1_messages_notification_create(self):
        """Test case for v1_messages_notification_create
        发送通知消息  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v1_messages_notification_create_request_body = V1MessagesNotificationCreateRequestBody(
        msgData={},
        msgType="msgType_example",
        receiverIds=[
            "receiverIds_example",
        ],
        senderId="senderId_example",
        uuid="uuid_example",
    ) # V1MessagesNotificationCreateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 发送通知消息
            resp = self.api.v1_messages_notification_create(app_token, v1_messages_notification_create_request_body)
            print("TestCase MessageApi->v1_messages_notification_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v1_messages_notification_create: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 发送通知消息
            resp = self.api.v1_messages_notification_create(app_token, v1_messages_notification_create_request_body, user_token=user_token)
            print("TestCase MessageApi->v1_messages_notification_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v1_messages_notification_create: %s\n" % e)
        '''


    def test_v1_messages_revoke(self):
        """Test case for v1_messages_revoke
        撤回消息  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v1_messages_revoke_request_body = V1MessagesRevokeRequestBody(
        chatType="chatType_example",
        messageIds=[
            "messageIds_example",
        ],
        senderId="senderId_example",
        sysMsg=SystemMsg(
            content="content_example",
            mediaId="mediaId_example",
        ),
    ) # V1MessagesRevokeRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 撤回消息
            resp = self.api.v1_messages_revoke(app_token, v1_messages_revoke_request_body)
            print("TestCase MessageApi->v1_messages_revoke: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v1_messages_revoke: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 撤回消息
            resp = self.api.v1_messages_revoke(app_token, v1_messages_revoke_request_body, user_token=user_token)
            print("TestCase MessageApi->v1_messages_revoke: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v1_messages_revoke: %s\n" % e)
        '''


    def test_v2_chat_notification_update(self):
        """Test case for v2_chat_notification_update
        更新通知消息会话状态（批量）  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v2_chat_notification_update_request_body = V2ChatNotificationUpdateRequestBody(
        statusList=[
            StatusInfo(
                baseVersion="baseVersion_example",
                noDisturb="noDisturb_example",
                unreadCount=1,
                userId="userId_example",
                uuid="uuid_example",
            ),
        ],
    ) # V2ChatNotificationUpdateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 更新通知消息会话状态（批量）
            resp = self.api.v2_chat_notification_update(app_token, v2_chat_notification_update_request_body)
            print("TestCase MessageApi->v2_chat_notification_update: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v2_chat_notification_update: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 更新通知消息会话状态（批量）
            resp = self.api.v2_chat_notification_update(app_token, v2_chat_notification_update_request_body, user_token=user_token)
            print("TestCase MessageApi->v2_chat_notification_update: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v2_chat_notification_update: %s\n" % e)
        '''


    def test_v2_event_notification_create(self):
        """Test case for v2_event_notification_create
        发送应用消息应用号通道  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v2_event_notification_create_request_body = V2EventNotificationCreateRequestBody(
        events=[
            Event(
                channelType=1,
                deviceType=1,
                entryId="entryId_example",
                eventData="eventData_example",
                eventType="eventType_example",
                expires=1,
                pushData=PushData(
                    androidSoundUrl="androidSoundUrl_example",
                    appType="appType_example",
                    content="content_example",
                    iosSoundUrl="iosSoundUrl_example",
                    title="title_example",
                    url="url_example",
                ),
                receiverIds=[
                    "receiverIds_example",
                ],
                version=1,
            ),
        ],
    ) # V2EventNotificationCreateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 发送应用消息应用号通道
            resp = self.api.v2_event_notification_create(app_token, v2_event_notification_create_request_body)
            print("TestCase MessageApi->v2_event_notification_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v2_event_notification_create: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 发送应用消息应用号通道
            resp = self.api.v2_event_notification_create(app_token, v2_event_notification_create_request_body, user_token=user_token)
            print("TestCase MessageApi->v2_event_notification_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling MessageApi->v2_event_notification_create: %s\n" % e)
        '''



if __name__ == '__main__':
    unittest.main()
