"""
    LanXin+ OpenAPI

    LanXin+ OpenAPI Platform  # noqa: E501

    Generated by: https://openapi.lanxin.cn
"""

import unittest

from pprint import pprint
try:
    import lanxinplus_openapi
except ImportError:
    import sys
    sys.path.append(sys.argv[0].replace("\\test\\test_auth_api.py", "\\"))  # noqa: E501
    import lanxinplus_openapi
from lanxinplus_openapi.api.auth_api import AuthApi  # noqa: E501
from lanxinplus_openapi import Configuration
from lanxinplus_openapi.model.v1_app_token_create_response import V1AppTokenCreateResponse
from lanxinplus_openapi.model.v1_js_api_token_create_response import V1JsApiTokenCreateResponse
from lanxinplus_openapi.model.v1_user_token_create_response import V1UserTokenCreateResponse
from lanxinplus_openapi.model.v1_users_fetch_response import V1UsersFetchResponse


class TestAuthApi(unittest.TestCase):
    """AuthApi unit test stubs"""

    @classmethod
    def setUpClass(cls):
        # 蓝信开放平台网关地址, e.g.: https://example.com/open/apigw
        host = "host"
        # 应用ID, e.g.: 1234567-7654321
        app_id = "app_id"
        # 应用密钥, e.g.: D25F65E65D887AEFD9C92B00310286FA
        app_secret = "app_secret"

        cls.config = Configuration(host, app_id, app_secret)
        # Configuration.set_default(cls.config)
        cls.client = lanxinplus_openapi.ApiClient(configuration=cls.config)
        cls.api = AuthApi(api_client=cls.client)  # noqa: E501
        # get app_token
        try:
            api = AuthApi(api_client=cls.client)
            resp = api.v1_app_token_create("client_credential", cls.config.app_id, cls.config.app_secret)
            if resp.errCode == 0:
                cls.config.set_app_token(resp.data.appToken, resp.data.expiresIn)
            else:
                raise lanxinplus_openapi.ApiException(reason=resp.errMsg)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AuthApi->v1_apptoken_create: %s\n" % e)


    @classmethod
    def tearDownClass(cls):
        pass

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_v1_app_token_create(self):
        """Test case for v1_app_token_create
        获取应用访问TOKEN  # noqa: E501
        """
        
        grant_type = "grant_type_example" # str | client_credential
        appid = self.config.app_id # str | 应用ID
        secret = self.config.app_secret # str | 应用密钥

        # example passing only required values which don't have defaults set
        try:
            # 获取应用访问TOKEN
            resp = self.api.v1_app_token_create(grant_type, appid, secret)
            print("TestCase AuthApi->v1_app_token_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AuthApi->v1_app_token_create: %s\n" % e)



    def test_v1_js_api_token_create(self):
        """Test case for v1_js_api_token_create
        获取jsapi访问TOKEN  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取jsapi访问TOKEN
            resp = self.api.v1_js_api_token_create(app_token)
            print("TestCase AuthApi->v1_js_api_token_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AuthApi->v1_js_api_token_create: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取jsapi访问TOKEN
            resp = self.api.v1_js_api_token_create(app_token, user_token=user_token)
            print("TestCase AuthApi->v1_js_api_token_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AuthApi->v1_js_api_token_create: %s\n" % e)
        '''


    def test_v1_user_token_create(self):
        """Test case for v1_user_token_create
        获取人员访问TOKEN  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        grant_type = "grant_type_example" # str | 使用固定值 'authorization_code'
        code = "code_example" # str | 人员免登录授权码
        redirect_uri = "redirect_uri_example" # str | redirect_uri (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取人员访问TOKEN
            resp = self.api.v1_user_token_create(app_token, grant_type, code)
            print("TestCase AuthApi->v1_user_token_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AuthApi->v1_user_token_create: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取人员访问TOKEN
            resp = self.api.v1_user_token_create(app_token, grant_type, code, redirect_uri=redirect_uri)
            print("TestCase AuthApi->v1_user_token_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AuthApi->v1_user_token_create: %s\n" % e)
        '''


    def test_v1_users_fetch(self):
        """Test case for v1_users_fetch
        获取人员基本信息  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        user_token = self.config.user_token # str | user_token

        # example passing only required values which don't have defaults set
        try:
            # 获取人员基本信息
            resp = self.api.v1_users_fetch(app_token, user_token)
            print("TestCase AuthApi->v1_users_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AuthApi->v1_users_fetch: %s\n" % e)




if __name__ == '__main__':
    unittest.main()
