"""
    LanXin+ OpenAPI

    LanXin+ OpenAPI Platform  # noqa: E501

    Generated by: https://openapi.lanxin.cn
"""

import unittest

from pprint import pprint
try:
    import lanxinplus_openapi
except ImportError:
    import sys
    sys.path.append(sys.argv[0].replace("\\test\\test_addrbk_tags_api.py", "\\"))  # noqa: E501
    import lanxinplus_openapi
from lanxinplus_openapi.api.addrbk_tags_api import AddrbkTagsApi  # noqa: E501
from lanxinplus_openapi import Configuration
from lanxinplus_openapi.model.v1_tag_groups_create_request_body import V1TagGroupsCreateRequestBody
from lanxinplus_openapi.model.v1_tag_groups_create_response import V1TagGroupsCreateResponse
from lanxinplus_openapi.model.v1_tag_groups_delete_response import V1TagGroupsDeleteResponse
from lanxinplus_openapi.model.v1_tag_groups_fetch_request_body import V1TagGroupsFetchRequestBody
from lanxinplus_openapi.model.v1_tag_groups_fetch_response import V1TagGroupsFetchResponse
from lanxinplus_openapi.model.v1_tag_groups_info_fetch_response import V1TagGroupsInfoFetchResponse
from lanxinplus_openapi.model.v1_tag_groups_update_request_body import V1TagGroupsUpdateRequestBody
from lanxinplus_openapi.model.v1_tag_groups_update_response import V1TagGroupsUpdateResponse
from lanxinplus_openapi.model.v1_tags_create_request_body import V1TagsCreateRequestBody
from lanxinplus_openapi.model.v1_tags_create_response import V1TagsCreateResponse
from lanxinplus_openapi.model.v1_tags_delete_response import V1TagsDeleteResponse
from lanxinplus_openapi.model.v1_tags_meta_fetch_request_body import V1TagsMetaFetchRequestBody
from lanxinplus_openapi.model.v1_tags_meta_fetch_response import V1TagsMetaFetchResponse
from lanxinplus_openapi.model.v1_tags_update_request_body import V1TagsUpdateRequestBody
from lanxinplus_openapi.model.v1_tags_update_response import V1TagsUpdateResponse
from lanxinplus_openapi.api.auth_api import AuthApi


class TestAddrbkTagsApi(unittest.TestCase):
    """AddrbkTagsApi unit test stubs"""

    @classmethod
    def setUpClass(cls):
        # 蓝信开放平台网关地址, e.g.: https://example.com/open/apigw
        host = "host"
        # 应用ID, e.g.: 1234567-7654321
        app_id = "app_id"
        # 应用密钥, e.g.: D25F65E65D887AEFD9C92B00310286FA
        app_secret = "app_secret"

        cls.config = Configuration(host, app_id, app_secret)
        # Configuration.set_default(cls.config)
        cls.client = lanxinplus_openapi.ApiClient(configuration=cls.config)
        cls.api = AddrbkTagsApi(api_client=cls.client)  # noqa: E501
        # get app_token
        try:
            api = AuthApi(api_client=cls.client)
            resp = api.v1_app_token_create("client_credential", cls.config.app_id, cls.config.app_secret)
            if resp.errCode == 0:
                cls.config.set_app_token(resp.data.appToken, resp.data.expiresIn)
            else:
                raise lanxinplus_openapi.ApiException(reason=resp.errMsg)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AuthApi->v1_apptoken_create: %s\n" % e)


    @classmethod
    def tearDownClass(cls):
        pass

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_v1_tag_groups_create(self):
        """Test case for v1_tag_groups_create
        创建标签分组  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v1_tag_groups_create_request_body = V1TagGroupsCreateRequestBody(
        orgId="orgId_example",
        tagGroupCategory=1,
        tagGroupName="tagGroupName_example",
        tagGroupType="tagGroupType_example",
    ) # V1TagGroupsCreateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 创建标签分组
            resp = self.api.v1_tag_groups_create(app_token, v1_tag_groups_create_request_body)
            print("TestCase AddrbkTagsApi->v1_tag_groups_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tag_groups_create: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 创建标签分组
            resp = self.api.v1_tag_groups_create(app_token, v1_tag_groups_create_request_body, user_token=user_token)
            print("TestCase AddrbkTagsApi->v1_tag_groups_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tag_groups_create: %s\n" % e)
        '''


    def test_v1_tag_groups_delete(self):
        """Test case for v1_tag_groups_delete
        删除标签分组  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        tag_group_id = "tag_group_id_example" # str | tag_group_id
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 删除标签分组
            resp = self.api.v1_tag_groups_delete(app_token, tag_group_id)
            print("TestCase AddrbkTagsApi->v1_tag_groups_delete: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tag_groups_delete: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 删除标签分组
            resp = self.api.v1_tag_groups_delete(app_token, tag_group_id, user_token=user_token)
            print("TestCase AddrbkTagsApi->v1_tag_groups_delete: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tag_groups_delete: %s\n" % e)
        '''


    def test_v1_tag_groups_fetch(self):
        """Test case for v1_tag_groups_fetch
        获取标签分组列表  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v1_tag_groups_fetch_request_body = V1TagGroupsFetchRequestBody(
        categoryList=[
            1,
        ],
        orgId="orgId_example",
        tagGroupType="tagGroupType_example",
    ) # V1TagGroupsFetchRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取标签分组列表
            resp = self.api.v1_tag_groups_fetch(app_token, v1_tag_groups_fetch_request_body)
            print("TestCase AddrbkTagsApi->v1_tag_groups_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tag_groups_fetch: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取标签分组列表
            resp = self.api.v1_tag_groups_fetch(app_token, v1_tag_groups_fetch_request_body, user_token=user_token)
            print("TestCase AddrbkTagsApi->v1_tag_groups_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tag_groups_fetch: %s\n" % e)
        '''


    def test_v1_tag_groups_info_fetch(self):
        """Test case for v1_tag_groups_info_fetch
        获取标签分组详情  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        tag_group_id = "tag_group_id_example" # str | tag_group_id
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取标签分组详情
            resp = self.api.v1_tag_groups_info_fetch(app_token, tag_group_id)
            print("TestCase AddrbkTagsApi->v1_tag_groups_info_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tag_groups_info_fetch: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取标签分组详情
            resp = self.api.v1_tag_groups_info_fetch(app_token, tag_group_id, user_token=user_token)
            print("TestCase AddrbkTagsApi->v1_tag_groups_info_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tag_groups_info_fetch: %s\n" % e)
        '''


    def test_v1_tag_groups_update(self):
        """Test case for v1_tag_groups_update
        修改标签分组  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        tag_group_id = "tag_group_id_example" # str | tag_group_id
        v1_tag_groups_update_request_body = V1TagGroupsUpdateRequestBody(
        tagGroupName="tagGroupName_example",
    ) # V1TagGroupsUpdateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 修改标签分组
            resp = self.api.v1_tag_groups_update(app_token, tag_group_id, v1_tag_groups_update_request_body)
            print("TestCase AddrbkTagsApi->v1_tag_groups_update: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tag_groups_update: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 修改标签分组
            resp = self.api.v1_tag_groups_update(app_token, tag_group_id, v1_tag_groups_update_request_body, user_token=user_token)
            print("TestCase AddrbkTagsApi->v1_tag_groups_update: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tag_groups_update: %s\n" % e)
        '''


    def test_v1_tags_create(self):
        """Test case for v1_tags_create
        创建标签  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v1_tags_create_request_body = V1TagsCreateRequestBody(
        tagGroupId="tagGroupId_example",
        tagName="tagName_example",
    ) # V1TagsCreateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 创建标签
            resp = self.api.v1_tags_create(app_token, v1_tags_create_request_body)
            print("TestCase AddrbkTagsApi->v1_tags_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tags_create: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 创建标签
            resp = self.api.v1_tags_create(app_token, v1_tags_create_request_body, user_token=user_token)
            print("TestCase AddrbkTagsApi->v1_tags_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tags_create: %s\n" % e)
        '''


    def test_v1_tags_delete(self):
        """Test case for v1_tags_delete
        删除标签  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        tagid = "tagid_example" # str | tagid
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 删除标签
            resp = self.api.v1_tags_delete(app_token, tagid)
            print("TestCase AddrbkTagsApi->v1_tags_delete: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tags_delete: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 删除标签
            resp = self.api.v1_tags_delete(app_token, tagid, user_token=user_token)
            print("TestCase AddrbkTagsApi->v1_tags_delete: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tags_delete: %s\n" % e)
        '''


    def test_v1_tags_meta_fetch(self):
        """Test case for v1_tags_meta_fetch
        获取标签详情  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v1_tags_meta_fetch_request_body = V1TagsMetaFetchRequestBody(
        tagIds=[
            "tagIds_example",
        ],
    ) # V1TagsMetaFetchRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取标签详情
            resp = self.api.v1_tags_meta_fetch(app_token, v1_tags_meta_fetch_request_body)
            print("TestCase AddrbkTagsApi->v1_tags_meta_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tags_meta_fetch: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取标签详情
            resp = self.api.v1_tags_meta_fetch(app_token, v1_tags_meta_fetch_request_body, user_token=user_token)
            print("TestCase AddrbkTagsApi->v1_tags_meta_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tags_meta_fetch: %s\n" % e)
        '''


    def test_v1_tags_update(self):
        """Test case for v1_tags_update
        修改标签  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        tagid = "tagid_example" # str | tagid
        v1_tags_update_request_body = V1TagsUpdateRequestBody(
        tagName="tagName_example",
    ) # V1TagsUpdateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 修改标签
            resp = self.api.v1_tags_update(app_token, tagid, v1_tags_update_request_body)
            print("TestCase AddrbkTagsApi->v1_tags_update: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tags_update: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 修改标签
            resp = self.api.v1_tags_update(app_token, tagid, v1_tags_update_request_body, user_token=user_token)
            print("TestCase AddrbkTagsApi->v1_tags_update: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkTagsApi->v1_tags_update: %s\n" % e)
        '''



if __name__ == '__main__':
    unittest.main()
