"""
    LanXin+ OpenAPI

    LanXin+ OpenAPI Platform  # noqa: E501

    Generated by: https://openapi.lanxin.cn
"""

import unittest

from pprint import pprint
try:
    import lanxinplus_openapi
except ImportError:
    import sys
    sys.path.append(sys.argv[0].replace("\\test\\test_addrbk_staff_api.py", "\\"))  # noqa: E501
    import lanxinplus_openapi
from lanxinplus_openapi.api.addrbk_staff_api import AddrbkStaffApi  # noqa: E501
from lanxinplus_openapi import Configuration
from lanxinplus_openapi.model.v1_org_extra_field_ids_fetch_response import V1OrgExtraFieldIdsFetchResponse
from lanxinplus_openapi.model.v1_staffs_create_request_body import V1StaffsCreateRequestBody
from lanxinplus_openapi.model.v1_staffs_create_response import V1StaffsCreateResponse
from lanxinplus_openapi.model.v1_staffs_delete_response import V1StaffsDeleteResponse
from lanxinplus_openapi.model.v1_staffs_dept_ancestors_fetch_response import V1StaffsDeptAncestorsFetchResponse
from lanxinplus_openapi.model.v1_staffs_fetch_response import V1StaffsFetchResponse
from lanxinplus_openapi.model.v1_staffs_infor_fetch_response import V1StaffsInforFetchResponse
from lanxinplus_openapi.model.v1_staffs_update_request_body import V1StaffsUpdateRequestBody
from lanxinplus_openapi.model.v1_staffs_update_response import V1StaffsUpdateResponse
from lanxinplus_openapi.model.v1_tags_fetch_request_body import V1TagsFetchRequestBody
from lanxinplus_openapi.model.v1_tags_fetch_response import V1TagsFetchResponse
from lanxinplus_openapi.model.v2_staffs_id_mapping_fetch_response import V2StaffsIdMappingFetchResponse
from lanxinplus_openapi.model.v2_staffs_search_request_body import V2StaffsSearchRequestBody
from lanxinplus_openapi.model.v2_staffs_search_response import V2StaffsSearchResponse
from lanxinplus_openapi.model.resume import Resume
from lanxinplus_openapi.model.u_department import UDepartment
from lanxinplus_openapi.model.mobile_phone import MobilePhone
from lanxinplus_openapi.model.introduction import Introduction
from lanxinplus_openapi.model.tag_filter import TagFilter
from lanxinplus_openapi.model.search_scope import SearchScope
from lanxinplus_openapi.api.auth_api import AuthApi


class TestAddrbkStaffApi(unittest.TestCase):
    """AddrbkStaffApi unit test stubs"""

    @classmethod
    def setUpClass(cls):
        # 蓝信开放平台网关地址, e.g.: https://example.com/open/apigw
        host = "host"
        # 应用ID, e.g.: 1234567-7654321
        app_id = "app_id"
        # 应用密钥, e.g.: D25F65E65D887AEFD9C92B00310286FA
        app_secret = "app_secret"

        cls.config = Configuration(host, app_id, app_secret)
        # Configuration.set_default(cls.config)
        cls.client = lanxinplus_openapi.ApiClient(configuration=cls.config)
        cls.api = AddrbkStaffApi(api_client=cls.client)  # noqa: E501
        # get app_token
        try:
            api = AuthApi(api_client=cls.client)
            resp = api.v1_app_token_create("client_credential", cls.config.app_id, cls.config.app_secret)
            if resp.errCode == 0:
                cls.config.set_app_token(resp.data.appToken, resp.data.expiresIn)
            else:
                raise lanxinplus_openapi.ApiException(reason=resp.errMsg)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AuthApi->v1_apptoken_create: %s\n" % e)


    @classmethod
    def tearDownClass(cls):
        pass

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_v1_org_extra_field_ids_fetch(self):
        """Test case for v1_org_extra_field_ids_fetch
        获取人员信息扩展字段id列表  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        orgid = "orgid_example" # str | orgid
        user_token = self.config.user_token # str | user_token (optional)
        page = 1 # int | 起始页码从1开始,默认值为1 (optional)
        page_size = 1 # int | 每页显示个数，默认值是1000，最大值是100000 (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取人员信息扩展字段id列表
            resp = self.api.v1_org_extra_field_ids_fetch(app_token, orgid)
            print("TestCase AddrbkStaffApi->v1_org_extra_field_ids_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_org_extra_field_ids_fetch: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取人员信息扩展字段id列表
            resp = self.api.v1_org_extra_field_ids_fetch(app_token, orgid, user_token=user_token, page=page, page_size=page_size)
            print("TestCase AddrbkStaffApi->v1_org_extra_field_ids_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_org_extra_field_ids_fetch: %s\n" % e)
        '''


    def test_v1_staffs_create(self):
        """Test case for v1_staffs_create
        创建人员  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v1_staffs_create_request_body = V1StaffsCreateRequestBody(
        address="address_example",
        avatarId="avatarId_example",
        avatarUrl="avatarUrl_example",
        birthdate="birthdate_example",
        career=[
            Resume(
                description="description_example",
                endDate="endDate_example",
                startDate="startDate_example",
                unit="unit_example",
            ),
        ],
        departments=[
            UDepartment(
                id="id_example",
                orderNumber=1,
            ),
        ],
        disablePasswordReset=True,
        duties="duties_example",
        education=[
            Resume(
                description="description_example",
                endDate="endDate_example",
                startDate="startDate_example",
                unit="unit_example",
            ),
        ],
        email="email_example",
        employeeNumber="employeeNumber_example",
        extAttr1="extAttr1_example",
        extAttr2="extAttr2_example",
        externalId="externalId_example",
        extraFieldSet={
            "key": "key_example",
        },
        extraPhones=[
            MobilePhone(
                countryCode="countryCode_example",
                number="number_example",
            ),
        ],
        gender=1,
        idNumber="idNumber_example",
        introduction=Introduction(
            introduction="introduction_example",
            mediaIds=[
                "mediaIds_example",
            ],
        ),
        loginName="loginName_example",
        loginPassword="loginPassword_example",
        loginWays=[
            1,
        ],
        mobilePhone=MobilePhone(
            countryCode="countryCode_example",
            number="number_example",
        ),
        name="name_example",
        nationality="nationality_example",
        nativePlace="nativePlace_example",
        orgId="orgId_example",
        parties="parties_example",
        signature="signature_example",
        smsInvitation=True,
        status=1,
        tags=[
            "tags_example",
        ],
    ) # V1StaffsCreateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 创建人员
            resp = self.api.v1_staffs_create(app_token, v1_staffs_create_request_body)
            print("TestCase AddrbkStaffApi->v1_staffs_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_create: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 创建人员
            resp = self.api.v1_staffs_create(app_token, v1_staffs_create_request_body, user_token=user_token)
            print("TestCase AddrbkStaffApi->v1_staffs_create: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_create: %s\n" % e)
        '''


    def test_v1_staffs_delete(self):
        """Test case for v1_staffs_delete
        人员删除接口  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        staffid = "staffid_example" # str | 人员 id
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 人员删除接口
            resp = self.api.v1_staffs_delete(app_token, staffid)
            print("TestCase AddrbkStaffApi->v1_staffs_delete: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_delete: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 人员删除接口
            resp = self.api.v1_staffs_delete(app_token, staffid, user_token=user_token)
            print("TestCase AddrbkStaffApi->v1_staffs_delete: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_delete: %s\n" % e)
        '''


    def test_v1_staffs_dept_ancestors_fetch(self):
        """Test case for v1_staffs_dept_ancestors_fetch
        获取人员分支祖先列表  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        staffid = "staffid_example" # str | staffid
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取人员分支祖先列表
            resp = self.api.v1_staffs_dept_ancestors_fetch(app_token, staffid)
            print("TestCase AddrbkStaffApi->v1_staffs_dept_ancestors_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_dept_ancestors_fetch: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取人员分支祖先列表
            resp = self.api.v1_staffs_dept_ancestors_fetch(app_token, staffid, user_token=user_token)
            print("TestCase AddrbkStaffApi->v1_staffs_dept_ancestors_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_dept_ancestors_fetch: %s\n" % e)
        '''


    def test_v1_staffs_fetch(self):
        """Test case for v1_staffs_fetch
        获取人员基本信息  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        staffid = "staffid_example" # str | staffid
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取人员基本信息
            resp = self.api.v1_staffs_fetch(app_token, staffid)
            print("TestCase AddrbkStaffApi->v1_staffs_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_fetch: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取人员基本信息
            resp = self.api.v1_staffs_fetch(app_token, staffid, user_token=user_token)
            print("TestCase AddrbkStaffApi->v1_staffs_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_fetch: %s\n" % e)
        '''


    def test_v1_staffs_infor_fetch(self):
        """Test case for v1_staffs_infor_fetch
        获取人员详细信息  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        staffid = "staffid_example" # str | staffid
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取人员详细信息
            resp = self.api.v1_staffs_infor_fetch(app_token, staffid)
            print("TestCase AddrbkStaffApi->v1_staffs_infor_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_infor_fetch: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取人员详细信息
            resp = self.api.v1_staffs_infor_fetch(app_token, staffid, user_token=user_token)
            print("TestCase AddrbkStaffApi->v1_staffs_infor_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_infor_fetch: %s\n" % e)
        '''


    def test_v1_staffs_update(self):
        """Test case for v1_staffs_update
        更新人员  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        staffid = "staffid_example" # str | 人员 id
        v1_staffs_update_request_body = V1StaffsUpdateRequestBody(
        address="address_example",
        avatarId="avatarId_example",
        birthdate="birthdate_example",
        career=[
            Resume(
                description="description_example",
                endDate="endDate_example",
                startDate="startDate_example",
                unit="unit_example",
            ),
        ],
        departments=[
            UDepartment(
                id="id_example",
                orderNumber=1,
            ),
        ],
        duties="duties_example",
        education=[
            Resume(
                description="description_example",
                endDate="endDate_example",
                startDate="startDate_example",
                unit="unit_example",
            ),
        ],
        email="email_example",
        employeeNumber="employeeNumber_example",
        extAttr1="extAttr1_example",
        extAttr2="extAttr2_example",
        externalId="externalId_example",
        extraFieldSet={},
        extraPhones=[
            MobilePhone(
                countryCode="countryCode_example",
                number="number_example",
            ),
        ],
        gender=1,
        idNumber="idNumber_example",
        introduction=Introduction(
            introduction="introduction_example",
            mediaIds=[
                "mediaIds_example",
            ],
        ),
        loginName="loginName_example",
        loginWays=[
            1,
        ],
        mobilePhone=MobilePhone(
            countryCode="countryCode_example",
            number="number_example",
        ),
        name="name_example",
        nationality="nationality_example",
        nativePlace="nativePlace_example",
        parties="parties_example",
        signature="signature_example",
        status=1,
        tags=[
            "tags_example",
        ],
    ) # V1StaffsUpdateRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 更新人员
            resp = self.api.v1_staffs_update(app_token, staffid, v1_staffs_update_request_body)
            print("TestCase AddrbkStaffApi->v1_staffs_update: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_update: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 更新人员
            resp = self.api.v1_staffs_update(app_token, staffid, v1_staffs_update_request_body, user_token=user_token)
            print("TestCase AddrbkStaffApi->v1_staffs_update: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_staffs_update: %s\n" % e)
        '''


    def test_v1_tags_fetch(self):
        """Test case for v1_tags_fetch
        通过标签获取人员的id列表  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        v1_tags_fetch_request_body = V1TagsFetchRequestBody(
        orgId="orgId_example",
        tagFilters=[
            TagFilter(
                tags=[
                    "tags_example",
                ],
            ),
        ],
    ) # V1TagsFetchRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)
        page = 1 # int | 起始页码从1开始，默认值为1 (optional)
        page_size = 1 # int | 每页显示个数，默认值是1000，最大值是100000 (optional)

        # example passing only required values which don't have defaults set
        try:
            # 通过标签获取人员的id列表
            resp = self.api.v1_tags_fetch(app_token, v1_tags_fetch_request_body)
            print("TestCase AddrbkStaffApi->v1_tags_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_tags_fetch: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 通过标签获取人员的id列表
            resp = self.api.v1_tags_fetch(app_token, v1_tags_fetch_request_body, user_token=user_token, page=page, page_size=page_size)
            print("TestCase AddrbkStaffApi->v1_tags_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v1_tags_fetch: %s\n" % e)
        '''


    def test_v2_staffs_id_mapping_fetch(self):
        """Test case for v2_staffs_id_mapping_fetch
        获取人员详细信息  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        org_id = "org_id_example" # str | 查询人员所在的组织Id
        id_type = "id_type_example" # str | employ_id/mobile/mail/login/external_id
        id_value = "id_value_example" # str | id_type 对应的值：人员编号，手机号...
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 获取人员详细信息
            resp = self.api.v2_staffs_id_mapping_fetch(app_token, org_id, id_type, id_value)
            print("TestCase AddrbkStaffApi->v2_staffs_id_mapping_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v2_staffs_id_mapping_fetch: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 获取人员详细信息
            resp = self.api.v2_staffs_id_mapping_fetch(app_token, org_id, id_type, id_value, user_token=user_token)
            print("TestCase AddrbkStaffApi->v2_staffs_id_mapping_fetch: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v2_staffs_id_mapping_fetch: %s\n" % e)
        '''


    def test_v2_staffs_search(self):
        """Test case for v2_staffs_search
        搜索人员  # noqa: E501
        """
        
        app_token = self.config.app_token # str | app_token
        user_id = "user_id_example" # str | user_id
        v2_staffs_search_request_body = V2StaffsSearchRequestBody(
        keyword="keyword_example",
        recursive=True,
        searchScope=SearchScope(
            orgIds=[
                "orgIds_example",
            ],
            sectorIds=[
                "sectorIds_example",
            ],
        ),
    ) # V2StaffsSearchRequestBody | Request Body
        user_token = self.config.user_token # str | user_token (optional)

        # example passing only required values which don't have defaults set
        try:
            # 搜索人员
            resp = self.api.v2_staffs_search(app_token, user_id, v2_staffs_search_request_body)
            print("TestCase AddrbkStaffApi->v2_staffs_search: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)
        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v2_staffs_search: %s\n" % e)

        '''
        # example passing only required values which don't have defaults set
        # and optional values
        try:
            # 搜索人员
            resp = self.api.v2_staffs_search(app_token, user_id, v2_staffs_search_request_body, user_token=user_token)
            print("TestCase AddrbkStaffApi->v2_staffs_search: ")
            pprint(resp)
            self.assertEqual(resp.errCode, 0)

        except lanxinplus_openapi.ApiException as e:
            print("Exception when calling AddrbkStaffApi->v2_staffs_search: %s\n" % e)
        '''



if __name__ == '__main__':
    unittest.main()
