"""
    LanXin+ OpenAPI

    LanXin+ OpenAPI Platform  # noqa: E501

    Generated by: https://openapi.lanxin.cn
"""


import re  # noqa: F401
import sys  # noqa: F401

from lanxinplus_openapi.api_client import ApiClient, Endpoint as _Endpoint
from lanxinplus_openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from lanxinplus_openapi.model.v1_org_role_create_request_body import V1OrgRoleCreateRequestBody
from lanxinplus_openapi.model.v1_org_role_create_response import V1OrgRoleCreateResponse
from lanxinplus_openapi.model.v1_org_role_members_fetch_response import V1OrgRoleMembersFetchResponse
from lanxinplus_openapi.model.v1_role_member_create_request_body import V1RoleMemberCreateRequestBody
from lanxinplus_openapi.model.v1_role_member_create_response import V1RoleMemberCreateResponse
from lanxinplus_openapi.model.v1_role_member_delete_request_body import V1RoleMemberDeleteRequestBody
from lanxinplus_openapi.model.v1_role_member_delete_response import V1RoleMemberDeleteResponse


class RoleApi(object):
    """NOTE: This class is auto generated by LanXin+
    Ref: https://openapi.lanxin.cn

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1_org_role_create_endpoint = _Endpoint(
            settings={
                'response_type': (V1OrgRoleCreateResponse,),
                'auth': [],
                'endpoint_path': '/v1/org/{orgid}/role/create',
                'operation_id': 'v1_org_role_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'orgid',
                    'v1_org_role_create_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'orgid',
                    'v1_org_role_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'orgid':
                        (str,),
                    'v1_org_role_create_request_body':
                        (V1OrgRoleCreateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'orgid': 'orgid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'orgid': 'path',
                    'v1_org_role_create_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_org_role_members_fetch_endpoint = _Endpoint(
            settings={
                'response_type': (V1OrgRoleMembersFetchResponse,),
                'auth': [],
                'endpoint_path': '/v1/org/{orgid}/role/{roleid}/members/fetch',
                'operation_id': 'v1_org_role_members_fetch',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'orgid',
                    'roleid',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'orgid',
                    'roleid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'orgid':
                        (str,),
                    'roleid':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'orgid': 'orgid',
                    'roleid': 'roleid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'orgid': 'path',
                    'roleid': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_role_member_create_endpoint = _Endpoint(
            settings={
                'response_type': (V1RoleMemberCreateResponse,),
                'auth': [],
                'endpoint_path': '/v1/rolemember/create',
                'operation_id': 'v1_role_member_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'v1_role_member_create_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'v1_role_member_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'v1_role_member_create_request_body':
                        (V1RoleMemberCreateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'v1_role_member_create_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_role_member_delete_endpoint = _Endpoint(
            settings={
                'response_type': (V1RoleMemberDeleteResponse,),
                'auth': [],
                'endpoint_path': '/v1/rolemember/{rolememberid}/delete',
                'operation_id': 'v1_role_member_delete',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'rolememberid',
                    'v1_role_member_delete_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'rolememberid',
                    'v1_role_member_delete_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'rolememberid':
                        (str,),
                    'v1_role_member_delete_request_body':
                        (V1RoleMemberDeleteRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'rolememberid': 'rolememberid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'rolememberid': 'path',
                    'v1_role_member_delete_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def v1_org_role_create(
        self,
        app_token,
        orgid,
        v1_org_role_create_request_body,
        **kwargs
    ):
        """创建角色  # noqa: E501

        创建角色  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_org_role_create(app_token, orgid, v1_org_role_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            orgid (str): orgid
            v1_org_role_create_request_body (V1OrgRoleCreateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1OrgRoleCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['orgid'] = \
            orgid
        kwargs['v1_org_role_create_request_body'] = \
            v1_org_role_create_request_body
        return self.v1_org_role_create_endpoint.call_with_http_info(**kwargs)

    def v1_org_role_members_fetch(
        self,
        app_token,
        orgid,
        roleid,
        **kwargs
    ):
        """获取应用运营者列表  # noqa: E501

        获取对接组织里面某个角色的成员列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_org_role_members_fetch(app_token, orgid, roleid, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            orgid (str): orgid
            roleid (str): roleid

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1OrgRoleMembersFetchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['orgid'] = \
            orgid
        kwargs['roleid'] = \
            roleid
        return self.v1_org_role_members_fetch_endpoint.call_with_http_info(**kwargs)

    def v1_role_member_create(
        self,
        app_token,
        v1_role_member_create_request_body,
        **kwargs
    ):
        """添加角色成员  # noqa: E501

        添加角色成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_role_member_create(app_token, v1_role_member_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            v1_role_member_create_request_body (V1RoleMemberCreateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1RoleMemberCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['v1_role_member_create_request_body'] = \
            v1_role_member_create_request_body
        return self.v1_role_member_create_endpoint.call_with_http_info(**kwargs)

    def v1_role_member_delete(
        self,
        app_token,
        rolememberid,
        v1_role_member_delete_request_body,
        **kwargs
    ):
        """删除角色成员  # noqa: E501

        删除角色成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_role_member_delete(app_token, rolememberid, v1_role_member_delete_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            rolememberid (str): rolememberid
            v1_role_member_delete_request_body (V1RoleMemberDeleteRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1RoleMemberDeleteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['rolememberid'] = \
            rolememberid
        kwargs['v1_role_member_delete_request_body'] = \
            v1_role_member_delete_request_body
        return self.v1_role_member_delete_endpoint.call_with_http_info(**kwargs)

