"""
    LanXin+ OpenAPI

    LanXin+ OpenAPI Platform  # noqa: E501

    Generated by: https://openapi.lanxin.cn
"""


import re  # noqa: F401
import sys  # noqa: F401

from lanxinplus_openapi.api_client import ApiClient, Endpoint as _Endpoint
from lanxinplus_openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from lanxinplus_openapi.model.v1_chat_notification_fetch_response import V1ChatNotificationFetchResponse
from lanxinplus_openapi.model.v1_messages_create_request_body import V1MessagesCreateRequestBody
from lanxinplus_openapi.model.v1_messages_create_response import V1MessagesCreateResponse
from lanxinplus_openapi.model.v1_messages_notification_create_request_body import V1MessagesNotificationCreateRequestBody
from lanxinplus_openapi.model.v1_messages_notification_create_response import V1MessagesNotificationCreateResponse
from lanxinplus_openapi.model.v1_messages_revoke_request_body import V1MessagesRevokeRequestBody
from lanxinplus_openapi.model.v1_messages_revoke_response import V1MessagesRevokeResponse
from lanxinplus_openapi.model.v2_chat_notification_update_request_body import V2ChatNotificationUpdateRequestBody
from lanxinplus_openapi.model.v2_chat_notification_update_response import V2ChatNotificationUpdateResponse
from lanxinplus_openapi.model.v2_event_notification_create_request_body import V2EventNotificationCreateRequestBody
from lanxinplus_openapi.model.v2_event_notification_create_response import V2EventNotificationCreateResponse


class MessageApi(object):
    """NOTE: This class is auto generated by LanXin+
    Ref: https://openapi.lanxin.cn

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1_chat_notification_fetch_endpoint = _Endpoint(
            settings={
                'response_type': (V1ChatNotificationFetchResponse,),
                'auth': [],
                'endpoint_path': '/v1/chat/notification/{userid}/fetch',
                'operation_id': 'v1_chat_notification_fetch',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'userid',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'userid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'userid':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'userid': 'userid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'userid': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_messages_create_endpoint = _Endpoint(
            settings={
                'response_type': (V1MessagesCreateResponse,),
                'auth': [],
                'endpoint_path': '/v1/messages/create',
                'operation_id': 'v1_messages_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'v1_messages_create_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'v1_messages_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'v1_messages_create_request_body':
                        (V1MessagesCreateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'v1_messages_create_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_messages_notification_create_endpoint = _Endpoint(
            settings={
                'response_type': (V1MessagesNotificationCreateResponse,),
                'auth': [],
                'endpoint_path': '/v1/messages/notification/create',
                'operation_id': 'v1_messages_notification_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'v1_messages_notification_create_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'v1_messages_notification_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'v1_messages_notification_create_request_body':
                        (V1MessagesNotificationCreateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'v1_messages_notification_create_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_messages_revoke_endpoint = _Endpoint(
            settings={
                'response_type': (V1MessagesRevokeResponse,),
                'auth': [],
                'endpoint_path': '/v1/messages/revoke',
                'operation_id': 'v1_messages_revoke',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'v1_messages_revoke_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'v1_messages_revoke_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'v1_messages_revoke_request_body':
                        (V1MessagesRevokeRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'v1_messages_revoke_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v2_chat_notification_update_endpoint = _Endpoint(
            settings={
                'response_type': (V2ChatNotificationUpdateResponse,),
                'auth': [],
                'endpoint_path': '/v2/chat/notification/update',
                'operation_id': 'v2_chat_notification_update',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'v2_chat_notification_update_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'v2_chat_notification_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'v2_chat_notification_update_request_body':
                        (V2ChatNotificationUpdateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'v2_chat_notification_update_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v2_event_notification_create_endpoint = _Endpoint(
            settings={
                'response_type': (V2EventNotificationCreateResponse,),
                'auth': [],
                'endpoint_path': '/v2/event/notification/create',
                'operation_id': 'v2_event_notification_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'v2_event_notification_create_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'v2_event_notification_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'v2_event_notification_create_request_body':
                        (V2EventNotificationCreateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'v2_event_notification_create_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def v1_chat_notification_fetch(
        self,
        app_token,
        userid,
        **kwargs
    ):
        """获取通知消息会话状态  # noqa: E501

        获取通知消息会话状态  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_chat_notification_fetch(app_token, userid, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            userid (str): userid

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1ChatNotificationFetchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['userid'] = \
            userid
        return self.v1_chat_notification_fetch_endpoint.call_with_http_info(**kwargs)

    def v1_messages_create(
        self,
        app_token,
        v1_messages_create_request_body,
        **kwargs
    ):
        """发送应用消息应用号通道  # noqa: E501

        通过该接口，应用可以给指定的人和分支发送系统定义的几种消息。适用于绝大多数应用消息通知场景，消息卡片中可携带链接，支持点击跳转应用详情页  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_messages_create(app_token, v1_messages_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            v1_messages_create_request_body (V1MessagesCreateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1MessagesCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['v1_messages_create_request_body'] = \
            v1_messages_create_request_body
        return self.v1_messages_create_endpoint.call_with_http_info(**kwargs)

    def v1_messages_notification_create(
        self,
        app_token,
        v1_messages_notification_create_request_body,
        **kwargs
    ):
        """发送通知消息  # noqa: E501

        通过该接口，应用可以给指定人发送通知消息。 特别说明：该消息类型仅展示会话列表摘要，不展示会话消息详情，点击会话摘要直接跳转应用首页入口。仅适用于通知，邮件等特定代办数量&摘要类型的消息场景。普通办公类卡片消息不建议使用该接口  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_messages_notification_create(app_token, v1_messages_notification_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            v1_messages_notification_create_request_body (V1MessagesNotificationCreateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1MessagesNotificationCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['v1_messages_notification_create_request_body'] = \
            v1_messages_notification_create_request_body
        return self.v1_messages_notification_create_endpoint.call_with_http_info(**kwargs)

    def v1_messages_revoke(
        self,
        app_token,
        v1_messages_revoke_request_body,
        **kwargs
    ):
        """撤回消息  # noqa: E501

        通过该接口，应用可以撤回已发送消息，消息撤回有时效性，并非所有消息都可以撤回。目前私聊和群聊只能撤回5分钟内发送的消息，应用消息（公号通道）可以撤回24小时内的消息  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_messages_revoke(app_token, v1_messages_revoke_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            v1_messages_revoke_request_body (V1MessagesRevokeRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1MessagesRevokeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['v1_messages_revoke_request_body'] = \
            v1_messages_revoke_request_body
        return self.v1_messages_revoke_endpoint.call_with_http_info(**kwargs)

    def v2_chat_notification_update(
        self,
        app_token,
        v2_chat_notification_update_request_body,
        **kwargs
    ):
        """更新通知消息会话状态（批量）  # noqa: E501

        更新通知消息会话状态（批量）  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v2_chat_notification_update(app_token, v2_chat_notification_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            v2_chat_notification_update_request_body (V2ChatNotificationUpdateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V2ChatNotificationUpdateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['v2_chat_notification_update_request_body'] = \
            v2_chat_notification_update_request_body
        return self.v2_chat_notification_update_endpoint.call_with_http_info(**kwargs)

    def v2_event_notification_create(
        self,
        app_token,
        v2_event_notification_create_request_body,
        **kwargs
    ):
        """发送应用消息应用号通道  # noqa: E501

        通过该接口，应用可以给指定的人和分支发送系统定义的几种消息。适用于绝大多数应用消息通知场景，消息卡片中可携带链接，支持点击跳转应用详情页  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v2_event_notification_create(app_token, v2_event_notification_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            v2_event_notification_create_request_body (V2EventNotificationCreateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V2EventNotificationCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['v2_event_notification_create_request_body'] = \
            v2_event_notification_create_request_body
        return self.v2_event_notification_create_endpoint.call_with_http_info(**kwargs)

