"""
    LanXin+ OpenAPI

    LanXin+ OpenAPI Platform  # noqa: E501

    Generated by: https://openapi.lanxin.cn
"""


import re  # noqa: F401
import sys  # noqa: F401

from lanxinplus_openapi.api_client import ApiClient, Endpoint as _Endpoint
from lanxinplus_openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from lanxinplus_openapi.model.v1_medias_create_response import V1MediasCreateResponse
from lanxinplus_openapi.model.v1_medias_path_fetch_response import V1MediasPathFetchResponse


class MediaApi(object):
    """NOTE: This class is auto generated by LanXin+
    Ref: https://openapi.lanxin.cn

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1_medias_create_endpoint = _Endpoint(
            settings={
                'response_type': (V1MediasCreateResponse,),
                'auth': [],
                'endpoint_path': '/v1/medias/create',
                'operation_id': 'v1_medias_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'type',
                    'media',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'type',
                    'media',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'type':
                        (str,),
                    'media':
                        (file_type,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'type': 'type',
                    'media': 'media',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'type': 'query',
                    'media': 'form',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.v1_medias_fetch_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [],
                'endpoint_path': '/v1/medias/{mediaid}/fetch',
                'operation_id': 'v1_medias_fetch',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'mediaid',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'mediaid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'mediaid':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'mediaid': 'mediaid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'mediaid': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'image/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_medias_path_fetch_endpoint = _Endpoint(
            settings={
                'response_type': (V1MediasPathFetchResponse,),
                'auth': [],
                'endpoint_path': '/v1/medias/{mediaid}/path/fetch',
                'operation_id': 'v1_medias_path_fetch',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'mediaid',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'mediaid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'mediaid':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'mediaid': 'mediaid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'mediaid': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def v1_medias_create(
        self,
        app_token,
        type,
        media,
        **kwargs
    ):
        """上传文件  # noqa: E501

        文件上传，获取对应的 MEDIA ID（文件大小不能超过2M）  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_medias_create(app_token, type, media, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            type (str): 文件类型。取值：VIDEO = 1;IMAGE = 2;AUDIO = 3;
            media (file_type): Media Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1MediasCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['type'] = \
            type
        kwargs['media'] = \
            media
        return self.v1_medias_create_endpoint.call_with_http_info(**kwargs)

    def v1_medias_fetch(
        self,
        app_token,
        mediaid,
        **kwargs
    ):
        """下载文件  # noqa: E501

        根据media id 获取文件下载内容  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_medias_fetch(app_token, mediaid, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            mediaid (str): mediaid

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['mediaid'] = \
            mediaid
        return self.v1_medias_fetch_endpoint.call_with_http_info(**kwargs)

    def v1_medias_path_fetch(
        self,
        app_token,
        mediaid,
        **kwargs
    ):
        """获取文件下载路径  # noqa: E501

        获取文件下载路径  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_medias_path_fetch(app_token, mediaid, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            mediaid (str): mediaid

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1MediasPathFetchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['mediaid'] = \
            mediaid
        return self.v1_medias_path_fetch_endpoint.call_with_http_info(**kwargs)

