"""
    LanXin+ OpenAPI

    LanXin+ OpenAPI Platform  # noqa: E501

    Generated by: https://openapi.lanxin.cn
"""


import re  # noqa: F401
import sys  # noqa: F401

from lanxinplus_openapi.api_client import ApiClient, Endpoint as _Endpoint
from lanxinplus_openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from lanxinplus_openapi.model.v1_app_roaming_orgs_fetch_response import V1AppRoamingOrgsFetchResponse


class AppmgeApi(object):
    """NOTE: This class is auto generated by LanXin+
    Ref: https://openapi.lanxin.cn

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1_app_roaming_orgs_fetch_endpoint = _Endpoint(
            settings={
                'response_type': (V1AppRoamingOrgsFetchResponse,),
                'auth': [],
                'endpoint_path': '/v1/app/roaming/orgs/fetch',
                'operation_id': 'v1_app_roaming_orgs_fetch',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'page_size',
                    'base_version',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'page_size',
                    'base_version',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'page_size':
                        (int,),
                    'base_version':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'page_size': 'page_size',
                    'base_version': 'base_version',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'page_size': 'query',
                    'base_version': 'query',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def v1_app_roaming_orgs_fetch(
        self,
        app_token,
        page_size,
        base_version,
        **kwargs
    ):
        """获取应用已安装到的组织列表  # noqa: E501

        获取应用已安装到的组织列表，支持按时间增量和分页  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_app_roaming_orgs_fetch(app_token, page_size, base_version, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            page_size (int): 分页返回最大数据量，最大限制1000条，大于1000按1000条返回
            base_version (str): 增量请求的起始时间版本号，时间戳字符串，单位：微秒

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1AppRoamingOrgsFetchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['page_size'] = \
            page_size
        kwargs['base_version'] = \
            base_version
        return self.v1_app_roaming_orgs_fetch_endpoint.call_with_http_info(**kwargs)

