"""
    LanXin+ OpenAPI

    LanXin+ OpenAPI Platform  # noqa: E501

    Generated by: https://openapi.lanxin.cn
"""


import re  # noqa: F401
import sys  # noqa: F401

from lanxinplus_openapi.api_client import ApiClient, Endpoint as _Endpoint
from lanxinplus_openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from lanxinplus_openapi.model.v1_tag_groups_create_request_body import V1TagGroupsCreateRequestBody
from lanxinplus_openapi.model.v1_tag_groups_create_response import V1TagGroupsCreateResponse
from lanxinplus_openapi.model.v1_tag_groups_delete_response import V1TagGroupsDeleteResponse
from lanxinplus_openapi.model.v1_tag_groups_fetch_request_body import V1TagGroupsFetchRequestBody
from lanxinplus_openapi.model.v1_tag_groups_fetch_response import V1TagGroupsFetchResponse
from lanxinplus_openapi.model.v1_tag_groups_info_fetch_response import V1TagGroupsInfoFetchResponse
from lanxinplus_openapi.model.v1_tag_groups_update_request_body import V1TagGroupsUpdateRequestBody
from lanxinplus_openapi.model.v1_tag_groups_update_response import V1TagGroupsUpdateResponse
from lanxinplus_openapi.model.v1_tags_create_request_body import V1TagsCreateRequestBody
from lanxinplus_openapi.model.v1_tags_create_response import V1TagsCreateResponse
from lanxinplus_openapi.model.v1_tags_delete_response import V1TagsDeleteResponse
from lanxinplus_openapi.model.v1_tags_meta_fetch_request_body import V1TagsMetaFetchRequestBody
from lanxinplus_openapi.model.v1_tags_meta_fetch_response import V1TagsMetaFetchResponse
from lanxinplus_openapi.model.v1_tags_update_request_body import V1TagsUpdateRequestBody
from lanxinplus_openapi.model.v1_tags_update_response import V1TagsUpdateResponse


class AddrbkTagsApi(object):
    """NOTE: This class is auto generated by LanXin+
    Ref: https://openapi.lanxin.cn

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1_tag_groups_create_endpoint = _Endpoint(
            settings={
                'response_type': (V1TagGroupsCreateResponse,),
                'auth': [],
                'endpoint_path': '/v1/taggroups/create',
                'operation_id': 'v1_tag_groups_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'v1_tag_groups_create_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'v1_tag_groups_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'v1_tag_groups_create_request_body':
                        (V1TagGroupsCreateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'v1_tag_groups_create_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_tag_groups_delete_endpoint = _Endpoint(
            settings={
                'response_type': (V1TagGroupsDeleteResponse,),
                'auth': [],
                'endpoint_path': '/v1/taggroups/{tag_group_id}/delete',
                'operation_id': 'v1_tag_groups_delete',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'tag_group_id',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'tag_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'tag_group_id':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'tag_group_id': 'tag_group_id',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'tag_group_id': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_tag_groups_fetch_endpoint = _Endpoint(
            settings={
                'response_type': (V1TagGroupsFetchResponse,),
                'auth': [],
                'endpoint_path': '/v1/taggroups/fetch',
                'operation_id': 'v1_tag_groups_fetch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'v1_tag_groups_fetch_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'v1_tag_groups_fetch_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'v1_tag_groups_fetch_request_body':
                        (V1TagGroupsFetchRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'v1_tag_groups_fetch_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_tag_groups_info_fetch_endpoint = _Endpoint(
            settings={
                'response_type': (V1TagGroupsInfoFetchResponse,),
                'auth': [],
                'endpoint_path': '/v1/taggroups/{tag_group_id}/fetch',
                'operation_id': 'v1_tag_groups_info_fetch',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'tag_group_id',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'tag_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'tag_group_id':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'tag_group_id': 'tag_group_id',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'tag_group_id': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_tag_groups_update_endpoint = _Endpoint(
            settings={
                'response_type': (V1TagGroupsUpdateResponse,),
                'auth': [],
                'endpoint_path': '/v1/taggroups/{tag_group_id}/update',
                'operation_id': 'v1_tag_groups_update',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'tag_group_id',
                    'v1_tag_groups_update_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'tag_group_id',
                    'v1_tag_groups_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'tag_group_id':
                        (str,),
                    'v1_tag_groups_update_request_body':
                        (V1TagGroupsUpdateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'tag_group_id': 'tag_group_id',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'tag_group_id': 'path',
                    'v1_tag_groups_update_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_tags_create_endpoint = _Endpoint(
            settings={
                'response_type': (V1TagsCreateResponse,),
                'auth': [],
                'endpoint_path': '/v1/tags/create',
                'operation_id': 'v1_tags_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'v1_tags_create_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'v1_tags_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'v1_tags_create_request_body':
                        (V1TagsCreateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'v1_tags_create_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_tags_delete_endpoint = _Endpoint(
            settings={
                'response_type': (V1TagsDeleteResponse,),
                'auth': [],
                'endpoint_path': '/v1/tags/{tagid}/delete',
                'operation_id': 'v1_tags_delete',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'tagid',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'tagid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'tagid':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'tagid': 'tagid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'tagid': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_tags_meta_fetch_endpoint = _Endpoint(
            settings={
                'response_type': (V1TagsMetaFetchResponse,),
                'auth': [],
                'endpoint_path': '/v1/tags/meta/fetch',
                'operation_id': 'v1_tags_meta_fetch',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'v1_tags_meta_fetch_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'v1_tags_meta_fetch_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'v1_tags_meta_fetch_request_body':
                        (V1TagsMetaFetchRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'v1_tags_meta_fetch_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_tags_update_endpoint = _Endpoint(
            settings={
                'response_type': (V1TagsUpdateResponse,),
                'auth': [],
                'endpoint_path': '/v1/tags/{tagid}/update',
                'operation_id': 'v1_tags_update',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'tagid',
                    'v1_tags_update_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'tagid',
                    'v1_tags_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'tagid':
                        (str,),
                    'v1_tags_update_request_body':
                        (V1TagsUpdateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'tagid': 'tagid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'tagid': 'path',
                    'v1_tags_update_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def v1_tag_groups_create(
        self,
        app_token,
        v1_tag_groups_create_request_body,
        **kwargs
    ):
        """创建标签分组  # noqa: E501

        创建标签分组  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_tag_groups_create(app_token, v1_tag_groups_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            v1_tag_groups_create_request_body (V1TagGroupsCreateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1TagGroupsCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['v1_tag_groups_create_request_body'] = \
            v1_tag_groups_create_request_body
        return self.v1_tag_groups_create_endpoint.call_with_http_info(**kwargs)

    def v1_tag_groups_delete(
        self,
        app_token,
        tag_group_id,
        **kwargs
    ):
        """删除标签分组  # noqa: E501

        删除标签分组  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_tag_groups_delete(app_token, tag_group_id, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            tag_group_id (str): tag_group_id

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1TagGroupsDeleteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['tag_group_id'] = \
            tag_group_id
        return self.v1_tag_groups_delete_endpoint.call_with_http_info(**kwargs)

    def v1_tag_groups_fetch(
        self,
        app_token,
        v1_tag_groups_fetch_request_body,
        **kwargs
    ):
        """获取标签分组列表  # noqa: E501

        获取标签分组列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_tag_groups_fetch(app_token, v1_tag_groups_fetch_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            v1_tag_groups_fetch_request_body (V1TagGroupsFetchRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1TagGroupsFetchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['v1_tag_groups_fetch_request_body'] = \
            v1_tag_groups_fetch_request_body
        return self.v1_tag_groups_fetch_endpoint.call_with_http_info(**kwargs)

    def v1_tag_groups_info_fetch(
        self,
        app_token,
        tag_group_id,
        **kwargs
    ):
        """获取标签分组详情  # noqa: E501

        获取标签分组详情  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_tag_groups_info_fetch(app_token, tag_group_id, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            tag_group_id (str): tag_group_id

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1TagGroupsInfoFetchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['tag_group_id'] = \
            tag_group_id
        return self.v1_tag_groups_info_fetch_endpoint.call_with_http_info(**kwargs)

    def v1_tag_groups_update(
        self,
        app_token,
        tag_group_id,
        v1_tag_groups_update_request_body,
        **kwargs
    ):
        """修改标签分组  # noqa: E501

        修改标签分组  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_tag_groups_update(app_token, tag_group_id, v1_tag_groups_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            tag_group_id (str): tag_group_id
            v1_tag_groups_update_request_body (V1TagGroupsUpdateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1TagGroupsUpdateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['tag_group_id'] = \
            tag_group_id
        kwargs['v1_tag_groups_update_request_body'] = \
            v1_tag_groups_update_request_body
        return self.v1_tag_groups_update_endpoint.call_with_http_info(**kwargs)

    def v1_tags_create(
        self,
        app_token,
        v1_tags_create_request_body,
        **kwargs
    ):
        """创建标签  # noqa: E501

        创建标签  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_tags_create(app_token, v1_tags_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            v1_tags_create_request_body (V1TagsCreateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1TagsCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['v1_tags_create_request_body'] = \
            v1_tags_create_request_body
        return self.v1_tags_create_endpoint.call_with_http_info(**kwargs)

    def v1_tags_delete(
        self,
        app_token,
        tagid,
        **kwargs
    ):
        """删除标签  # noqa: E501

        删除标签  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_tags_delete(app_token, tagid, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            tagid (str): tagid

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1TagsDeleteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['tagid'] = \
            tagid
        return self.v1_tags_delete_endpoint.call_with_http_info(**kwargs)

    def v1_tags_meta_fetch(
        self,
        app_token,
        v1_tags_meta_fetch_request_body,
        **kwargs
    ):
        """获取标签详情  # noqa: E501

        获取标签详情  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_tags_meta_fetch(app_token, v1_tags_meta_fetch_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            v1_tags_meta_fetch_request_body (V1TagsMetaFetchRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1TagsMetaFetchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['v1_tags_meta_fetch_request_body'] = \
            v1_tags_meta_fetch_request_body
        return self.v1_tags_meta_fetch_endpoint.call_with_http_info(**kwargs)

    def v1_tags_update(
        self,
        app_token,
        tagid,
        v1_tags_update_request_body,
        **kwargs
    ):
        """修改标签  # noqa: E501

        修改标签  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_tags_update(app_token, tagid, v1_tags_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            tagid (str): tagid
            v1_tags_update_request_body (V1TagsUpdateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1TagsUpdateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['tagid'] = \
            tagid
        kwargs['v1_tags_update_request_body'] = \
            v1_tags_update_request_body
        return self.v1_tags_update_endpoint.call_with_http_info(**kwargs)

