"""
    LanXin+ OpenAPI

    LanXin+ OpenAPI Platform  # noqa: E501

    Generated by: https://openapi.lanxin.cn
"""


import re  # noqa: F401
import sys  # noqa: F401

from lanxinplus_openapi.api_client import ApiClient, Endpoint as _Endpoint
from lanxinplus_openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from lanxinplus_openapi.model.v1_depts_children_fetch_response import V1DeptsChildrenFetchResponse
from lanxinplus_openapi.model.v1_depts_create_request_body import V1DeptsCreateRequestBody
from lanxinplus_openapi.model.v1_depts_create_response import V1DeptsCreateResponse
from lanxinplus_openapi.model.v1_depts_delete_response import V1DeptsDeleteResponse
from lanxinplus_openapi.model.v1_depts_fetch_response import V1DeptsFetchResponse
from lanxinplus_openapi.model.v1_depts_staffs_create_response import V1DeptsStaffsCreateResponse
from lanxinplus_openapi.model.v1_depts_staffs_delete_response import V1DeptsStaffsDeleteResponse
from lanxinplus_openapi.model.v1_depts_staffs_fetch_response import V1DeptsStaffsFetchResponse
from lanxinplus_openapi.model.v1_depts_update_request_body import V1DeptsUpdateRequestBody
from lanxinplus_openapi.model.v1_depts_update_response import V1DeptsUpdateResponse


class AddrbkDepartmentApi(object):
    """NOTE: This class is auto generated by LanXin+
    Ref: https://openapi.lanxin.cn

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1_depts_children_fetch_endpoint = _Endpoint(
            settings={
                'response_type': (V1DeptsChildrenFetchResponse,),
                'auth': [],
                'endpoint_path': '/v1/departments/{departmentid}/children/fetch',
                'operation_id': 'v1_depts_children_fetch',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'departmentid',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'departmentid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'departmentid':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'departmentid': 'departmentid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'departmentid': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_depts_create_endpoint = _Endpoint(
            settings={
                'response_type': (V1DeptsCreateResponse,),
                'auth': [],
                'endpoint_path': '/v1/departments/create',
                'operation_id': 'v1_depts_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'v1_depts_create_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'v1_depts_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'v1_depts_create_request_body':
                        (V1DeptsCreateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'v1_depts_create_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_depts_delete_endpoint = _Endpoint(
            settings={
                'response_type': (V1DeptsDeleteResponse,),
                'auth': [],
                'endpoint_path': '/v1/departments/{departmentid}/delete',
                'operation_id': 'v1_depts_delete',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'departmentid',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'departmentid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'departmentid':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'departmentid': 'departmentid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'departmentid': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_depts_fetch_endpoint = _Endpoint(
            settings={
                'response_type': (V1DeptsFetchResponse,),
                'auth': [],
                'endpoint_path': '/v1/departments/{departmentid}/fetch',
                'operation_id': 'v1_depts_fetch',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'departmentid',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'departmentid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'departmentid':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'departmentid': 'departmentid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'departmentid': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_depts_staffs_create_endpoint = _Endpoint(
            settings={
                'response_type': (V1DeptsStaffsCreateResponse,),
                'auth': [],
                'endpoint_path': '/v1/departments/{departmentid}/staffs/{staffid}/create',
                'operation_id': 'v1_depts_staffs_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'departmentid',
                    'staffid',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'departmentid',
                    'staffid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'departmentid':
                        (str,),
                    'staffid':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'departmentid': 'departmentid',
                    'staffid': 'staffid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'departmentid': 'path',
                    'staffid': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_depts_staffs_delete_endpoint = _Endpoint(
            settings={
                'response_type': (V1DeptsStaffsDeleteResponse,),
                'auth': [],
                'endpoint_path': '/v1/departments/{departmentid}/staffs/{staffid}/delete',
                'operation_id': 'v1_depts_staffs_delete',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'departmentid',
                    'staffid',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'departmentid',
                    'staffid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'departmentid':
                        (str,),
                    'staffid':
                        (str,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'departmentid': 'departmentid',
                    'staffid': 'staffid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'departmentid': 'path',
                    'staffid': 'path',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_depts_staffs_fetch_endpoint = _Endpoint(
            settings={
                'response_type': (V1DeptsStaffsFetchResponse,),
                'auth': [],
                'endpoint_path': '/v1/departments/{departmentid}/staffs/fetch',
                'operation_id': 'v1_depts_staffs_fetch',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'departmentid',
                    'user_token',
                    'page',
                    'page_size',
                ],
                'required': [
                    'app_token',
                    'departmentid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'departmentid':
                        (str,),
                    'user_token':
                        (str,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'departmentid': 'departmentid',
                    'user_token': 'user_token',
                    'page': 'page',
                    'page_size': 'page_size',
                },
                'location_map': {
                    'app_token': 'query',
                    'departmentid': 'path',
                    'user_token': 'query',
                    'page': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_depts_update_endpoint = _Endpoint(
            settings={
                'response_type': (V1DeptsUpdateResponse,),
                'auth': [],
                'endpoint_path': '/v1/departments/{departmentid}/update',
                'operation_id': 'v1_depts_update',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_token',
                    'departmentid',
                    'v1_depts_update_request_body',
                    'user_token',
                ],
                'required': [
                    'app_token',
                    'departmentid',
                    'v1_depts_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_token':
                        (str,),
                    'departmentid':
                        (str,),
                    'v1_depts_update_request_body':
                        (V1DeptsUpdateRequestBody,),
                    'user_token':
                        (str,),
                },
                'attribute_map': {
                    'app_token': 'app_token',
                    'departmentid': 'departmentid',
                    'user_token': 'user_token',
                },
                'location_map': {
                    'app_token': 'query',
                    'departmentid': 'path',
                    'v1_depts_update_request_body': 'body',
                    'user_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def v1_depts_children_fetch(
        self,
        app_token,
        departmentid,
        **kwargs
    ):
        """获取子分支列表  # noqa: E501

        获取子分支列表，只获取一层  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_depts_children_fetch(app_token, departmentid, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            departmentid (str): departmentid

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1DeptsChildrenFetchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['departmentid'] = \
            departmentid
        return self.v1_depts_children_fetch_endpoint.call_with_http_info(**kwargs)

    def v1_depts_create(
        self,
        app_token,
        v1_depts_create_request_body,
        **kwargs
    ):
        """创建分支  # noqa: E501

        创建分支。接口需要拥有对应的授权。仅组织内应用经过授权可以调用该接口  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_depts_create(app_token, v1_depts_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            v1_depts_create_request_body (V1DeptsCreateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1DeptsCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['v1_depts_create_request_body'] = \
            v1_depts_create_request_body
        return self.v1_depts_create_endpoint.call_with_http_info(**kwargs)

    def v1_depts_delete(
        self,
        app_token,
        departmentid,
        **kwargs
    ):
        """删除分支  # noqa: E501

        删除分支，仅组织内应用经过授权可以调用该接口  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_depts_delete(app_token, departmentid, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            departmentid (str): departmentid

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1DeptsDeleteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['departmentid'] = \
            departmentid
        return self.v1_depts_delete_endpoint.call_with_http_info(**kwargs)

    def v1_depts_fetch(
        self,
        app_token,
        departmentid,
        **kwargs
    ):
        """获取分支详情  # noqa: E501

        获取分支详情信息  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_depts_fetch(app_token, departmentid, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            departmentid (str): departmentid

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1DeptsFetchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['departmentid'] = \
            departmentid
        return self.v1_depts_fetch_endpoint.call_with_http_info(**kwargs)

    def v1_depts_staffs_create(
        self,
        app_token,
        departmentid,
        staffid,
        **kwargs
    ):
        """添加分支成员  # noqa: E501

        为指定分支添加成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_depts_staffs_create(app_token, departmentid, staffid, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            departmentid (str): departmentid
            staffid (str): staffid

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1DeptsStaffsCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['departmentid'] = \
            departmentid
        kwargs['staffid'] = \
            staffid
        return self.v1_depts_staffs_create_endpoint.call_with_http_info(**kwargs)

    def v1_depts_staffs_delete(
        self,
        app_token,
        departmentid,
        staffid,
        **kwargs
    ):
        """删除分支成员  # noqa: E501

        删除分支成员，仅组织内应用经过授权可以调用该接口  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_depts_staffs_delete(app_token, departmentid, staffid, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            departmentid (str): departmentid
            staffid (str): staffid

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1DeptsStaffsDeleteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['departmentid'] = \
            departmentid
        kwargs['staffid'] = \
            staffid
        return self.v1_depts_staffs_delete_endpoint.call_with_http_info(**kwargs)

    def v1_depts_staffs_fetch(
        self,
        app_token,
        departmentid,
        **kwargs
    ):
        """获取分支成员列表  # noqa: E501

        根据分支ID 获取分支成员列表，目前只返回当前分支下的成员，不含子分支的成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_depts_staffs_fetch(app_token, departmentid, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            departmentid (str): departmentid

        Keyword Args:
            user_token (str): user_token. [optional]
            page (int): 起始页码从1开始，默认值为1. [optional]
            page_size (int): 每页显示个数，默认值是100，最大值是100. [optional]

        Returns:
            V1DeptsStaffsFetchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['departmentid'] = \
            departmentid
        return self.v1_depts_staffs_fetch_endpoint.call_with_http_info(**kwargs)

    def v1_depts_update(
        self,
        app_token,
        departmentid,
        v1_depts_update_request_body,
        **kwargs
    ):
        """更新分支  # noqa: E501

        更新分支信息，接口需要拥有授权。仅组织内应用经过授权可以调用该接口  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_depts_update(app_token, departmentid, v1_depts_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            app_token (str): app_token
            departmentid (str): departmentid
            v1_depts_update_request_body (V1DeptsUpdateRequestBody): Request Body

        Keyword Args:
            user_token (str): user_token. [optional]

        Returns:
            V1DeptsUpdateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_token'] = \
            app_token
        kwargs['departmentid'] = \
            departmentid
        kwargs['v1_depts_update_request_body'] = \
            v1_depts_update_request_body
        return self.v1_depts_update_endpoint.call_with_http_info(**kwargs)

