# stackl-client
stackl

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.2.0rc1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import stackl_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import stackl_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import stackl_client
from stackl_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = stackl_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with stackl_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = stackl_client.AboutApi(api_client)
    
    try:
        # Get Hostname
        api_response = api_instance.get_hostname()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AboutApi->get_hostname: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AboutApi* | [**get_hostname**](docs/AboutApi.md#get_hostname) | **GET** /about | Get Hostname
*FunctionalRequirementsApi* | [**delete_functional_requirement**](docs/FunctionalRequirementsApi.md#delete_functional_requirement) | **DELETE** /functional_requirements/{name} | Delete Functional Requirement
*FunctionalRequirementsApi* | [**get_functional_requirement_by_name**](docs/FunctionalRequirementsApi.md#get_functional_requirement_by_name) | **GET** /functional_requirements/{name} | Get Functional Requirement By Name
*FunctionalRequirementsApi* | [**get_functional_requirements**](docs/FunctionalRequirementsApi.md#get_functional_requirements) | **GET** /functional_requirements | Get Functional Requirements
*FunctionalRequirementsApi* | [**post_functional_requirement**](docs/FunctionalRequirementsApi.md#post_functional_requirement) | **POST** /functional_requirements | Post Functional Requirement
*FunctionalRequirementsApi* | [**put_functional_requirement**](docs/FunctionalRequirementsApi.md#put_functional_requirement) | **PUT** /functional_requirements | Put Functional Requirement
*InfrastructureBaseApi* | [**delete_infrastructure_base**](docs/InfrastructureBaseApi.md#delete_infrastructure_base) | **DELETE** /infrastructure_base/{infrastructure_base_type}/{infrastructure_base_name} | Delete Infrastructure Base
*InfrastructureBaseApi* | [**get_infrastructure_base_by_type**](docs/InfrastructureBaseApi.md#get_infrastructure_base_by_type) | **GET** /infrastructure_base/{infrastructure_base_type} | Get Infrastructure Base By Type
*InfrastructureBaseApi* | [**get_infrastructure_base_by_type_and_name**](docs/InfrastructureBaseApi.md#get_infrastructure_base_by_type_and_name) | **GET** /infrastructure_base/{infrastructure_base_type}/{infrastructure_base_name} | Get Infrastructure Base By Type And Name
*InfrastructureBaseApi* | [**post_infrastructure_base**](docs/InfrastructureBaseApi.md#post_infrastructure_base) | **POST** /infrastructure_base | Post Infrastructure Base
*InfrastructureBaseApi* | [**put_infrastructure_base**](docs/InfrastructureBaseApi.md#put_infrastructure_base) | **PUT** /infrastructure_base | Put Infrastructure Base
*PolicyTemplatesApi* | [**get_policy_template_by_name**](docs/PolicyTemplatesApi.md#get_policy_template_by_name) | **GET** /policy_templates/{policy_name} | Get Policy Template By Name
*PolicyTemplatesApi* | [**get_policy_templates**](docs/PolicyTemplatesApi.md#get_policy_templates) | **GET** /policy_templates | Get Policy Templates
*PolicyTemplatesApi* | [**put_policy_template**](docs/PolicyTemplatesApi.md#put_policy_template) | **PUT** /policy_templates | Put Policy Template
*ServicesApi* | [**delete_service**](docs/ServicesApi.md#delete_service) | **DELETE** /services/{name} | Delete Service
*ServicesApi* | [**get_service_by_name**](docs/ServicesApi.md#get_service_by_name) | **GET** /services/{name} | Get Service By Name
*ServicesApi* | [**get_services**](docs/ServicesApi.md#get_services) | **GET** /services | Get Services
*ServicesApi* | [**post_service**](docs/ServicesApi.md#post_service) | **POST** /services | Post Service
*ServicesApi* | [**put_service**](docs/ServicesApi.md#put_service) | **PUT** /services | Put Service
*SnapshotsApi* | [**create_snapshot**](docs/SnapshotsApi.md#create_snapshot) | **POST** /snapshots/{type_name}/{name} | Create Snapshot
*SnapshotsApi* | [**delete_snapshot**](docs/SnapshotsApi.md#delete_snapshot) | **DELETE** /snapshots/{name} | Delete Snapshot
*SnapshotsApi* | [**get_snapshot**](docs/SnapshotsApi.md#get_snapshot) | **GET** /snapshots/{name} | Get Snapshot
*SnapshotsApi* | [**get_snapshots**](docs/SnapshotsApi.md#get_snapshots) | **GET** /snapshots/{type_name}/{name} | Get Snapshots
*SnapshotsApi* | [**restore_latest_snapshot**](docs/SnapshotsApi.md#restore_latest_snapshot) | **POST** /snapshots/restore/{type_name}/{name} | Restore Latest Snapshot
*SnapshotsApi* | [**restore_snapshot**](docs/SnapshotsApi.md#restore_snapshot) | **POST** /snapshots/restore/{name} | Restore Snapshot
*StackApplicationTemplatesApi* | [**delete_stack_application_template**](docs/StackApplicationTemplatesApi.md#delete_stack_application_template) | **DELETE** /stack_application_templates/{name} | Delete Stack Application Template
*StackApplicationTemplatesApi* | [**get_stack_application_template_by_name**](docs/StackApplicationTemplatesApi.md#get_stack_application_template_by_name) | **GET** /stack_application_templates/{name} | Get Stack Application Template By Name
*StackApplicationTemplatesApi* | [**get_stack_application_templates**](docs/StackApplicationTemplatesApi.md#get_stack_application_templates) | **GET** /stack_application_templates | Get Stack Application Templates
*StackApplicationTemplatesApi* | [**post_stack_application_template**](docs/StackApplicationTemplatesApi.md#post_stack_application_template) | **POST** /stack_application_templates | Post Stack Application Template
*StackApplicationTemplatesApi* | [**put_stack_application_template**](docs/StackApplicationTemplatesApi.md#put_stack_application_template) | **PUT** /stack_application_templates | Put Stack Application Template
*StackInfrastructureTemplatesApi* | [**delete_stack_infrastructure_template**](docs/StackInfrastructureTemplatesApi.md#delete_stack_infrastructure_template) | **DELETE** /stack_infrastructure_templates/{name} | Delete Stack Infrastructure Template
*StackInfrastructureTemplatesApi* | [**get_stack_infrastructure_template_by_name**](docs/StackInfrastructureTemplatesApi.md#get_stack_infrastructure_template_by_name) | **GET** /stack_infrastructure_templates/{name} | Get Stack Infrastructure Template By Name
*StackInfrastructureTemplatesApi* | [**get_stack_infrastructure_templates**](docs/StackInfrastructureTemplatesApi.md#get_stack_infrastructure_templates) | **GET** /stack_infrastructure_templates | Get Stack Infrastructure Templates
*StackInfrastructureTemplatesApi* | [**post_stack_infrastructure_template**](docs/StackInfrastructureTemplatesApi.md#post_stack_infrastructure_template) | **POST** /stack_infrastructure_templates | Post Stack Infrastructure Template
*StackInfrastructureTemplatesApi* | [**put_stack_infrastructure_template**](docs/StackInfrastructureTemplatesApi.md#put_stack_infrastructure_template) | **PUT** /stack_infrastructure_templates | Put Stack Infrastructure Template
*StackInstancesApi* | [**delete_stack_instance**](docs/StackInstancesApi.md#delete_stack_instance) | **DELETE** /stack_instances/{name} | Delete Stack Instance
*StackInstancesApi* | [**get_stack_instance**](docs/StackInstancesApi.md#get_stack_instance) | **GET** /stack_instances/{name} | Get Stack Instance
*StackInstancesApi* | [**get_stack_instances**](docs/StackInstancesApi.md#get_stack_instances) | **GET** /stack_instances | Get Stack Instances
*StackInstancesApi* | [**post_stack_instance**](docs/StackInstancesApi.md#post_stack_instance) | **POST** /stack_instances | Post Stack Instance
*StackInstancesApi* | [**put_stack_instance**](docs/StackInstancesApi.md#put_stack_instance) | **PUT** /stack_instances | Put Stack Instance


## Documentation For Models

 - [FunctionalRequirement](docs/FunctionalRequirement.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [InfrastructureBaseDocument](docs/InfrastructureBaseDocument.md)
 - [InfrastructureTarget](docs/InfrastructureTarget.md)
 - [Invocation](docs/Invocation.md)
 - [PolicyTemplate](docs/PolicyTemplate.md)
 - [Service](docs/Service.md)
 - [Snapshot](docs/Snapshot.md)
 - [StackApplicationTemplate](docs/StackApplicationTemplate.md)
 - [StackInfrastructureTemplate](docs/StackInfrastructureTemplate.md)
 - [StackInstance](docs/StackInstance.md)
 - [StackInstanceInvocation](docs/StackInstanceInvocation.md)
 - [StackInstanceService](docs/StackInstanceService.md)
 - [StackInstanceStatus](docs/StackInstanceStatus.md)
 - [StackInstanceUpdate](docs/StackInstanceUpdate.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




