import pytest
import numpy as np
from datetime import datetime as dt

from hdrtools import sunutils

@pytest.mark.parametrize("latitude,longitude,elevation,time,expected_XYZ_position", 
    [
        #(latitude, longitude, elevation, time, expectedXYZ_Position))
    (   46.778969,   -71.274914,          125,"2016-07-20 08:27:57-04:00", (-0.8545596343138477,0.5178934706003236,   -0.038913)),
    (   46.778969,   -71.274914,          125,"2016-07-20 08:27:57-04:00", (-0.8545596505084949,0.5178934451612746,   -0.038913)),
    (   46.778969,   -71.274914,          125,"2016-07-20 08:27:57-04:00", (-0.8545596505084948,0.5178934451612746,   -0.038913)),
    (   46.778969,   -71.274914,          125,"2016-07-20 10:22:05-04:00", (-0.5680513300973935,0.7652950746595142,   -0.302723)),
    (   46.778969,   -71.274914,          125,"2016-07-20 10:22:05-04:00", (-0.5680513583871313,0.7652950571241296,   -0.302723)),
    (   46.778969,   -71.274914,          125,"2016-07-20 10:22:05-04:00", (-0.5680513583871314,0.7652950571241296,   -0.302723)),
    (   46.778969,   -71.274914,          125,"2016-07-20 13:22:16-04:00", (0.1254742396819954,0.8907439690353199,   -0.436843)),
    (   46.778969,   -71.274914,          125,"2016-07-20 13:22:16-04:00", (0.12547420719438215,0.8907439688652493,   -0.436843)),
    (   46.778969,   -71.274914,          125,"2016-07-20 13:22:16-04:00", (0.12547420719438215,0.8907439688652493,   -0.436843)),
    (   46.778969,   -71.274914,          125,"2016-07-20 14:36:20-04:00", (0.41375311680857385,0.8304946606150504,   -0.372944)),
    (   46.778969,   -71.274914,          125,"2016-07-20 14:36:20-04:00", (0.41375308840454816,0.8304946671831276,   -0.372944)),
    (   46.778969,   -71.274914,          125,"2016-07-20 14:36:20-04:00", (0.41375308840454816,0.8304946671831276,   -0.372944)),
    (   46.778969,   -71.274914,          125,"2016-07-20 17:20:31-04:00", (0.8639414636709284,0.5029846213780422,   -0.024731)),
    (   46.778969,   -71.274914,          125,"2016-07-20 17:20:31-04:00", (0.863941453463093,0.5029846375691499,   -0.024731)),
    (   46.778969,   -71.274914,          125,"2016-07-20 17:20:31-04:00", (0.863941453463093,0.5029846375691499,   -0.024731)),
    ]
)
def test_sunutils_sunPositionFromPySolar(latitude,longitude,elevation,time,expected_XYZ_position):
    X,Y,Z = sunutils.sunPositionFromPySolar(latitude,longitude,dt.fromisoformat(time),elevation)
    assert X == pytest.approx(expected_XYZ_position[0],abs=1e-6)
    assert Y == pytest.approx(expected_XYZ_position[1],abs=1e-6)
    assert Z == pytest.approx(expected_XYZ_position[2],abs=1e-6)
