/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.python.util;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CheckWrapperUtil {
    private static Set<String> ObjectMethodNameSet = new HashSet<String>(Arrays.asList("getClass", "wait", "notifyAll", "notify", "hashCode", "equals", "toString"));
    private static Set<String> WithParamsMethodNameSet = new HashSet<String>(Arrays.asList("set", "get", "getParams"));
    private static Set<String> EXCLUDED_METHOD_NAME = new HashSet<String>(Arrays.asList("mapToString"));

    public static boolean checkMethods(String jClassName, String[] pyFuncNames) throws ClassNotFoundException {
        Class<?> cls = Class.forName(jClassName);
        Method[] methods = (Method[])Arrays.stream(cls.getMethods()).filter(d -> Modifier.isPublic(d.getModifiers())).toArray(Method[]::new);
        String[] jMethodNames = (String[])Arrays.stream(methods).map(Method::getName).toArray(String[]::new);
        HashSet<String> jMethodNameSet = new HashSet<String>(Arrays.asList(jMethodNames));
        jMethodNameSet.removeAll(ObjectMethodNameSet);
        jMethodNameSet.removeAll(WithParamsMethodNameSet);
        jMethodNameSet.removeAll(EXCLUDED_METHOD_NAME);
        HashSet<String> pyFuncNameSet = new HashSet<String>(Arrays.asList(pyFuncNames));
        if (!jMethodNameSet.equals(pyFuncNameSet)) {
            System.out.println(jClassName);
            System.out.println(jMethodNameSet);
            System.out.println(pyFuncNameSet);
            System.out.println(Sets.difference(jMethodNameSet, pyFuncNameSet));
            System.out.println(Sets.difference(pyFuncNameSet, jMethodNameSet));
        }
        return jMethodNameSet.equals(pyFuncNameSet);
    }

    public static void main(String[] args) throws ClassNotFoundException {
        boolean res = CheckWrapperUtil.checkMethods("com.alibaba.alink.operator.common.statistics.basicstatistic.CorrelationResult", new String[]{"getCorrelation", "getCorrelationMatrix", "getColNames"});
        System.out.println(res);
    }
}

